/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.util.Collection;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.runtime.BaseRuntimeExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.IFeature;

public class ModelEnablementDescriptor
extends BaseRuntimeExtensionDescriptor {
    public static final String EXTENSION_NAME = "modelEnablement";
    private ModelEnablements modelEnablements;
    private String profileName;
    private String description;

    public ModelEnablementDescriptor(IConfigurationElement e) {
        super(e);
        TargetRuntime rt = TargetRuntime.getRuntime(e);
        this.profileName = e.getAttribute("profile");
        this.description = e.getAttribute("description");
        String ref = e.getAttribute("ref");
        this.modelEnablements = new ModelEnablements(rt, this.id);
        if (ref != null) {
            String[] a = ref.split(":");
            rt = TargetRuntime.getRuntime(a[0]);
            String id = a[1];
            this.initializeFromTargetRuntime(rt, id);
        }
        IConfigurationElement[] iConfigurationElementArray = e.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement c = iConfigurationElementArray[n2];
            String object = c.getAttribute("object");
            String feature = c.getAttribute("feature");
            if (c.getName().equals("enable")) {
                this.setEnabled(object, feature, true);
            } else if (c.getName().equals("disable")) {
                this.setEnabled(object, feature, false);
            }
            ++n2;
        }
    }

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public ModelEnablementDescriptor(TargetRuntime rt, String id) {
        super(rt);
        this.id = id;
        this.modelEnablements = new ModelEnablements(rt, id);
    }

    public void setEnabled(EClass eClass, boolean enabled) {
        this.modelEnablements.setEnabled(eClass, enabled);
    }

    public void setEnabled(String className, boolean enabled) {
        this.modelEnablements.setEnabled(className, enabled);
    }

    public void setEnabled(String className, String featureName, boolean enabled) {
        this.modelEnablements.setEnabled(className, featureName, enabled);
    }

    public void initializeFromTargetRuntime(TargetRuntime rt, String id) {
        for (ModelEnablementDescriptor med : rt.getModelEnablements()) {
            if (!id.equals(med.getId())) continue;
            Collection<String> enabledClasses = med.modelEnablements.getAllEnabledClasses();
            for (String c : enabledClasses) {
                Collection<String> enabledFeatures = med.modelEnablements.getAllEnabledFeatures(c);
                for (String f : enabledFeatures) {
                    this.setEnabled(c, f, true);
                }
            }
        }
    }

    public boolean isEnabled(String className, String featureName) {
        return this.modelEnablements.isEnabled(className, featureName);
    }

    public boolean isEnabled(EClass eClass, EStructuralFeature feature) {
        return this.modelEnablements.isEnabled(eClass, feature);
    }

    public boolean isEnabled(EClass eClass) {
        return this.modelEnablements.isEnabled(eClass);
    }

    public boolean isEnabled(String className) {
        return this.modelEnablements.isEnabled(className);
    }

    public boolean isEnabled(IFeature feature) {
        return this.modelEnablements.isEnabled(feature);
    }

    public Collection<String> getAllEnabled() {
        return this.modelEnablements.getAllEnabled();
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

