/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BoundaryEventPositionHelper;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ICreateService;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.ILayoutService;
import org.eclipse.graphiti.services.IPeService;

public class AnchorUtil {
    public static final int CONNECTION_POINT_SIZE = 4;
    private static final IPeService peService = Graphiti.getPeService();
    private static final IGaService gaService = Graphiti.getGaService();
    private static final ICreateService createService = Graphiti.getCreateService();
    private static final ILayoutService layoutService = Graphiti.getLayoutService();

    public static Point stringToPoint(String s) {
        if (s != null) {
            String[] a = s.split(",");
            try {
                return gaService.createPoint(Integer.parseInt(a[0]), Integer.parseInt(a[1]));
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static String pointToString(Point loc) {
        return String.valueOf(loc.getX()) + "," + loc.getY();
    }

    public static FixPointAnchor createBoundaryAnchor(AnchorContainer ac, AnchorLocation loc, int x, int y) {
        FixPointAnchor anchor = peService.createFixPointAnchor(ac);
        peService.setPropertyValue((PropertyContainer)anchor, "boundary.fixpoint.anchor", loc.getKey());
        anchor.setLocation(gaService.createPoint(x, y));
        gaService.createInvisibleRectangle((PictogramElement)anchor);
        return anchor;
    }

    public static AnchorLocation getBoundaryAnchorLocation(Anchor anchor) {
        String property = peService.getPropertyValue((PropertyContainer)anchor, "boundary.fixpoint.anchor");
        if (property != null && anchor instanceof FixPointAnchor) {
            return AnchorLocation.getLocation(property);
        }
        return null;
    }

    public static FixPointAnchor createAdHocAnchor(AnchorContainer ac, int x, int y) {
        return AnchorUtil.createAdHocAnchor(ac, gaService.createPoint(x, y));
    }

    public static FixPointAnchor createAdHocAnchor(AnchorContainer ac, Point p) {
        FixPointAnchor anchor = peService.createFixPointAnchor(ac);
        peService.setPropertyValue((PropertyContainer)anchor, "boundary.adhoc.anchor", "true");
        anchor.setLocation(p);
        gaService.createInvisibleRectangle((PictogramElement)anchor);
        return anchor;
    }

    public static Map<AnchorLocation, BoundaryAnchor> getConnectionBoundaryAnchors(Shape connectionPointShape) {
        HashMap<AnchorLocation, BoundaryAnchor> map = new HashMap<AnchorLocation, BoundaryAnchor>(4);
        BoundaryAnchor a = new BoundaryAnchor();
        a.anchor = AnchorUtil.getConnectionPointAnchor(connectionPointShape);
        AnchorLocation[] anchorLocationArray = AnchorLocation.values();
        int n = anchorLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnchorLocation al;
            a.locationType = al = anchorLocationArray[n2];
            a.location = AnchorUtil.getConnectionPointLocation(connectionPointShape);
            map.put(a.locationType, a);
            ++n2;
        }
        return map;
    }

    public static Map<AnchorLocation, BoundaryAnchor> getBoundaryAnchors(AnchorContainer ac) {
        HashMap<AnchorLocation, BoundaryAnchor> map = new HashMap<AnchorLocation, BoundaryAnchor>(4);
        if (ac instanceof Connection) {
            Iterator<Shape> iterator = AnchorUtil.getConnectionPoints((Connection)ac).iterator();
            if (iterator.hasNext()) {
                Shape connectionPointShape = iterator.next();
                return AnchorUtil.getConnectionBoundaryAnchors(connectionPointShape);
            }
        } else {
            if (AnchorUtil.isConnectionPoint((PictogramElement)ac)) {
                return AnchorUtil.getConnectionBoundaryAnchors((Shape)ac);
            }
            for (Anchor anchor : ac.getAnchors()) {
                String property = peService.getPropertyValue((PropertyContainer)anchor, "boundary.fixpoint.anchor");
                if (property == null || !(anchor instanceof FixPointAnchor)) continue;
                BoundaryAnchor a = new BoundaryAnchor();
                a.anchor = (FixPointAnchor)anchor;
                a.locationType = AnchorLocation.getLocation(property);
                a.location = peService.getLocationRelativeToDiagram(anchor);
                map.put(a.locationType, a);
            }
        }
        return map;
    }

    public static Point getCenterPoint(Shape s) {
        GraphicsAlgorithm ga = s.getGraphicsAlgorithm();
        ILocation loc = peService.getLocationRelativeToDiagram(s);
        return gaService.createPoint(loc.getX() + ga.getWidth() / 2, loc.getY() + ga.getHeight() / 2);
    }

    public static Tuple<FixPointAnchor, FixPointAnchor> getSourceAndTargetBoundaryAnchors(AnchorContainer source, AnchorContainer target, Connection connection) {
        Point p;
        BoundaryAnchor ba;
        Point p2;
        ILocation loc;
        Map<AnchorLocation, BoundaryAnchor> sourceBoundaryAnchors = AnchorUtil.getBoundaryAnchors(source);
        Map<AnchorLocation, BoundaryAnchor> targetBoundaryAnchors = AnchorUtil.getBoundaryAnchors(target);
        BoundaryAnchor sourceTop = sourceBoundaryAnchors.get((Object)AnchorLocation.TOP);
        BoundaryAnchor sourceBottom = sourceBoundaryAnchors.get((Object)AnchorLocation.BOTTOM);
        BoundaryAnchor sourceLeft = sourceBoundaryAnchors.get((Object)AnchorLocation.LEFT);
        BoundaryAnchor sourceRight = sourceBoundaryAnchors.get((Object)AnchorLocation.RIGHT);
        BoundaryAnchor targetTop = targetBoundaryAnchors.get((Object)AnchorLocation.TOP);
        BoundaryAnchor targetBottom = targetBoundaryAnchors.get((Object)AnchorLocation.BOTTOM);
        BoundaryAnchor targetLeft = targetBoundaryAnchors.get((Object)AnchorLocation.LEFT);
        BoundaryAnchor targetRight = targetBoundaryAnchors.get((Object)AnchorLocation.RIGHT);
        FixPointAnchor newStartAnchor = null;
        FixPointAnchor newEndAnchor = null;
        if (connection == null) {
            Point p1 = GraphicsUtil.getShapeCenter(source);
            Point p22 = GraphicsUtil.getShapeCenter(target);
            newStartAnchor = AnchorUtil.findNearestAnchor(source, p22);
            newEndAnchor = AnchorUtil.findNearestAnchor(target, p1);
            return new Tuple<FixPointAnchor, FixPointAnchor>(newStartAnchor, newEndAnchor);
        }
        Anchor oldStartAnchor = connection.getStart();
        Anchor oldEndAnchor = connection.getEnd();
        if (source == target && connection instanceof FreeFormConnection && oldStartAnchor instanceof FixPointAnchor && oldEndAnchor instanceof FixPointAnchor) {
            return new Tuple<FixPointAnchor, FixPointAnchor>((FixPointAnchor)oldStartAnchor, (FixPointAnchor)oldEndAnchor);
        }
        Point targetLoc = AnchorUtil.stringToPoint(peService.getPropertyValue((PropertyContainer)connection, "connection.target.location"));
        Point sourceLoc = AnchorUtil.stringToPoint(peService.getPropertyValue((PropertyContainer)connection, "connection.source.location"));
        if (targetLoc != null) {
            loc = peService.getLocationRelativeToDiagram((Shape)target);
            p2 = GraphicsUtil.createPoint(targetLoc);
            p2.setX(p2.getX() + loc.getX());
            p2.setY(p2.getY() + loc.getY());
            ba = AnchorUtil.findNearestBoundaryAnchor(target, p2);
            if (AnchorUtil.useAdHocAnchors((PictogramElement)target, connection)) {
                if (ba.locationType == AnchorLocation.TOP) {
                    targetLoc.setY(targetTop.anchor.getLocation().getY());
                } else if (ba.locationType == AnchorLocation.BOTTOM) {
                    targetLoc.setY(targetBottom.anchor.getLocation().getY());
                } else if (ba.locationType == AnchorLocation.LEFT) {
                    targetLoc.setX(targetLeft.anchor.getLocation().getX());
                } else if (ba.locationType == AnchorLocation.RIGHT) {
                    targetLoc.setX(targetRight.anchor.getLocation().getX());
                }
                AnchorUtil.adjustPoint((PictogramElement)target, targetLoc);
                if (peService.getPropertyValue((PropertyContainer)connection, "connection.created") != null && sourceLoc != null) {
                    FixPointAnchor sourceAnchor = newStartAnchor;
                    if (newEndAnchor == targetTop.anchor && sourceAnchor == sourceBottom.anchor || newEndAnchor == targetBottom.anchor && sourceAnchor == sourceTop.anchor) {
                        sourceLoc.setX(targetLoc.getX());
                    } else if (newEndAnchor == targetRight.anchor && sourceAnchor == sourceLeft.anchor || newEndAnchor == targetLeft.anchor && sourceAnchor == sourceRight.anchor) {
                        sourceLoc.setY(targetLoc.getY());
                    }
                    peService.removeProperty((PropertyContainer)connection, "connection.created");
                }
                peService.setPropertyValue((PropertyContainer)connection, "connection.target.location", AnchorUtil.pointToString(targetLoc));
                newEndAnchor = AnchorUtil.createAdHocAnchor(target, targetLoc);
            } else {
                newEndAnchor = ba.anchor;
            }
        } else if (oldEndAnchor instanceof FixPointAnchor) {
            newEndAnchor = (FixPointAnchor)oldEndAnchor;
        } else {
            p = GraphicsUtil.getShapeCenter(source);
            newEndAnchor = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)target, (Point)p).anchor;
        }
        if (sourceLoc != null) {
            loc = peService.getLocationRelativeToDiagram((Shape)source);
            p2 = GraphicsUtil.createPoint(sourceLoc);
            p2.setX(p2.getX() + loc.getX());
            p2.setY(p2.getY() + loc.getY());
            ba = AnchorUtil.findNearestBoundaryAnchor(source, p2);
            if (sourceLoc != null && AnchorUtil.useAdHocAnchors((PictogramElement)source, connection)) {
                if (ba.locationType == AnchorLocation.TOP) {
                    sourceLoc.setY(sourceTop.anchor.getLocation().getY());
                } else if (ba.locationType == AnchorLocation.BOTTOM) {
                    sourceLoc.setY(sourceBottom.anchor.getLocation().getY());
                } else if (ba.locationType == AnchorLocation.LEFT) {
                    sourceLoc.setX(sourceLeft.anchor.getLocation().getX());
                } else if (ba.locationType == AnchorLocation.RIGHT) {
                    sourceLoc.setX(sourceRight.anchor.getLocation().getX());
                }
                AnchorUtil.adjustPoint((PictogramElement)source, sourceLoc);
                newStartAnchor = AnchorUtil.createAdHocAnchor(source, sourceLoc);
                peService.setPropertyValue((PropertyContainer)connection, "connection.source.location", AnchorUtil.pointToString(sourceLoc));
            } else {
                newStartAnchor = ba.anchor;
            }
        } else if (oldStartAnchor instanceof FixPointAnchor) {
            newStartAnchor = (FixPointAnchor)oldStartAnchor;
        } else {
            p = GraphicsUtil.getShapeCenter(target);
            newStartAnchor = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)source, (Point)p).anchor;
        }
        return new Tuple<FixPointAnchor, FixPointAnchor>(newStartAnchor, newEndAnchor);
    }

    private static void adjustPoint(PictogramElement pe, Point p) {
        IDimension size = gaService.calculateSize(pe.getGraphicsAlgorithm());
        if (p.getX() < 0) {
            p.setX(0);
        }
        if (p.getY() < 0) {
            p.setY(0);
        }
        if (p.getX() > size.getWidth()) {
            p.setX(size.getWidth());
        }
        if (p.getY() > size.getHeight()) {
            p.setY(size.getHeight());
        }
    }

    public static FixPointAnchor findNearestAnchor(AnchorContainer ac, Point p1) {
        BoundaryAnchor ba = AnchorUtil.findNearestBoundaryAnchor(ac, p1);
        return ba.anchor;
    }

    public static BoundaryAnchor findNearestBoundaryAnchor(AnchorContainer ac, Point p1) {
        Map<AnchorLocation, BoundaryAnchor> boundaryAnchors = AnchorUtil.getBoundaryAnchors(ac);
        String boundaryEventPos = peService.getPropertyValue((PropertyContainer)ac, "boundary.event.relative.pos");
        if (boundaryEventPos != null) {
            BoundaryEventPositionHelper.PositionOnLine pol = BoundaryEventPositionHelper.PositionOnLine.fromString(boundaryEventPos);
            switch (pol.getLocationType()) {
                case TOP: {
                    boundaryAnchors.remove((Object)AnchorLocation.BOTTOM);
                    boundaryAnchors.remove((Object)AnchorLocation.LEFT);
                    boundaryAnchors.remove((Object)AnchorLocation.RIGHT);
                    break;
                }
                case TOP_LEFT: {
                    boundaryAnchors.remove((Object)AnchorLocation.BOTTOM);
                    boundaryAnchors.remove((Object)AnchorLocation.RIGHT);
                    break;
                }
                case TOP_RIGHT: {
                    boundaryAnchors.remove((Object)AnchorLocation.BOTTOM);
                    boundaryAnchors.remove((Object)AnchorLocation.LEFT);
                    break;
                }
                case BOTTOM: {
                    boundaryAnchors.remove((Object)AnchorLocation.TOP);
                    boundaryAnchors.remove((Object)AnchorLocation.LEFT);
                    boundaryAnchors.remove((Object)AnchorLocation.RIGHT);
                    break;
                }
                case BOTTOM_LEFT: {
                    boundaryAnchors.remove((Object)AnchorLocation.TOP);
                    boundaryAnchors.remove((Object)AnchorLocation.RIGHT);
                    break;
                }
                case BOTTOM_RIGHT: {
                    boundaryAnchors.remove((Object)AnchorLocation.TOP);
                    boundaryAnchors.remove((Object)AnchorLocation.LEFT);
                    break;
                }
                case LEFT: {
                    boundaryAnchors.remove((Object)AnchorLocation.TOP);
                    boundaryAnchors.remove((Object)AnchorLocation.BOTTOM);
                    boundaryAnchors.remove((Object)AnchorLocation.RIGHT);
                    break;
                }
                case RIGHT: {
                    boundaryAnchors.remove((Object)AnchorLocation.TOP);
                    boundaryAnchors.remove((Object)AnchorLocation.BOTTOM);
                    boundaryAnchors.remove((Object)AnchorLocation.LEFT);
                    break;
                }
            }
        }
        double minDist = Double.MAX_VALUE;
        double d1Dist = 0.0;
        BoundaryAnchor nearestBoundaryAnchor = null;
        for (Map.Entry<AnchorLocation, BoundaryAnchor> entry : boundaryAnchors.entrySet()) {
            BoundaryAnchor ba = entry.getValue();
            Point p = GraphicsUtil.createPoint((Anchor)ba.anchor);
            double dist = GraphicsUtil.getLength(p1, p);
            if (!(dist < minDist)) continue;
            double d1 = 0.0;
            switch (ba.locationType) {
                case TOP: {
                    d1 = p.getY() - p1.getY();
                    break;
                }
                case BOTTOM: {
                    d1 = p1.getY() - p.getY();
                    break;
                }
                case LEFT: {
                    d1 = p.getX() - p1.getX();
                    break;
                }
                case RIGHT: {
                    d1 = p1.getX() - p.getX();
                }
            }
            if (nearestBoundaryAnchor == null) {
                d1Dist = d1;
                minDist = dist;
                nearestBoundaryAnchor = ba;
                continue;
            }
            p = GraphicsUtil.createPoint((Anchor)nearestBoundaryAnchor.anchor);
            switch (nearestBoundaryAnchor.locationType) {
                case TOP: {
                    d1Dist = p.getY() - p1.getY();
                    break;
                }
                case BOTTOM: {
                    d1Dist = p1.getY() - p.getY();
                    break;
                }
                case LEFT: {
                    d1Dist = p.getX() - p1.getX();
                    break;
                }
                case RIGHT: {
                    d1Dist = p1.getX() - p.getX();
                }
            }
            if (!(d1 > d1Dist)) continue;
            d1Dist = d1;
            minDist = dist;
            nearestBoundaryAnchor = ba;
        }
        return nearestBoundaryAnchor;
    }

    public static void deleteEmptyAdHocAnchors(AnchorContainer target) {
        if (target != null && !AnchorUtil.isConnectionPoint((PictogramElement)target)) {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            int i = target.getAnchors().size() - 1;
            while (i >= 0) {
                Anchor a = (Anchor)target.getAnchors().get(i);
                if (a instanceof FixPointAnchor && peService.getProperty((PropertyContainer)a, "boundary.fixpoint.anchor") == null && a.getIncomingConnections().isEmpty() && a.getOutgoingConnections().isEmpty()) {
                    indexes.add(i);
                }
                --i;
            }
            Iterator iterator = indexes.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                peService.deletePictogramElement((PictogramElement)target.getAnchors().get(i));
            }
        }
    }

    public static boolean isBoundaryAnchor(Anchor anchor) {
        return anchor instanceof FixPointAnchor && peService.getProperty((PropertyContainer)anchor, "boundary.fixpoint.anchor") != null;
    }

    public static boolean isAdHocAnchor(Anchor anchor) {
        return anchor instanceof FixPointAnchor && peService.getProperty((PropertyContainer)anchor, "boundary.adhoc.anchor") != null;
    }

    public static boolean useAdHocAnchors(PictogramElement pictogramElement, Connection connection) {
        BaseElement baseElement = BusinessObjectUtil.getFirstBaseElement(pictogramElement);
        BaseElement flowElement = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
        return AnchorUtil.useAdHocAnchors(baseElement, flowElement);
    }

    public static boolean useAdHocAnchors(BaseElement baseElement, BaseElement flowElement) {
        return baseElement instanceof Participant || baseElement instanceof SequenceFlow || baseElement instanceof Group;
    }

    public static void addFixedPointAnchors(Shape shape, GraphicsAlgorithm ga) {
        IDimension size = gaService.calculateSize(ga);
        int w = size.getWidth();
        int h = size.getHeight();
        AnchorUtil.createBoundaryAnchor((AnchorContainer)shape, AnchorLocation.TOP, w / 2, 0);
        AnchorUtil.createBoundaryAnchor((AnchorContainer)shape, AnchorLocation.RIGHT, w, h / 2);
        AnchorUtil.createBoundaryAnchor((AnchorContainer)shape, AnchorLocation.BOTTOM, w / 2, h);
        AnchorUtil.createBoundaryAnchor((AnchorContainer)shape, AnchorLocation.LEFT, 0, h / 2);
    }

    public static void relocateFixPointAnchors(Shape shape, int w, int h) {
        Map<AnchorLocation, BoundaryAnchor> anchors = AnchorUtil.getBoundaryAnchors((AnchorContainer)shape);
        FixPointAnchor anchor = anchors.get((Object)((Object)AnchorLocation.TOP)).anchor;
        anchor.setLocation(gaService.createPoint(w / 2, 0));
        anchor = anchors.get((Object)((Object)AnchorLocation.RIGHT)).anchor;
        anchor.setLocation(gaService.createPoint(w, h / 2));
        anchor = anchors.get((Object)((Object)AnchorLocation.BOTTOM)).anchor;
        anchor.setLocation(gaService.createPoint(w / 2, h));
        anchor = anchors.get((Object)((Object)AnchorLocation.LEFT)).anchor;
        anchor.setLocation(gaService.createPoint(0, h / 2));
    }

    public static void deleteConnectionPoint(AnchorContainer shape) {
        if (AnchorUtil.isConnectionPoint((PictogramElement)shape)) {
            Connection connection = AnchorUtil.getConnectionPointOwner(shape);
            if (connection != null) {
                for (Adapter a : shape.eAdapters()) {
                    if (!(a instanceof ConnectionPointShapeAdapter)) continue;
                    connection.eAdapters().remove((Object)a);
                }
                connection.getLink().getBusinessObjects().remove((Object)shape);
            }
            Graphiti.getPeService().deletePictogramElement((PictogramElement)shape);
        }
    }

    public static Shape createConnectionPoint(IFeatureProvider fp, Connection connection, ILocation location) {
        Shape connectionPointShape = null;
        Diagram diagram = fp.getDiagramTypeProvider().getDiagram();
        connectionPointShape = AnchorUtil.createConnectionPoint(location, (ContainerShape)diagram);
        fp.link((PictogramElement)connectionPointShape, (Object)connection);
        connection.getLink().getBusinessObjects().add((Object)connectionPointShape);
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
        BPMNEdge bpmnEdge = DIUtils.findBPMNEdge((EObject)be);
        if (bpmnEdge != null) {
            fp.link((PictogramElement)connectionPointShape, (Object)bpmnEdge);
        }
        ConnectionPointShapeAdapter.adapt(connection, connectionPointShape);
        return connectionPointShape;
    }

    public static Shape createConnectionPoint(ILocation location, ContainerShape cs) {
        Shape connectionPointShape = createService.createShape(cs, true);
        peService.setPropertyValue((PropertyContainer)connectionPointShape, "connection.point.key", "connection.point");
        Ellipse ellipse = createService.createEllipse((GraphicsAlgorithmContainer)connectionPointShape);
        int x = 0;
        int y = 0;
        if (location != null) {
            x = location.getX();
            y = location.getY();
        }
        ellipse.setFilled(Boolean.valueOf(true));
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)connectionPointShape);
        ellipse.setForeground(Graphiti.getGaService().manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
        ellipse.setWidth(4);
        ellipse.setHeight(4);
        AnchorUtil.getConnectionPointAnchor(connectionPointShape);
        AnchorUtil.setConnectionPointLocation(connectionPointShape, x, y);
        return connectionPointShape;
    }

    public static FixPointAnchor getConnectionPointAnchor(Shape connectionPointShape) {
        if (connectionPointShape.getAnchors().size() == 0) {
            FixPointAnchor anchor = createService.createFixPointAnchor((AnchorContainer)connectionPointShape);
            peService.setPropertyValue((PropertyContainer)anchor, "connection.point.key", "connection.point");
            createService.createInvisibleRectangle((PictogramElement)anchor);
        }
        return (FixPointAnchor)connectionPointShape.getAnchors().get(0);
    }

    public static ILocation getConnectionPointLocation(Shape connectionPointShape) {
        ILocation location = ShapeDecoratorUtil.peService.getLocationRelativeToDiagram(connectionPointShape);
        int x = location.getX() + 2;
        int y = location.getY() + 2;
        location.setX(x);
        location.setY(y);
        return location;
    }

    public static void setConnectionPointLocation(Shape connectionPointShape, int x, int y) {
        if (connectionPointShape.getAnchors().size() == 0) {
            layoutService.setLocationAndSize(connectionPointShape.getGraphicsAlgorithm(), x - 2, y - 2, 4, 4);
        } else {
            layoutService.setLocation(connectionPointShape.getGraphicsAlgorithm(), x - 2, y - 2);
        }
        FixPointAnchor anchor = AnchorUtil.getConnectionPointAnchor(connectionPointShape);
        anchor.setLocation(Graphiti.getCreateService().createPoint(2, 2));
        layoutService.setLocation(anchor.getGraphicsAlgorithm(), 2, 2);
    }

    public static List<Shape> getConnectionPoints(Connection connection) {
        ArrayList<Shape> list = new ArrayList<Shape>();
        if (connection.getLink() != null) {
            for (Object o : connection.getLink().getBusinessObjects()) {
                if (!(o instanceof Shape) || !AnchorUtil.isConnectionPoint((PictogramElement)((Shape)o))) continue;
                list.add((Shape)o);
            }
        }
        return list;
    }

    public static boolean isConnectionPoint(PictogramElement pe) {
        if (pe != null) {
            String value = peService.getPropertyValue((PropertyContainer)pe, "connection.point.key");
            return "connection.point".equals(value);
        }
        return false;
    }

    public static Connection getConnectionPointOwner(AnchorContainer connectionPointShape) {
        if (AnchorUtil.isConnectionPoint((PictogramElement)connectionPointShape) && connectionPointShape.getLink() != null) {
            for (Object o : connectionPointShape.getLink().getBusinessObjects()) {
                if (!(o instanceof Connection)) continue;
                return (Connection)o;
            }
        }
        return null;
    }

    public static AnchorLocation findNearestEdge(Shape shape, Point p) {
        return AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)shape, (Point)p).locationType;
    }

    public static enum AnchorLocation {
        TOP("anchor.top"),
        BOTTOM("anchor.bottom"),
        LEFT("anchor.left"),
        RIGHT("anchor.right"),
        CENTER("anchor.center");

        private final String key;

        private AnchorLocation(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static AnchorLocation getLocation(String key) {
            AnchorLocation[] anchorLocationArray = AnchorLocation.values();
            int n = anchorLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnchorLocation l = anchorLocationArray[n2];
                if (l.getKey().equals(key)) {
                    return l;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class AnchorTuple {
        public FixPointAnchor sourceAnchor;
        public FixPointAnchor targetAnchor;
    }

    public static class BoundaryAnchor {
        public FixPointAnchor anchor;
        public AnchorLocation locationType;
        public ILocation location;
    }

    private static class ConnectionPointShapeAdapter
    extends AdapterImpl {
        Connection connection;
        Shape shape;
        boolean deleting = false;
        double midpoint = 0.5;

        public static ConnectionPointShapeAdapter adapt(Connection connection, Shape shape) {
            return new ConnectionPointShapeAdapter(connection, shape);
        }

        private ConnectionPointShapeAdapter(Connection connection, Shape shape) {
            this.connection = connection;
            this.shape = shape;
            connection.eAdapters().add((Object)this);
            shape.eAdapters().add((Object)this);
            ((Anchor)shape.getAnchors().get(0)).eAdapters().add((Object)this);
            this.setTarget((Notifier)connection);
            int x = shape.getGraphicsAlgorithm().getX();
            int y = shape.getGraphicsAlgorithm().getY();
            int dx = Integer.MAX_VALUE;
            int dy = Integer.MAX_VALUE;
            double d = 0.0;
            while (d <= 1.0) {
                ILocation loc = Graphiti.getPeService().getConnectionMidpoint(connection, d);
                if (Math.abs(x - loc.getX()) < dx || Math.abs(y - loc.getY()) < dy) {
                    dx = Math.abs(x - loc.getX());
                    dy = Math.abs(y - loc.getY());
                    this.midpoint = d;
                }
                d += 0.05;
            }
        }

        public void notifyChanged(Notification notification) {
            if (!this.deleting) {
                Anchor a = (Anchor)this.shape.getAnchors().get(0);
                if (notification.getNotifier() == a) {
                    if (a.getIncomingConnections().isEmpty() && a.getOutgoingConnections().isEmpty()) {
                        this.deleting = true;
                        AnchorUtil.deleteConnectionPoint((AnchorContainer)this.shape);
                        return;
                    }
                } else {
                    ILocation loc = Graphiti.getPeService().getConnectionMidpoint(this.connection, this.midpoint);
                    Graphiti.getGaService().setLocation(this.shape.getGraphicsAlgorithm(), loc.getX(), loc.getY());
                }
            }
        }
    }
}

