/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerResourceSetImpl;
import org.eclipse.bpmn2.modeler.core.model.ProxyURIConverterImplExtension;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.validation.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.ValidatorMessage;

public class BPMN2ProjectValidator
extends AbstractValidator {
    private Bpmn2Preferences preferences;
    private TargetRuntime targetRuntime;
    private IFile modelFile;

    public ValidationResult validate(ValidationEvent event, ValidationState state, IProgressMonitor monitor) {
        IResource file = event.getResource();
        if ((event.getKind() & 2) != 0 || file.isDerived(512) || !(file instanceof IFile)) {
            return new ValidationResult();
        }
        this.modelFile = (IFile)file;
        try {
            this.modelFile.deleteMarkers(null, false, 2);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        Bpmn2ModelerResourceSetImpl rs = new Bpmn2ModelerResourceSetImpl();
        this.getTargetRuntime().registerExtensionResourceFactory((ResourceSet)rs);
        URI modelUri = URI.createPlatformResourceURI((String)this.modelFile.getFullPath().toString(), (boolean)true);
        rs.setURIConverter((URIConverter)new ProxyURIConverterImplExtension(modelUri));
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("PROGRESS_MONITOR", monitor);
        rs.setLoadOptions(options);
        Resource resource = rs.createResource(modelUri, "org.eclipse.bpmn2.content-type.xml");
        try {
            resource.load(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ValidationResult result = new ValidationResult();
        if (resource.getContents().isEmpty()) {
            ValidatorMessage message = ValidatorMessage.create((String)Messages.BPMN2ProjectValidator_Invalid_File, (IResource)this.modelFile);
            message.setType(this.getTargetRuntime().getProblemMarkerId());
            result.add(message);
        } else {
            IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
            this.processStatus(validator.validate((Collection)resource.getContents(), monitor), (IResource)this.modelFile, result);
        }
        return result;
    }

    public static void validate(IResource resource, IProgressMonitor monitor) {
        if (BPMN2ProjectValidator.isBPMN2File(resource)) {
            Validator[] validators;
            Validator[] validatorArray = validators = ValidationFramework.getDefault().getValidatorsFor(resource);
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                if (BPMN2ProjectValidator.class.getName().equals(v.getValidatorClassname())) {
                    v.validate(resource, 4, null, monitor);
                    break;
                }
                ++n2;
            }
        }
    }

    public static void validate(IResourceDelta delta, IProgressMonitor monitor) {
        IResource resource = delta.getResource();
        if (BPMN2ProjectValidator.isBPMN2File(resource)) {
            Validator[] validators;
            Validator[] validatorArray = validators = ValidationFramework.getDefault().getValidatorsFor(resource);
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                if (BPMN2ProjectValidator.class.getName().equals(v.getValidatorClassname())) {
                    v.validate(resource, delta.getKind(), null, monitor);
                    break;
                }
                ++n2;
            }
        }
    }

    public static boolean isBPMN2File(IResource resource) {
        if (resource instanceof IFile) {
            try {
                IFile file = (IFile)resource;
                IContentDescription cd = file.getContentDescription();
                if (cd != null) {
                    return "org.eclipse.bpmn2.content-type.xml".equals(cd.getContentType().getId());
                }
                String ext = file.getFileExtension();
                if ("bpmn".equals(ext) || "bpmn2".equals(ext)) {
                    return true;
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static boolean validateOnSave(Resource resource, IProgressMonitor monitor) {
        boolean needValidation = false;
        URI uri = resource.getURI();
        if (uri.isPlatformResource()) {
            String pathString = uri.toPlatformString(true);
            IPath path = Path.fromOSString((String)pathString);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            IProject project = file.getProject();
            if (project != null) {
                try {
                    IProjectNature nature = project.getNature("org.eclipse.bpmn2.modeler.core.bpmn2Nature");
                    if (nature == null) {
                        Bpmn2Preferences preferences = Bpmn2Preferences.getInstance(project);
                        if (preferences.getCheckProjectNature()) {
                            String message;
                            String title;
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialogWithToggle result = MessageDialogWithToggle.open((int)3, (Shell)shell, (String)(title = Messages.BPMN2ProjectValidator_Title), (String)(message = NLS.bind((String)Messages.BPMN2ProjectValidator_No_Project_Nature, (Object)project.getName())), (String)Messages.BPMN2ProjectValidator_Dont_Ask_Again, (boolean)false, null, null, (int)0);
                            if (result.getReturnCode() == 2) {
                                IProjectDescription description = project.getDescription();
                                String[] natures = description.getNatureIds();
                                String[] newNatures = new String[natures.length + 1];
                                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                                newNatures[natures.length] = "org.eclipse.bpmn2.modeler.core.bpmn2Nature";
                                description.setNatureIds(newNatures);
                                project.setDescription(description, null);
                                needValidation = true;
                            }
                            if (result.getToggleState()) {
                                preferences.setCheckProjectNature(false);
                            }
                        }
                    } else {
                        needValidation = true;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (needValidation) {
                return true;
            }
        }
        return false;
    }

    public void processStatus(IStatus status, IResource resource, ValidationResult result) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.processStatus(child, resource, result);
                ++n2;
            }
        } else if (!status.isOK()) {
            result.add(this.createValidationMessage(status, resource));
        }
    }

    public ValidatorMessage createValidationMessage(IStatus status, IResource resource) {
        ValidatorMessage message = ValidatorMessage.create((String)status.getMessage(), (IResource)resource);
        switch (status.getSeverity()) {
            case 1: {
                message.setAttribute("severity", 0);
                break;
            }
            case 2: {
                message.setAttribute("severity", 1);
                break;
            }
            case 4: 
            case 8: {
                message.setAttribute("severity", 2);
            }
        }
        if (status instanceof IConstraintStatus) {
            Object lineNumber;
            IConstraintStatus ics = (IConstraintStatus)status;
            EObject object = ics.getTarget();
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object);
            if (adapter != null && (lineNumber = adapter.getProperty("line.number")) != null) {
                message.setAttribute("lineNumber", lineNumber);
            }
            message.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)object).toString());
            message.setAttribute("rule", (Object)ics.getConstraint().getDescriptor().getId());
            if (ics.getResultLocus().size() > 0) {
                StringBuffer relatedUris = new StringBuffer();
                for (EObject eobject : ics.getResultLocus()) {
                    relatedUris.append(EcoreUtil.getURI((EObject)eobject).toString()).append(" ");
                }
                relatedUris.deleteCharAt(relatedUris.length() - 1);
                String uris = relatedUris.toString();
                message.setAttribute("relatedURIs", (Object)uris);
            }
        }
        message.setType(this.getTargetRuntime().getProblemMarkerId());
        return message;
    }

    public void clean(IProject project, ValidationState state, IProgressMonitor monitor) {
        super.clean(project, state, monitor);
        try {
            project.deleteMarkers(null, false, 2);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    protected TargetRuntime getTargetRuntime() {
        this.targetRuntime = this.getPreferences().getRuntime();
        return this.targetRuntime;
    }

    protected Bpmn2Preferences getPreferences() {
        Assert.isTrue((this.modelFile != null ? 1 : 0) != 0);
        IProject project = this.modelFile.getProject();
        this.loadPreferences(project);
        return this.preferences;
    }

    protected void loadPreferences(IProject project) {
        this.preferences = Bpmn2Preferences.getInstance(project);
    }
}

