/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.examples.dynamic;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.features.CustomShapeFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.IShapeFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.artifact.AddTextAnnotationFeature;
import org.eclipse.bpmn2.modeler.core.features.artifact.UpdateTextAnnotationFeature;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.examples.dynamic.SampleImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.artifact.CreateTextAnnotationFeature;
import org.eclipse.bpmn2.modeler.ui.features.artifact.TextAnnotationFeatureContainer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.util.IColorConstant;

public class SampleCustomTaskFeatureContainer
extends CustomShapeFeatureContainer {
    public static final String MITIGATION_ID = "org.eclipse.bpmn2.modeler.examples.dynamic.mitigation";
    public static final String RISK_ID = "org.eclipse.bpmn2.modeler.examples.dynamic.risk";

    protected IShapeFeatureContainer createFeatureContainer(IFeatureProvider fp) {
        return new TextAnnotationFeatureContainer(){

            public IAddFeature getAddFeature(IFeatureProvider fp) {
                return new AddTextAnnotationFeature(fp){

                    protected void decorateShape(IAddContext context, ContainerShape containerShape, TextAnnotation businessObject) {
                        IGaService gaService = Graphiti.getGaService();
                        IPeService peService = Graphiti.getPeService();
                        Rectangle selectionRect = (Rectangle)containerShape.getGraphicsAlgorithm();
                        int width = 140;
                        int height = 60;
                        selectionRect.setWidth(width);
                        selectionRect.setHeight(height);
                        peService.deletePictogramElement((PictogramElement)containerShape.getChildren().get(0));
                        Shape rectShape = peService.createShape(containerShape, false);
                        peService.sendToBack(rectShape);
                        RoundedRectangle roundedRect = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)rectShape, 5, 5);
                        StyleUtil.applyStyle((GraphicsAlgorithm)roundedRect, (BaseElement)businessObject);
                        gaService.setLocationAndSize((GraphicsAlgorithm)roundedRect, 0, 0, width, height);
                        this.setFillColor(containerShape);
                        Image img = SampleImageProvider.createImage((GraphicsAlgorithmContainer)roundedRect, SampleCustomTaskFeatureContainer.this.customTaskDescriptor, 38, 38);
                        Graphiti.getGaService().setLocation((GraphicsAlgorithm)img, 2, 2);
                        for (PictogramElement pe : containerShape.getChildren()) {
                            GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
                            if (!(ga instanceof MultiText)) continue;
                            Graphiti.getGaService().setLocationAndSize(ga, 40, 2, width - 42, height - 2);
                        }
                    }
                };
            }

            public ICreateFeature getCreateFeature(IFeatureProvider fp) {
                return new CreateTextAnnotationFeature(fp){

                    public TextAnnotation createBusinessObject(ICreateContext context) {
                        TextAnnotation businessObject = (TextAnnotation)super.createBusinessObject(context);
                        return businessObject;
                    }

                    public String getCreateImageId() {
                        return SampleImageProvider.getImageId(SampleCustomTaskFeatureContainer.this.customTaskDescriptor, SampleImageProvider.IconSize.SMALL);
                    }

                    public String getCreateLargeImageId() {
                        return SampleImageProvider.getImageId(SampleCustomTaskFeatureContainer.this.customTaskDescriptor, SampleImageProvider.IconSize.LARGE);
                    }

                    public String getCreateDescription() {
                        return "Create " + SampleCustomTaskFeatureContainer.this.customTaskDescriptor.getName();
                    }
                };
            }

            public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
                return new UpdateTextAnnotationFeature(fp){

                    public IReason updateNeeded(IUpdateContext context) {
                        IReason reason = super.updateNeeded(context);
                        if (reason.toBoolean()) {
                            return reason;
                        }
                        PictogramElement pe = context.getPictogramElement();
                        String propertyValue = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "evaluate.property");
                        if (propertyValue == null || propertyValue.isEmpty()) {
                            propertyValue = "false";
                        }
                        Boolean attributeValue = false;
                        TextAnnotation ta = (TextAnnotation)this.getBusinessObjectForPictogramElement(pe);
                        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)ta);
                        EStructuralFeature f = adapter.getFeature("evaluate");
                        if (f != null && (attributeValue = (Boolean)adapter.getFeatureDescriptor(f).getValue()) == null) {
                            attributeValue = false;
                        }
                        if (Boolean.parseBoolean(propertyValue) != attributeValue) {
                            return Reason.createTrueReason((String)"evalute property changed");
                        }
                        return Reason.createFalseReason((String)"");
                    }

                    public boolean update(IUpdateContext context) {
                        super.update(context);
                        this.setFillColor((ContainerShape)context.getPictogramElement());
                        return true;
                    }
                };
            }

            public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
                return null;
            }

            public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
                return null;
            }

            private void setFillColor(ContainerShape containerShape) {
                TextAnnotation ta = (TextAnnotation)BusinessObjectUtil.getFirstElementOfType((PictogramElement)containerShape, TextAnnotation.class);
                if (ta != null) {
                    String propertyValue;
                    ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)ta);
                    Boolean attributeValue = (Boolean)adapter.getFeatureDescriptor("evaluate").getValue();
                    Shape shape = (Shape)containerShape.getChildren().get(0);
                    ShapeStyle ss = new ShapeStyle();
                    if (Boolean.TRUE.equals(attributeValue)) {
                        propertyValue = Boolean.TRUE.toString();
                        ss.setDefaultColors(IColorConstant.LIGHT_GREEN);
                    } else {
                        propertyValue = Boolean.FALSE.toString();
                        ss.setDefaultColors(IColorConstant.LIGHT_GRAY);
                    }
                    StyleUtil.applyStyle((GraphicsAlgorithm)shape.getGraphicsAlgorithm(), (BaseElement)ta, (ShapeStyle)ss);
                    Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "evaluate.property", propertyValue);
                }
            }
        };
    }

    public String getId(EObject object) {
        if (object instanceof TextAnnotation) {
            if (ModelDecorator.getAnyAttribute((EObject)object, (String)"benefit") != null) {
                return MITIGATION_ID;
            }
            if (ModelDecorator.getAnyAttribute((EObject)object, (String)"cost") != null) {
                return RISK_ID;
            }
        }
        return null;
    }
}

