/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.modeler.ui.diagram.Bpmn2ToolBehaviorProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILayoutService;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractAppendNodeFeature<T extends FlowNode>
extends AbstractCustomFeature {
    protected boolean changesDone = false;
    protected Bpmn2Preferences preferences;
    private static ILabelProvider labelProvider = new ILabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            if (element instanceof ObjectCreationToolEntry) {
                ObjectCreationToolEntry te = (ObjectCreationToolEntry)element;
                return te.getLabel();
            }
            if (element instanceof IPaletteCompartmentEntry) {
                IPaletteCompartmentEntry ce = (IPaletteCompartmentEntry)element;
                return ce.getLabel();
            }
            return "?";
        }

        public Image getImage(Object element) {
            return null;
        }
    };

    public AbstractAppendNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canExecute(ICustomContext context) {
        CreateContext createContext = this.prepareCreateContext(context);
        if (createContext == null) {
            return false;
        }
        List<IToolEntry> tools = this.getTools();
        if (tools.size() == 0) {
            return false;
        }
        for (IToolEntry tool : tools) {
            ICreateFeature feature = ((ObjectCreationToolEntry)tool).getCreateFeature();
            if (feature.canCreate((ICreateContext)createContext)) continue;
            return false;
        }
        return true;
    }

    public boolean isAvailable(IContext context) {
        return this.getTools().size() > 0;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            this.preferences = Bpmn2Preferences.getInstance((EObject)((EObject)bo));
            if (pe instanceof ContainerShape && bo instanceof FlowNode) {
                CreateContext createContext;
                ContainerShape oldShape = (ContainerShape)pe;
                ICreateFeature createFeature = this.selectNewShape();
                if (createFeature != null && createFeature.canCreate((ICreateContext)(createContext = this.prepareCreateContext(context)))) {
                    ContainerShape newShape = this.createNewShape(oldShape, createFeature, createContext);
                    this.createNewConnection(oldShape, newShape);
                    FeatureSupport.updateConnections((IFeatureProvider)this.getFeatureProvider(), (AnchorContainer)newShape);
                    this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer().setPictogramElementForSelection((PictogramElement)newShape);
                    this.changesDone = true;
                }
            }
        }
    }

    protected ICreateFeature selectNewShape() {
        boolean doit;
        Bpmn2ToolBehaviorProvider toolProvider = this.getToolProvider();
        List<IToolEntry> tools = this.getTools();
        ICreateFeature feature = null;
        boolean bl = doit = tools.size() > 0;
        if (doit) {
            LinkedHashMap categories = new LinkedHashMap();
            ArrayList<IToolEntry> uncategorizedTools = new ArrayList<IToolEntry>();
            for (IToolEntry te : tools) {
                IPaletteCompartmentEntry ce = toolProvider.getCategory(te);
                if (ce != null) {
                    List<IToolEntry> categorizedTools;
                    if (categories.containsKey(ce)) {
                        categorizedTools = (List)categories.get(ce);
                    } else {
                        categorizedTools = new ArrayList();
                        categories.put(ce, categorizedTools);
                    }
                    categorizedTools.add(te);
                    continue;
                }
                uncategorizedTools.add(te);
            }
            IToolEntry tool = tools.get(0);
            feature = ((ObjectCreationToolEntry)tool).getCreateFeature();
            if (tools.size() > 1) {
                PopupMenu popupMenu = null;
                if (categories.size() > 1) {
                    ArrayList<PopupMenu.CascadingMenu> cascadingMenus = new ArrayList<PopupMenu.CascadingMenu>();
                    for (Map.Entry entry : categories.entrySet()) {
                        PopupMenu subMenu = new PopupMenu((List)entry.getValue(), labelProvider);
                        PopupMenu.CascadingMenu cascadingMenu = new PopupMenu.CascadingMenu(entry.getKey(), subMenu);
                        cascadingMenus.add(cascadingMenu);
                    }
                    popupMenu = new PopupMenu(cascadingMenus, labelProvider);
                } else {
                    popupMenu = new PopupMenu(tools, labelProvider);
                }
                doit = popupMenu.show((Control)Display.getCurrent().getActiveShell());
                if (doit) {
                    Object result = popupMenu.getResult();
                    if (result instanceof List) {
                        for (Map.Entry o : (List)result) {
                            if (!(o instanceof IToolEntry)) continue;
                            tool = (IToolEntry)o;
                            break;
                        }
                    } else if (result instanceof IToolEntry) {
                        tool = (IToolEntry)result;
                    }
                    feature = ((ObjectCreationToolEntry)tool).getCreateFeature();
                } else {
                    feature = null;
                }
            }
        }
        return feature;
    }

    protected List<EClass> getAvailableTypes() {
        DiagramEditor editor = (DiagramEditor)this.getDiagramEditor();
        ModelEnablements enablements = (ModelEnablements)editor.getAdapter(ModelEnablements.class);
        EClass newType = this.getBusinessObjectClass();
        ArrayList<EClass> subtypes = new ArrayList<EClass>();
        for (EClassifier ec : Bpmn2Package.eINSTANCE.getEClassifiers()) {
            EList superTypes;
            if (!(ec instanceof EClass) || ((EClass)ec).isAbstract() || !(superTypes = ((EClass)ec).getEAllSuperTypes()).contains((Object)newType) || !enablements.isEnabled((EClass)ec) || ec == Bpmn2Package.eINSTANCE.getBoundaryEvent() || ec == Bpmn2Package.eINSTANCE.getStartEvent()) continue;
            subtypes.add((EClass)ec);
        }
        return subtypes;
    }

    protected ContainerShape createNewShape(ContainerShape oldShape, ICreateFeature createFeature, CreateContext createContext) {
        BaseElement oldObject;
        ContainerShape newShape;
        FlowElement newObject;
        ILayoutService layoutService = Graphiti.getLayoutService();
        boolean horz = this.preferences.isHorizontalDefault();
        ILocation loc = layoutService.getLocationRelativeToDiagram((Shape)oldShape);
        int x = loc.getX();
        int y = loc.getY();
        int xOffset = 0;
        int yOffset = 0;
        GraphicsAlgorithm ga = oldShape.getGraphicsAlgorithm();
        int width = ga.getWidth();
        int height = ga.getHeight();
        createContext.setX(0);
        createContext.setY(0);
        Object[] created = createFeature.create((ICreateContext)createContext);
        if (created[0] instanceof List) {
            newObject = (FlowElement)((List)created[0]).get(0);
            newShape = (ContainerShape)((List)created[0]).get(1);
        } else {
            newObject = (FlowElement)created[0];
            newShape = (ContainerShape)created[1];
        }
        ContainerShape containerShape = oldShape.getContainer();
        if (containerShape != this.getDiagram()) {
            loc = layoutService.getLocationRelativeToDiagram((Shape)containerShape);
            xOffset = loc.getX();
            yOffset = loc.getY();
        }
        if ((oldObject = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)oldShape, BaseElement.class)) instanceof Lane) {
            ((Lane)oldObject).getFlowNodeRefs().add((FlowNode)newObject);
        }
        MoveShapeContext moveContext = new MoveShapeContext((Shape)newShape);
        DefaultMoveShapeFeature moveFeature = (DefaultMoveShapeFeature)this.getFeatureProvider().getMoveShapeFeature((IMoveShapeContext)moveContext);
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)newShape);
        int wOffset = 50;
        int hOffset = 50;
        int w = size.getWidth();
        int h = size.getHeight();
        if (horz) {
            x += width + wOffset + w / 2;
            y += height / 2 - h / 2;
            boolean done = false;
            block0: while (!done) {
                done = true;
                List<Shape> shapes = this.getFlowElementChildren(containerShape);
                for (Shape s : shapes) {
                    if (!GraphicsUtil.intersects((Shape)s, (int)(x - w / 2), (int)(y - h / 2), (int)w, (int)h)) continue;
                    y += 100;
                    done = false;
                    continue block0;
                }
            }
        } else {
            x += width / 2 - w / 2;
            y += height + hOffset + h / 2;
            boolean done = false;
            block2: while (!done) {
                done = true;
                List<Shape> shapes = this.getFlowElementChildren(containerShape);
                for (Shape s : shapes) {
                    if (!GraphicsUtil.intersects((Shape)s, (int)(x - w / 2), (int)(y - h / 2), (int)w, (int)h)) continue;
                    x += 100;
                    done = false;
                    continue block2;
                }
            }
        }
        moveContext.setX(x - xOffset);
        moveContext.setY(y - yOffset);
        moveContext.setSourceContainer(oldShape.getContainer());
        moveContext.setTargetContainer(oldShape.getContainer());
        if (moveFeature.canMoveShape((IMoveShapeContext)moveContext)) {
            moveFeature.moveShape((IMoveShapeContext)moveContext);
        }
        return newShape;
    }

    protected List<Shape> getFlowElementChildren(ContainerShape containerShape) {
        ArrayList<Shape> children = new ArrayList<Shape>();
        for (Shape s : containerShape.getChildren()) {
            FlowElement bo = (FlowElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)s, FlowElement.class);
            if (!(s instanceof ContainerShape) || bo == null) continue;
            children.add(s);
        }
        return children;
    }

    protected Connection createNewConnection(ContainerShape oldShape, ContainerShape newShape) {
        Tuple anchors = AnchorUtil.getSourceAndTargetBoundaryAnchors((AnchorContainer)oldShape, (AnchorContainer)newShape, null);
        CreateConnectionContext ccc = new CreateConnectionContext();
        ccc.setSourcePictogramElement((PictogramElement)oldShape);
        ccc.setTargetPictogramElement((PictogramElement)newShape);
        ccc.setSourceAnchor((Anchor)anchors.getFirst());
        ccc.setTargetAnchor((Anchor)anchors.getSecond());
        FlowNode oldObject = (FlowNode)BusinessObjectUtil.getFirstElementOfType((PictogramElement)oldShape, FlowNode.class);
        FlowNode newObject = (FlowNode)BusinessObjectUtil.getFirstElementOfType((PictogramElement)newShape, FlowNode.class);
        SequenceFlow sequenceFlow = (SequenceFlow)Bpmn2ModelerFactory.create((Resource)oldObject.eResource(), SequenceFlow.class);
        FlowElementsContainer container = (FlowElementsContainer)oldObject.eContainer();
        container.getFlowElements().add(sequenceFlow);
        sequenceFlow.setSourceRef(oldObject);
        sequenceFlow.setTargetRef(newObject);
        sequenceFlow.setName(null);
        AddConnectionContext acc = new AddConnectionContext(ccc.getSourceAnchor(), ccc.getTargetAnchor());
        acc.setNewObject((Object)sequenceFlow);
        Connection connection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)acc);
        return connection;
    }

    protected Bpmn2ToolBehaviorProvider getToolProvider() {
        IToolBehaviorProvider[] toolProviders;
        IToolBehaviorProvider[] iToolBehaviorProviderArray = toolProviders = this.getFeatureProvider().getDiagramTypeProvider().getAvailableToolBehaviorProviders();
        int n = toolProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IToolBehaviorProvider tp = iToolBehaviorProviderArray[n2];
            if (tp instanceof Bpmn2ToolBehaviorProvider) {
                return (Bpmn2ToolBehaviorProvider)tp;
            }
            ++n2;
        }
        return null;
    }

    protected List<IToolEntry> getTools() {
        ArrayList<IToolEntry> tools = new ArrayList<IToolEntry>();
        Bpmn2ToolBehaviorProvider toolProvider = this.getToolProvider();
        if (toolProvider != null) {
            List<EClass> availableTypes = this.getAvailableTypes();
            for (IToolEntry te : toolProvider.getTools()) {
                EClass type;
                ObjectCreationToolEntry cte;
                ICreateFeature f;
                if (!(te instanceof ObjectCreationToolEntry) || !((f = (cte = (ObjectCreationToolEntry)te).getCreateFeature()) instanceof IBpmn2CreateFeature) || !availableTypes.contains(type = ((IBpmn2CreateFeature)f).getBusinessObjectClass())) continue;
                tools.add(te);
            }
        }
        return tools;
    }

    public abstract EClass getBusinessObjectClass();

    public boolean hasDoneChanges() {
        return this.changesDone;
    }

    private CreateContext prepareCreateContext(ICustomContext context) {
        CreateContext cc = new CreateContext();
        PictogramElement[] pes = context.getPictogramElements();
        if (pes == null || pes.length != 1) {
            return null;
        }
        EObject container = pes[0].eContainer();
        if (!(container instanceof ContainerShape)) {
            return null;
        }
        cc.setTargetContainer((ContainerShape)container);
        cc.putProperty((Object)"is.importing", (Object)Boolean.TRUE);
        return cc;
    }
}

