/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.artifact;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.AbstractUpdateBaseElementFeature;
import org.eclipse.bpmn2.modeler.core.features.BaseElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.DefaultMoveBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.artifact.AbstractCreateArtifactFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.AbstractDefaultDeleteFeature;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class GroupFeatureContainer
extends BaseElementFeatureContainer {
    protected final IGaService gaService = Graphiti.getGaService();
    protected final IPeService peService = Graphiti.getPeService();

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof Group;
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateGroupFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddGroupFeature(fp);
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new DeleteGroupFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = new MultiUpdateFeature(fp);
        multiUpdate.addFeature((IUpdateFeature)new UpdateGroupFeature(fp));
        UpdateLabelFeature updateLabelFeature = new UpdateLabelFeature(fp){

            protected boolean hasLabel(BaseElement element) {
                return element instanceof Group;
            }

            protected String getLabelString(BaseElement element) {
                String name = "";
                Group group = (Group)element;
                if (group.getCategoryValueRef() != null) {
                    name = ExtendedPropertiesProvider.getTextValue((EObject)group.getCategoryValueRef());
                }
                return name;
            }

            protected ShapeStyle.LabelPosition getLabelPosition(AbstractText text) {
                return ShapeStyle.LabelPosition.TOP;
            }
        };
        multiUpdate.addFeature((IUpdateFeature)updateLabelFeature);
        return multiUpdate;
    }

    public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
        return null;
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return null;
    }

    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        return null;
    }

    public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
        return new MoveGroupFeature(fp);
    }

    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return new ResizeGroupFeature(fp);
    }

    public class AddGroupFeature
    extends AbstractBpmn2AddFeature<Group> {
        public AddGroupFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canAdd(IAddContext context) {
            return true;
        }

        public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
            return new AddShapeLabelFeature(fp);
        }

        public PictogramElement add(IAddContext context) {
            IGaService gaService = Graphiti.getGaService();
            IPeService peService = Graphiti.getPeService();
            Group businessObject = (Group)this.getBusinessObject(context);
            int x = context.getX();
            int y = context.getY();
            int width = this.getWidth(context);
            int height = this.getHeight(context);
            if (!(context.getTargetContainer() instanceof Diagram)) {
                ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)context.getTargetContainer());
                x += loc.getX();
                y += loc.getY();
                ((AddContext)context).setTargetContainer((ContainerShape)this.getDiagram());
            }
            ContainerShape containerShape = peService.createContainerShape(context.getTargetContainer(), true);
            this.link((PictogramElement)containerShape, businessObject);
            int[] nArray = new int[10];
            nArray[2] = width;
            nArray[4] = width;
            nArray[5] = height;
            nArray[7] = height;
            int[] xy = nArray;
            Polyline rect = gaService.createPolyline((GraphicsAlgorithmContainer)containerShape, xy);
            rect.setLineWidth(Integer.valueOf(3));
            rect.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
            rect.setLineStyle(LineStyle.DASHDOT);
            gaService.setLocationAndSize((GraphicsAlgorithm)rect, x, y, width, height);
            peService.createChopboxAnchor((AnchorContainer)containerShape);
            AnchorUtil.addFixedPointAnchors((Shape)containerShape, (GraphicsAlgorithm)rect);
            boolean isImport = context.getProperty((Object)"is.importing") != null;
            this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
            ((AddContext)context).setWidth(width);
            ((AddContext)context).setHeight(height);
            this.decorateShape(context, containerShape, businessObject);
            return containerShape;
        }

        protected void decorateShape(IAddContext context, ContainerShape containerShape, Group businessObject) {
        }

        public Class getBusinessObjectType() {
            return Group.class;
        }
    }

    public static class CreateGroupFeature
    extends AbstractCreateArtifactFeature<Group> {
        public CreateGroupFeature(IFeatureProvider fp) {
            super(fp);
        }

        public String getStencilImageId() {
            return ImageProvider.IMG_16_GROUP;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getGroup();
        }
    }

    public class DeleteGroupFeature
    extends AbstractDefaultDeleteFeature {
        public DeleteGroupFeature(IFeatureProvider fp) {
            super(fp);
        }

        @Override
        public void delete(IDeleteContext context) {
            ContainerShape groupShape = (ContainerShape)context.getPictogramElement();
            List containedShapes = FeatureSupport.findGroupedShapes((ContainerShape)groupShape);
            super.delete(context);
            FeatureSupport.updateCategoryValues((IFeatureProvider)this.getFeatureProvider(), (List)containedShapes);
        }
    }

    public static class MoveGroupFeature
    extends DefaultMoveBPMNShapeFeature {
        List<ContainerShape> containedShapes = new ArrayList<ContainerShape>();

        public MoveGroupFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canMoveShape(IMoveShapeContext context) {
            return true;
        }

        protected void preMoveShape(IMoveShapeContext context) {
            super.preMoveShape(context);
            ContainerShape groupShape = (ContainerShape)context.getShape();
            ContainerShape container = context.getTargetContainer();
            if (!(container instanceof Diagram)) {
                ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)container);
                int x = context.getX() + loc.getX();
                int y = context.getY() + loc.getY();
                ((MoveShapeContext)context).setX(x);
                ((MoveShapeContext)context).setY(y);
                ((MoveShapeContext)context).setDeltaX(x - this.preMoveLoc.getX());
                ((MoveShapeContext)context).setDeltaY(y - this.preMoveLoc.getY());
                ((MoveShapeContext)context).setTargetContainer((ContainerShape)this.getDiagram());
            }
            this.containedShapes = FeatureSupport.findGroupedShapes((ContainerShape)groupShape);
        }

        protected void postMoveShape(IMoveShapeContext context) {
            super.postMoveShape(context);
            ContainerShape groupShape = (ContainerShape)context.getShape();
            for (ContainerShape shape : this.containedShapes) {
                if (FeatureSupport.isLabelShape((PictogramElement)shape)) continue;
                ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)shape);
                int x = loc.getX() + context.getDeltaX();
                int y = loc.getY() + context.getDeltaY();
                MoveShapeContext mc = new MoveShapeContext((Shape)shape);
                mc.setSourceContainer(shape.getContainer());
                mc.setTargetContainer(shape.getContainer());
                mc.setX(x);
                mc.setY(y);
                IMoveShapeFeature mf = this.getFeatureProvider().getMoveShapeFeature((IMoveShapeContext)mc);
                mf.moveShape((IMoveShapeContext)mc);
            }
            for (ContainerShape cs : FeatureSupport.findGroupedShapes((ContainerShape)groupShape)) {
                if (this.containedShapes.contains(cs)) continue;
                this.containedShapes.add(cs);
            }
            FeatureSupport.updateCategoryValues((IFeatureProvider)this.getFeatureProvider(), this.containedShapes);
        }
    }

    public class ResizeGroupFeature
    extends DefaultResizeShapeFeature {
        public ResizeGroupFeature(IFeatureProvider fp) {
            super(fp);
        }

        public void resizeShape(IResizeShapeContext context) {
            ContainerShape groupShape = (ContainerShape)context.getPictogramElement();
            List containedShapesBeforeResize = FeatureSupport.findGroupedShapes((ContainerShape)groupShape);
            int x = context.getX();
            int y = context.getY();
            int w = context.getWidth();
            int h = context.getHeight();
            Polyline rect = (Polyline)groupShape.getGraphicsAlgorithm();
            Point p = (Point)rect.getPoints().get(1);
            p.setX(w);
            p = (Point)rect.getPoints().get(2);
            p.setX(w);
            p.setY(h);
            p = (Point)rect.getPoints().get(3);
            p.setY(h);
            Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)rect, x, y, w, h);
            for (Shape shape : groupShape.getChildren()) {
                if (!(shape.getGraphicsAlgorithm() instanceof AbstractText)) continue;
                AbstractText text = (AbstractText)shape.getGraphicsAlgorithm();
                GroupFeatureContainer.this.gaService.setLocationAndSize((GraphicsAlgorithm)text, 0, 0, w, text.getHeight());
            }
            DIUtils.updateDIShape((PictogramElement)groupShape);
            FeatureSupport.updateLabel((IFeatureProvider)this.getFeatureProvider(), (PictogramElement)groupShape, null);
            List containedShapesAfterResize = FeatureSupport.findGroupedShapes((ContainerShape)groupShape);
            FeatureSupport.updateCategoryValues((IFeatureProvider)this.getFeatureProvider(), (List)containedShapesBeforeResize);
            FeatureSupport.updateCategoryValues((IFeatureProvider)this.getFeatureProvider(), (List)containedShapesAfterResize);
            FeatureSupport.updateConnections((IFeatureProvider)this.getFeatureProvider(), (AnchorContainer)groupShape);
        }
    }

    public static class UpdateGroupFeature
    extends AbstractUpdateBaseElementFeature {
        public UpdateGroupFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean update(IUpdateContext context) {
            ContainerShape groupShape = (ContainerShape)context.getPictogramElement();
            List containedShapes = FeatureSupport.findGroupedShapes((ContainerShape)groupShape);
            FeatureSupport.updateCategoryValues((IFeatureProvider)this.getFeatureProvider(), (List)containedShapes);
            return true;
        }
    }
}

