/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.ArrayList;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.choreography.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class AddChoreographyMessageFeature
extends AbstractCustomFeature {
    protected boolean changesDone = false;
    private static ILabelProvider labelProvider = new ILabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            return ChoreographyUtil.getMessageName((Message)((Message)element));
        }

        public Image getImage(Object element) {
            return null;
        }
    };

    public AddChoreographyMessageFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.AddChoreographyMessageFeature_Name;
    }

    public String getDescription() {
        return Messages.AddChoreographyMessageFeature_Description;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_ADD_MESSAGE;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            if (pe instanceof ContainerShape && bo instanceof Participant) {
                ChoreographyTask ct;
                Participant participant = (Participant)bo;
                Object parent = this.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)pe).getContainer());
                if (parent instanceof ChoreographyTask && (ct = (ChoreographyTask)parent).getParticipantRefs().size() >= 2) {
                    boolean canAdd = true;
                    for (MessageFlow mf : ct.getMessageFlowRef()) {
                        if (mf.getSourceRef() == null || !mf.getSourceRef().equals(participant)) continue;
                        canAdd = false;
                        break;
                    }
                    return canAdd;
                }
            }
        }
        return false;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            if (pe instanceof ContainerShape && bo instanceof Participant) {
                ModelHandler mh = ModelHandler.getInstance((EObject)this.getDiagram());
                ContainerShape containerShape = (ContainerShape)pe;
                Participant participant = (Participant)bo;
                Object parent = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape.getContainer());
                if (parent instanceof ChoreographyTask) {
                    ChoreographyTask ct = (ChoreographyTask)parent;
                    Message message = null;
                    ArrayList<Message> messageList = new ArrayList<Message>();
                    message = (Message)mh.create(Message.class);
                    message.setName(message.getId());
                    messageList.add(message);
                    for (RootElement re : mh.getDefinitions().getRootElements()) {
                        if (!(re instanceof Message)) continue;
                        messageList.add((Message)re);
                    }
                    Message result = message;
                    if (messageList.size() > 1) {
                        PopupMenu popupMenu = new PopupMenu(messageList, labelProvider);
                        this.changesDone = popupMenu.show((Control)Display.getCurrent().getActiveShell());
                        if (this.changesDone) {
                            result = (Message)popupMenu.getResult();
                        }
                    } else {
                        this.changesDone = true;
                    }
                    if (this.changesDone) {
                        if (result == message) {
                            message.setName(ExtendedPropertiesProvider.getTextValue((EObject)message));
                            mh.getDefinitions().getRootElements().add(result);
                        }
                        ArrayList parts = new ArrayList(ct.getParticipantRefs());
                        parts.remove(participant);
                        if (parts.size() == 1) {
                            MessageFlow mf = mh.createMessageFlow((InteractionNode)participant, (InteractionNode)parts.get(0));
                            mf.setName(ModelUtil.toCanonicalString((String)mf.getId()));
                            Choreography choreography = (Choreography)ct.eContainer();
                            choreography.getMessageFlows().add(mf);
                            mf.setMessageRef(result);
                            ct.getMessageFlowRef().add(mf);
                            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)containerShape, BPMNShape.class);
                            bpmnShape.setIsMessageVisible(true);
                        }
                    }
                }
            }
        }
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }
}

