/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.AbstractDefaultDeleteFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.AbstractChoreographyFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.choreography.AbstractCreateChoreographyActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.AddChoreographyTaskFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.UpdateChoreographyMessageFlowFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.UpdateChoreographyMessageLinkFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class ChoreographyTaskFeatureContainer
extends AbstractChoreographyFeatureContainer {
    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && (o instanceof ChoreographyTask || o instanceof Participant);
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateChoreographyTaskFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddChoreographyTaskFeature(fp);
    }

    @Override
    public MultiUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = super.getUpdateFeature(fp);
        multiUpdate.addFeature((IUpdateFeature)new UpdateChoreographyMessageFlowFeature(fp));
        multiUpdate.addFeature((IUpdateFeature)new UpdateChoreographyMessageLinkFeature(fp));
        return multiUpdate;
    }

    @Override
    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new AbstractDefaultDeleteFeature(fp){

            protected void deletePeEnvironment(PictogramElement pictogramElement) {
                if (pictogramElement instanceof ContainerShape) {
                    ContainerShape cShape = (ContainerShape)pictogramElement;
                    EList anchors = cShape.getAnchors();
                    for (Anchor anchor : anchors) {
                        this.deleteConnections(this.getFeatureProvider(), (EList<Connection>)anchor.getIncomingConnections());
                        this.deleteConnections(this.getFeatureProvider(), (EList<Connection>)anchor.getOutgoingConnections());
                    }
                    this.deleteContainer(this.getFeatureProvider(), cShape);
                }
            }

            protected void deleteConnections(IFeatureProvider fp, EList<Connection> connections) {
                ArrayList<Connection> con = new ArrayList<Connection>();
                con.addAll((Collection<Connection>)connections);
                for (Connection connection : con) {
                    EObject msg;
                    BaseElement be = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, BaseElement.class);
                    if (be instanceof MessageFlow && (msg = connection.getEnd().eContainer()) instanceof PictogramElement) {
                        Graphiti.getPeService().deletePictogramElement((PictogramElement)msg);
                    }
                    DeleteContext conDelete = new DeleteContext((PictogramElement)connection);
                    IDeleteFeature df = fp.getDeleteFeature((IDeleteContext)conDelete);
                    df.delete((IDeleteContext)conDelete);
                }
            }

            protected void deleteContainer(IFeatureProvider fp, ContainerShape cShape) {
                Object[] children;
                Object[] objectArray = children = cShape.getChildren().toArray();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ContainerShape cs;
                    BaseElement be;
                    Object shape = objectArray[n2];
                    if (shape instanceof ContainerShape && (be = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)(cs = (ContainerShape)shape), BaseElement.class)) instanceof Participant) {
                        BPMNShape bs = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)cs, BPMNShape.class);
                        Graphiti.getPeService().deletePictogramElement((PictogramElement)cs);
                        if (bs != null) {
                            super.deleteBusinessObject((Object)bs);
                        }
                    }
                    ++n2;
                }
            }
        };
    }

    public static class CreateChoreographyTaskFeature
    extends AbstractCreateChoreographyActivityFeature<ChoreographyTask> {
        public CreateChoreographyTaskFeature(IFeatureProvider fp) {
            super(fp);
        }

        @Override
        public String getStencilImageId() {
            return ImageProvider.IMG_16_CHOREOGRAPHY_TASK;
        }

        @Override
        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getChoreographyTask();
        }
    }
}

