/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.data;

import java.util.ArrayList;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DataStore;
import org.eclipse.bpmn2.DataStoreReference;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.AbstractCreateFlowElementFeature;
import org.eclipse.bpmn2.modeler.core.features.BaseElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.data.MoveDataFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.data.Messages;
import org.eclipse.bpmn2.modeler.ui.features.data.UpdateItemAwareElementFeature;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DataStoreReferenceFeatureContainer
extends BaseElementFeatureContainer {
    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof DataStoreReference;
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return null;
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateDataStoreReferenceFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddDataStoreReferenceFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = new MultiUpdateFeature(fp);
        multiUpdate.addFeature(new UpdateItemAwareElementFeature(fp));
        multiUpdate.addFeature((IUpdateFeature)new UpdateLabelFeature(fp));
        return multiUpdate;
    }

    public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
        return new MoveDataFeature(fp);
    }

    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return new DefaultResizeShapeFeature(fp){

            public boolean canResizeShape(IResizeShapeContext context) {
                return false;
            }
        };
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider context) {
        return null;
    }

    public class AddDataStoreReferenceFeature
    extends AbstractBpmn2AddFeature<DataStoreReference> {
        public AddDataStoreReferenceFeature(IFeatureProvider fp) {
            super(fp);
        }

        public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
            return new AddShapeLabelFeature(fp);
        }

        public boolean canAdd(IAddContext context) {
            return true;
        }

        public PictogramElement add(IAddContext context) {
            DataStoreReference businessObject = (DataStoreReference)this.getBusinessObject(context);
            int width = this.getWidth(context);
            int height = this.getHeight(context);
            ContainerShape containerShape = peService.createContainerShape(context.getTargetContainer(), true);
            Rectangle invisibleRect = gaService.createInvisibleRectangle((PictogramElement)containerShape);
            gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, context.getX(), context.getY(), width, height);
            int whalf = width / 2;
            int[] nArray = new int[12];
            nArray[1] = 10;
            nArray[2] = whalf;
            nArray[3] = 20;
            nArray[4] = width;
            nArray[5] = 10;
            nArray[6] = width;
            nArray[7] = height - 10;
            nArray[8] = whalf;
            nArray[9] = height;
            nArray[11] = height - 10;
            int[] xy = nArray;
            int[] nArray2 = new int[12];
            nArray2[2] = whalf;
            nArray2[3] = whalf;
            nArray2[8] = whalf;
            nArray2[9] = whalf;
            int[] bend = nArray2;
            Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)invisibleRect, xy, bend);
            polygon.setFilled(Boolean.valueOf(true));
            StyleUtil.applyStyle((GraphicsAlgorithm)polygon, (BaseElement)businessObject);
            int[] nArray3 = new int[6];
            nArray3[1] = 14;
            nArray3[2] = whalf;
            nArray3[3] = 24;
            nArray3[4] = width;
            nArray3[5] = 14;
            xy = nArray3;
            int[] nArray4 = new int[6];
            nArray4[2] = whalf;
            nArray4[3] = whalf;
            bend = nArray4;
            Polyline line1 = gaService.createPolyline((GraphicsAlgorithmContainer)invisibleRect, xy, bend);
            line1.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
            int[] nArray5 = new int[6];
            nArray5[1] = 18;
            nArray5[2] = whalf;
            nArray5[3] = 28;
            nArray5[4] = width;
            nArray5[5] = 18;
            xy = nArray5;
            Polyline line2 = gaService.createPolyline((GraphicsAlgorithmContainer)invisibleRect, xy, bend);
            line2.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
            int[] nArray6 = new int[6];
            nArray6[1] = 11;
            nArray6[2] = whalf;
            nArray6[4] = width;
            nArray6[5] = 11;
            xy = nArray6;
            Polyline lineTop = gaService.createPolyline((GraphicsAlgorithmContainer)invisibleRect, xy, bend);
            lineTop.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
            boolean isImport = context.getProperty((Object)"is.importing") != null;
            this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
            ((AddContext)context).setWidth(width);
            ((AddContext)context).setHeight(height);
            this.decorateShape(context, containerShape, (BaseElement)businessObject);
            peService.createChopboxAnchor((AnchorContainer)containerShape);
            AnchorUtil.addFixedPointAnchors((Shape)containerShape, (GraphicsAlgorithm)invisibleRect);
            return containerShape;
        }

        protected boolean isHorizontal(ITargetContext context) {
            return true;
        }

        public Class getBusinessObjectType() {
            return DataStoreReference.class;
        }
    }

    public static class CreateDataStoreReferenceFeature
    extends AbstractCreateFlowElementFeature<DataStoreReference> {
        private static ILabelProvider labelProvider = new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                if (((DataStore)element).getId() == null) {
                    return ((DataStore)element).getName();
                }
                return NLS.bind((String)Messages.DataStoreReferenceFeatureContainer_Ref, (Object)((DataStore)element).getName());
            }

            public Image getImage(Object element) {
                return null;
            }
        };

        public CreateDataStoreReferenceFeature(IFeatureProvider fp) {
            super(fp);
        }

        public String getStencilImageId() {
            return ImageProvider.IMG_16_DATA_STORE;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getDataStoreReference();
        }

        public DataStoreReference createBusinessObject(ICreateContext context) {
            this.changesDone = true;
            ModelHandler mh = ModelHandler.getInstance((EObject)this.getDiagram());
            DataStoreReference dataStoreRef = (DataStoreReference)Bpmn2ModelerFactory.create(DataStoreReference.class);
            DataStore dataStore = (DataStore)Bpmn2ModelerFactory.create(DataStore.class);
            String oldName = dataStore.getName();
            dataStore.setName(Messages.DataStoreReferenceFeatureContainer_New);
            dataStore.setId(null);
            ArrayList<DataStore> dataStoreList = new ArrayList<DataStore>();
            dataStoreList.add(dataStore);
            TreeIterator iter = mh.getDefinitions().eAllContents();
            while (iter.hasNext()) {
                EObject obj = (EObject)iter.next();
                if (!(obj instanceof DataStore)) continue;
                dataStoreList.add((DataStore)obj);
            }
            DataStore result = dataStore;
            if (dataStoreList.size() > 1) {
                PopupMenu popupMenu = new PopupMenu(dataStoreList, labelProvider);
                this.changesDone = popupMenu.show((Control)Display.getCurrent().getActiveShell());
                if (this.changesDone) {
                    result = (DataStore)popupMenu.getResult();
                } else {
                    EcoreUtil.delete((EObject)dataStore);
                    EcoreUtil.delete((EObject)dataStoreRef);
                    dataStoreRef = null;
                }
            } else {
                this.changesDone = true;
            }
            if (this.changesDone) {
                if (result == dataStore) {
                    mh.addRootElement((RootElement)dataStore);
                    ModelUtil.setID((EObject)dataStore);
                    dataStore.setName(oldName);
                    dataStoreRef.setName(dataStore.getName());
                } else {
                    dataStoreRef.setName(NLS.bind((String)Messages.DataStoreReferenceFeatureContainer_Default_Name, (Object)result.getName()));
                }
                dataStoreRef.setDataStoreRef(result);
                ModelUtil.setID((EObject)dataStoreRef, (Resource)mh.getResource());
                this.putBusinessObject(context, (BaseElement)dataStoreRef);
            }
            return dataStoreRef;
        }
    }
}

