/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.event;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2UpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.event.AbstractCreateEventFeature;
import org.eclipse.bpmn2.modeler.core.features.event.AbstractUpdateEventFeature;
import org.eclipse.bpmn2.modeler.core.features.event.AddEventFeature;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.event.AbstractEventFeatureContainer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class StartEventFeatureContainer
extends AbstractEventFeatureContainer {
    static final String INTERRUPTING = "interrupting";

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof StartEvent;
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateStartEventFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddStartEventFeature(fp);
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature updateFeature = new MultiUpdateFeature(fp);
        updateFeature.addFeature(super.getUpdateFeature(fp));
        updateFeature.addFeature((IUpdateFeature)new UpdateEventSubProcessFeature(fp));
        updateFeature.addFeature((IUpdateFeature)new UpdateStartEventFeature(fp));
        return updateFeature;
    }

    public class AddStartEventFeature
    extends AddEventFeature<StartEvent> {
        public AddStartEventFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected void decorateShape(IAddContext context, ContainerShape containerShape, StartEvent businessObject) {
            super.decorateShape(context, containerShape, (BaseElement)businessObject);
            Ellipse cfr_ignored_0 = (Ellipse)AddStartEventFeature.getGraphicsAlgorithm((ContainerShape)containerShape);
            Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, StartEventFeatureContainer.INTERRUPTING, Boolean.toString(true));
            IPeService peService = Graphiti.getPeService();
            peService.setPropertyValue((PropertyContainer)containerShape, UpdateStartEventFeature.START_EVENT_MARKER, AbstractUpdateEventFeature.getEventDefinitionsValue((Event)businessObject));
        }

        public Class getBusinessObjectType() {
            return StartEvent.class;
        }
    }

    public static class CreateStartEventFeature
    extends AbstractCreateEventFeature<StartEvent> {
        public CreateStartEventFeature(IFeatureProvider fp) {
            super(fp);
        }

        public String getStencilImageId() {
            return ImageProvider.IMG_16_START_EVENT;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getStartEvent();
        }
    }

    private class UpdateEventSubProcessFeature
    extends AbstractBpmn2UpdateFeature {
        public UpdateEventSubProcessFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canUpdate(IUpdateContext context) {
            Object o = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
            return o != null && o instanceof StartEvent;
        }

        public IReason updateNeeded(IUpdateContext context) {
            PictogramElement element;
            IPeService peService = Graphiti.getPeService();
            String prop = peService.getPropertyValue((PropertyContainer)(element = context.getPictogramElement()), StartEventFeatureContainer.INTERRUPTING);
            if (prop == null) {
                return Reason.createFalseReason();
            }
            StartEvent event = (StartEvent)this.getBusinessObjectForPictogramElement(element);
            boolean interrupting = Boolean.parseBoolean(prop);
            IReason reason = event.isIsInterrupting() == interrupting ? Reason.createFalseReason() : Reason.createTrueReason((String)"Is Interrupting");
            return reason;
        }

        public boolean update(IUpdateContext context) {
            IPeService peService = Graphiti.getPeService();
            ContainerShape container = (ContainerShape)context.getPictogramElement();
            StartEvent event = (StartEvent)this.getBusinessObjectForPictogramElement((PictogramElement)container);
            GraphicsAlgorithm ga = ((Shape)peService.getAllContainedShapes(container).iterator().next()).getGraphicsAlgorithm();
            if (ga instanceof Ellipse) {
                Ellipse ellipse = (Ellipse)ga;
                LineStyle style = event.isIsInterrupting() ? LineStyle.SOLID : LineStyle.DASH;
                ellipse.setLineStyle(style);
            }
            peService.setPropertyValue((PropertyContainer)container, StartEventFeatureContainer.INTERRUPTING, Boolean.toString(event.isIsInterrupting()));
            return true;
        }
    }

    protected static class UpdateStartEventFeature
    extends AbstractUpdateEventFeature<StartEvent> {
        public static String START_EVENT_MARKER = "marker.start.event";

        public UpdateStartEventFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected String getPropertyKey() {
            return START_EVENT_MARKER;
        }
    }
}

