/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.event;

import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.modeler.core.features.event.AbstractUpdateEventFeature;
import org.eclipse.bpmn2.modeler.ui.features.event.BoundaryEventFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.event.Messages;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.services.Graphiti;

public class UpdateBoundaryEventFeature
extends AbstractUpdateEventFeature<BoundaryEvent> {
    public static String BOUNDARY_EVENT_MARKER = "marker.boundary.event";

    public UpdateBoundaryEventFeature(IFeatureProvider fp) {
        super(fp);
    }

    public IReason updateNeeded(IUpdateContext context) {
        IReason reason = super.updateNeeded(context);
        if (!reason.toBoolean()) {
            String cancelProperty = Graphiti.getPeService().getPropertyValue((PropertyContainer)context.getPictogramElement(), BoundaryEventFeatureContainer.BOUNDARY_EVENT_CANCEL);
            BoundaryEvent event = (BoundaryEvent)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
            boolean changed = Boolean.parseBoolean(cancelProperty) ^ event.isCancelActivity();
            reason = changed ? Reason.createTrueReason((String)Messages.UpdateBoundaryEventFeature_Description_Changed) : Reason.createFalseReason();
        }
        return reason;
    }

    public boolean update(IUpdateContext context) {
        super.update(context);
        BoundaryEvent event = (BoundaryEvent)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        Graphiti.getPeService().setPropertyValue((PropertyContainer)context.getPictogramElement(), BoundaryEventFeatureContainer.BOUNDARY_EVENT_CANCEL, Boolean.toString(event.isCancelActivity()));
        Ellipse ellipse = (Ellipse)context.getPictogramElement().getGraphicsAlgorithm();
        Ellipse innerEllipse = (Ellipse)ellipse.getGraphicsAlgorithmChildren().get(0);
        LineStyle lineStyle = event.isCancelActivity() ? LineStyle.SOLID : LineStyle.DASH;
        ellipse.setLineStyle(lineStyle);
        innerEllipse.setLineStyle(lineStyle);
        return true;
    }

    protected String getPropertyKey() {
        return BOUNDARY_EVENT_MARKER;
    }
}

