/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.flow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2UpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.BaseElementConnectionFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractAddFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractCreateFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractReconnectFlowFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.flow.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DataAssociationFeatureContainer
extends BaseElementConnectionFeatureContainer {
    public static final String ASSOCIATION_DIRECTION = "association.direction";
    public static final String ARROWHEAD_DECORATOR = "arrowhead.decorator";
    private static ILabelProvider labelProvider = new ILabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object object) {
            String mapping;
            String text;
            block7: {
                ItemAwareElement element;
                block8: {
                    element = (ItemAwareElement)object;
                    if (element.getId() == null) {
                        return ModelUtil.getTextValue((Object)object);
                    }
                    text = NLS.bind((String)Messages.DataAssociationFeatureContainer_Reference_To, (Object)ModelUtil.getTextValue((Object)object));
                    mapping = Messages.DataAssociationFeatureContainer_Unmapped;
                    if (!(element instanceof DataOutput)) break block8;
                    List doa = null;
                    if (element.eContainer() instanceof InputOutputSpecification) {
                        InputOutputSpecification ioSpec = (InputOutputSpecification)element.eContainer();
                        Activity activity = (Activity)ioSpec.eContainer();
                        doa = activity.getDataOutputAssociations();
                    } else {
                        CatchEvent event = (CatchEvent)element.eContainer();
                        doa = event.getDataOutputAssociation();
                    }
                    for (DataOutputAssociation d : doa) {
                        if (!d.getSourceRef().contains(element)) continue;
                        if (d.getTargetRef() == null) break block7;
                        mapping = NLS.bind((String)Messages.DataAssociationFeatureContainer_Mapped_To, (Object)ExtendedPropertiesProvider.getTextValue((EObject)d.getTargetRef()));
                        break block7;
                    }
                    break block7;
                }
                if (!(element instanceof DataInput)) break block7;
                List dia = null;
                if (element.eContainer() instanceof InputOutputSpecification) {
                    InputOutputSpecification ioSpec = (InputOutputSpecification)element.eContainer();
                    Activity activity = (Activity)ioSpec.eContainer();
                    dia = activity.getDataInputAssociations();
                } else {
                    ThrowEvent event = (ThrowEvent)element.eContainer();
                    dia = event.getDataInputAssociation();
                }
                for (DataInputAssociation d : dia) {
                    if (d.getTargetRef() != element) continue;
                    if (d.getSourceRef().size() <= 0) break;
                    mapping = NLS.bind((String)Messages.DataAssociationFeatureContainer_Mapped_To, (Object)ExtendedPropertiesProvider.getTextValue((EObject)((EObject)d.getSourceRef().get(0))));
                    break;
                }
            }
            return String.valueOf(text) + mapping;
        }

        public Image getImage(Object element) {
            return null;
        }
    };

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof DataAssociation;
    }

    public ICreateConnectionFeature getCreateConnectionFeature(IFeatureProvider fp) {
        return new CreateDataAssociationFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddDataAssociationFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return new UpdateDataAssociationFeature(fp);
    }

    public IReconnectionFeature getReconnectionFeature(IFeatureProvider fp) {
        return new ReconnectDataAssociationFeature(fp);
    }

    private static boolean canConnect(BaseElement source, BaseElement target) {
        if ((source instanceof Activity || source instanceof CatchEvent) && target instanceof ItemAwareElement && !(target instanceof DataInput)) {
            return true;
        }
        return (target instanceof Activity || target instanceof ThrowEvent) && source instanceof ItemAwareElement && !(source instanceof DataOutput);
    }

    private static void deleteReplacedDataAssociation(IFeatureProvider fp, Connection connection) {
        DataAssociation newAssociation = (DataAssociation)BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)connection);
        ArrayList<Connection> deleted = new ArrayList<Connection>();
        block0: for (Connection c : fp.getDiagramTypeProvider().getDiagram().getConnections()) {
            if (c == connection) continue;
            if (newAssociation instanceof DataInputAssociation) {
                DataInputAssociation dia = (DataInputAssociation)BusinessObjectUtil.getFirstElementOfType((PictogramElement)c, DataInputAssociation.class);
                if (dia == null || newAssociation.getTargetRef() != dia.getTargetRef()) continue;
                deleted.add(c);
                continue;
            }
            DataOutputAssociation doa = (DataOutputAssociation)BusinessObjectUtil.getFirstElementOfType((PictogramElement)c, DataOutputAssociation.class);
            if (doa == null) continue;
            for (ItemAwareElement d : newAssociation.getSourceRef()) {
                if (!doa.getSourceRef().contains(d)) continue;
                deleted.add(c);
                continue block0;
            }
        }
        BPMNEdge newEdge = (BPMNEdge)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, BPMNEdge.class);
        for (Connection c : deleted) {
            BPMNEdge oldEdge = (BPMNEdge)BusinessObjectUtil.getFirstElementOfType((PictogramElement)c, BPMNEdge.class);
            if (oldEdge != null && oldEdge == newEdge) {
                int index = 0;
                while (index < c.getLink().getBusinessObjects().size()) {
                    if (oldEdge == c.getLink().getBusinessObjects().get(index)) {
                        c.getLink().getBusinessObjects().remove(index);
                        break;
                    }
                    ++index;
                }
            }
            DeleteContext dc = new DeleteContext((PictogramElement)c);
            c.getLink().getBusinessObjects().remove(0);
            IDeleteFeature df = fp.getDeleteFeature((IDeleteContext)dc);
            df.delete((IDeleteContext)dc);
        }
    }

    public static Connection findDataAssociation(Diagram diagram, DataAssociation newAssociation) {
        if (diagram != null) {
            for (Connection c : diagram.getConnections()) {
                if (newAssociation instanceof DataInputAssociation) {
                    DataInputAssociation dia = (DataInputAssociation)BusinessObjectUtil.getFirstElementOfType((PictogramElement)c, DataInputAssociation.class);
                    if (dia == null || newAssociation.getTargetRef() != dia.getTargetRef()) continue;
                    return c;
                }
                DataOutputAssociation doa = (DataOutputAssociation)BusinessObjectUtil.getFirstElementOfType((PictogramElement)c, DataOutputAssociation.class);
                if (doa == null) continue;
                for (ItemAwareElement d : newAssociation.getSourceRef()) {
                    if (!doa.getSourceRef().contains(d)) continue;
                    return c;
                }
            }
        }
        return null;
    }

    private static DataInputAssociation selectInput(BaseElement target, List<DataInput> dataInputs, List<DataInputAssociation> dataInputAssociations, InputSet inputSet) {
        InputOutputSpecification object = null;
        EReference objectFeature = null;
        EReference targetFeature = null;
        if (target instanceof Activity) {
            object = ((Activity)target).getIoSpecification();
            objectFeature = Bpmn2Package.eINSTANCE.getInputOutputSpecification_DataInputs();
            targetFeature = Bpmn2Package.eINSTANCE.getActivity_DataInputAssociations();
        } else if (target instanceof ThrowEvent) {
            object = target;
            objectFeature = Bpmn2Package.eINSTANCE.getThrowEvent_DataInputs();
            targetFeature = Bpmn2Package.eINSTANCE.getThrowEvent_DataInputAssociation();
        }
        DataInput dataInput = Bpmn2Factory.eINSTANCE.createDataInput();
        dataInput.setName(NLS.bind((String)Messages.DataAssociationFeatureContainer_New_Input_For, (Object)ExtendedPropertiesProvider.getTextValue((EObject)target)));
        DataInput result = dataInput;
        ArrayList<DataInput> list = new ArrayList<DataInput>();
        list.add(dataInput);
        list.addAll(dataInputs);
        if (list.size() > 1) {
            PopupMenu popupMenu = new PopupMenu(list, labelProvider);
            boolean b = popupMenu.show((Control)Display.getCurrent().getActiveShell());
            if (b) {
                result = (DataInput)popupMenu.getResult();
            } else {
                EcoreUtil.delete((EObject)dataInput);
                return null;
            }
        }
        DataInputAssociation dataInputAssoc = null;
        if (result == dataInput) {
            dataInput = (DataInput)Bpmn2ModelerFactory.createFeature((EObject)object, (EStructuralFeature)objectFeature, DataInput.class);
            dataInputs.add(dataInput);
            inputSet.getDataInputRefs().add(dataInput);
            dataInputAssoc = (DataInputAssociation)Bpmn2ModelerFactory.createFeature((EObject)target, (EStructuralFeature)targetFeature);
            dataInputAssoc.setTargetRef((ItemAwareElement)dataInput);
        } else {
            dataInput = result;
            for (DataInputAssociation d : dataInputAssociations) {
                if (d.getTargetRef() != dataInput) continue;
                dataInputAssoc = d;
                break;
            }
            if (dataInputAssoc == null) {
                dataInputAssoc = (DataInputAssociation)Bpmn2ModelerFactory.createFeature((EObject)target, (EStructuralFeature)targetFeature);
                dataInputAssoc.setTargetRef((ItemAwareElement)dataInput);
            }
        }
        return dataInputAssoc;
    }

    private static DataOutputAssociation selectOutput(BaseElement source, List<DataOutput> dataOutputs, List<DataOutputAssociation> dataOutputAssociations, OutputSet outputSet) {
        InputOutputSpecification object = null;
        EReference objectFeature = null;
        EReference sourceFeature = null;
        if (source instanceof Activity) {
            object = ((Activity)source).getIoSpecification();
            objectFeature = Bpmn2Package.eINSTANCE.getInputOutputSpecification_DataOutputs();
            sourceFeature = Bpmn2Package.eINSTANCE.getActivity_DataOutputAssociations();
        } else if (source instanceof CatchEvent) {
            object = source;
            objectFeature = Bpmn2Package.eINSTANCE.getCatchEvent_DataOutputs();
            sourceFeature = Bpmn2Package.eINSTANCE.getCatchEvent_DataOutputAssociation();
        }
        DataOutput dataOutput = Bpmn2Factory.eINSTANCE.createDataOutput();
        dataOutput.setName(NLS.bind((String)Messages.DataAssociationFeatureContainer_New_Output_For, (Object)ExtendedPropertiesProvider.getTextValue((EObject)source)));
        DataOutput result = dataOutput;
        ArrayList<DataOutput> list = new ArrayList<DataOutput>();
        list.add(dataOutput);
        list.addAll(dataOutputs);
        if (list.size() > 1) {
            PopupMenu popupMenu = new PopupMenu(list, labelProvider);
            boolean b = popupMenu.show((Control)Display.getCurrent().getActiveShell());
            if (b) {
                result = (DataOutput)popupMenu.getResult();
            } else {
                EcoreUtil.delete((EObject)dataOutput);
                return null;
            }
        }
        DataOutputAssociation dataOutputAssoc = null;
        if (result == dataOutput) {
            dataOutput = (DataOutput)Bpmn2ModelerFactory.createFeature((EObject)object, (EStructuralFeature)objectFeature, DataOutput.class);
            dataOutputs.add(dataOutput);
            outputSet.getDataOutputRefs().add(dataOutput);
            dataOutputAssoc = (DataOutputAssociation)Bpmn2ModelerFactory.createFeature((EObject)source, (EStructuralFeature)sourceFeature);
            dataOutputAssoc.getSourceRef().add(dataOutput);
        } else {
            dataOutput = result;
            for (DataOutputAssociation d : dataOutputAssociations) {
                if (!d.getSourceRef().contains(dataOutput)) continue;
                dataOutputAssoc = d;
                break;
            }
            if (dataOutputAssoc == null) {
                dataOutputAssoc = (DataOutputAssociation)Bpmn2ModelerFactory.createFeature((EObject)source, (EStructuralFeature)sourceFeature);
                if (dataOutput == null) {
                    dataOutputAssoc.getSourceRef().clear();
                } else {
                    dataOutputAssoc.getSourceRef().add(dataOutput);
                }
            }
        }
        return dataOutputAssoc;
    }

    private static String getDirection(DataAssociation businessObject) {
        return businessObject instanceof DataInputAssociation ? "input" : "output";
    }

    private static void setAssociationDirection(Connection connection, DataAssociation businessObject) {
        IPeService peService = Graphiti.getPeService();
        IGaService gaService = Graphiti.getGaService();
        String newDirection = DataAssociationFeatureContainer.getDirection(businessObject);
        String oldDirection = peService.getPropertyValue((PropertyContainer)connection, ASSOCIATION_DIRECTION);
        if (oldDirection == null || oldDirection.isEmpty()) {
            oldDirection = "";
        }
        if (!oldDirection.equals(newDirection)) {
            ConnectionDecorator sourceDecorator = null;
            ConnectionDecorator targetDecorator = null;
            for (ConnectionDecorator d : connection.getConnectionDecorators()) {
                String s = peService.getPropertyValue((PropertyContainer)d, ARROWHEAD_DECORATOR);
                if (s == null) continue;
                if (s.equals("source")) {
                    sourceDecorator = d;
                    continue;
                }
                if (!s.equals("target")) continue;
                targetDecorator = d;
            }
            if (sourceDecorator != null) {
                connection.getConnectionDecorators().remove(sourceDecorator);
            }
            if (targetDecorator == null) {
                targetDecorator = peService.createConnectionDecorator(connection, false, 1.0, true);
                int[] nArray = new int[6];
                nArray[0] = -13;
                nArray[1] = 7;
                nArray[4] = -13;
                nArray[5] = -7;
                Polyline arrowhead = gaService.createPolyline((GraphicsAlgorithmContainer)targetDecorator, nArray);
                StyleUtil.applyStyle((GraphicsAlgorithm)arrowhead, (BaseElement)businessObject);
                peService.setPropertyValue((PropertyContainer)targetDecorator, ARROWHEAD_DECORATOR, "target");
            }
            peService.setPropertyValue((PropertyContainer)connection, ASSOCIATION_DIRECTION, newDirection);
        }
    }

    public class AddDataAssociationFeature
    extends AbstractAddFlowFeature<DataAssociation> {
        public AddDataAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        public PictogramElement add(IAddContext context) {
            Connection connection = (Connection)super.add(context);
            DataAssociationFeatureContainer.deleteReplacedDataAssociation(this.getFeatureProvider(), connection);
            return connection;
        }

        protected Polyline createConnectionLine(Connection connection) {
            Polyline connectionLine = super.createConnectionLine(connection);
            connectionLine.setLineWidth(Integer.valueOf(2));
            connectionLine.setLineStyle(LineStyle.DOT);
            return connectionLine;
        }

        protected void decorateConnection(IAddConnectionContext context, Connection connection, DataAssociation businessObject) {
            DataAssociationFeatureContainer.setAssociationDirection(connection, businessObject);
        }

        public Class getBusinessObjectType() {
            return DataAssociation.class;
        }
    }

    public class CreateDataAssociationFeature
    extends AbstractCreateFlowFeature<DataAssociation, BaseElement, BaseElement> {
        public CreateDataAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean isAvailable(IContext context) {
            return true;
        }

        public boolean canStartConnection(ICreateConnectionContext context) {
            BaseElement source = this.getSourceBo(context);
            if (source instanceof Activity || source instanceof CatchEvent) {
                return true;
            }
            if (source instanceof ItemAwareElement) {
                return !(source instanceof DataOutput);
            }
            return false;
        }

        public boolean canCreate(ICreateConnectionContext context) {
            if (super.canCreate(context)) {
                BaseElement source = this.getSourceBo(context);
                BaseElement target = this.getTargetBo(context);
                return DataAssociationFeatureContainer.canConnect(source, target);
            }
            return false;
        }

        protected String getStencilImageId() {
            return ImageProvider.IMG_16_DATA_ASSOCIATION;
        }

        protected Class<BaseElement> getSourceClass() {
            return BaseElement.class;
        }

        protected Class<BaseElement> getTargetClass() {
            return BaseElement.class;
        }

        protected BaseElement getSourceBo(ICreateConnectionContext context) {
            Anchor anchor = this.getSourceAnchor(context);
            if (anchor != null && anchor.getParent() instanceof Shape) {
                Shape shape = (Shape)anchor.getParent();
                Connection conn = AnchorUtil.getConnectionPointOwner((AnchorContainer)shape);
                if (conn != null) {
                    return (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)conn, this.getTargetClass());
                }
                return (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, this.getTargetClass());
            }
            return null;
        }

        protected BaseElement getTargetBo(ICreateConnectionContext context) {
            Anchor anchor = this.getTargetAnchor(context);
            if (anchor != null && anchor.getParent() instanceof Shape) {
                Shape shape = (Shape)anchor.getParent();
                Connection conn = AnchorUtil.getConnectionPointOwner((AnchorContainer)shape);
                if (conn != null) {
                    return (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)conn, this.getTargetClass());
                }
                return (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, this.getTargetClass());
            }
            return null;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getDataAssociation();
        }

        public DataAssociation createBusinessObject(ICreateConnectionContext context) {
            DataOutputAssociation dataAssoc = null;
            BaseElement source = this.getSourceBo(context);
            BaseElement target = this.getTargetBo(context);
            InputOutputSpecification ioSpec = null;
            OutputSet outputSet = null;
            InputSet inputSet = null;
            this.changesDone = true;
            if (target instanceof ItemAwareElement) {
                DataOutputAssociation dataOutputAssoc = null;
                if (source instanceof Activity) {
                    Activity activity = (Activity)source;
                    ioSpec = activity.getIoSpecification();
                    if (ioSpec == null) {
                        ioSpec = (InputOutputSpecification)Bpmn2ModelerFactory.createFeature((EObject)activity, (String)"ioSpecification", InputOutputSpecification.class);
                    }
                    if (ioSpec.getOutputSets().size() == 0) {
                        outputSet = (OutputSet)Bpmn2ModelerFactory.create(OutputSet.class);
                        ioSpec.getOutputSets().add(outputSet);
                    } else {
                        outputSet = (OutputSet)ioSpec.getOutputSets().get(0);
                    }
                    dataOutputAssoc = DataAssociationFeatureContainer.selectOutput(source, ioSpec.getDataOutputs(), activity.getDataOutputAssociations(), outputSet);
                } else if (source instanceof CatchEvent) {
                    CatchEvent event = (CatchEvent)source;
                    outputSet = event.getOutputSet();
                    if (outputSet == null) {
                        outputSet = (OutputSet)Bpmn2ModelerFactory.create(OutputSet.class);
                        event.setOutputSet(outputSet);
                    }
                    dataOutputAssoc = DataAssociationFeatureContainer.selectOutput(source, event.getDataOutputs(), event.getDataOutputAssociation(), outputSet);
                }
                if (dataOutputAssoc != null) {
                    dataOutputAssoc.setTargetRef((ItemAwareElement)target);
                }
                dataAssoc = dataOutputAssoc;
            } else if (source instanceof ItemAwareElement) {
                DataOutputAssociation dataInputAssoc = null;
                if (target instanceof Activity) {
                    Activity activity = (Activity)target;
                    ioSpec = activity.getIoSpecification();
                    if (ioSpec == null) {
                        ioSpec = (InputOutputSpecification)Bpmn2ModelerFactory.createFeature((EObject)activity, (String)"ioSpecification");
                    }
                    if (ioSpec.getInputSets().size() == 0) {
                        inputSet = (InputSet)Bpmn2ModelerFactory.create(InputSet.class);
                        ioSpec.getInputSets().add(inputSet);
                    } else {
                        inputSet = (InputSet)ioSpec.getInputSets().get(0);
                    }
                    dataInputAssoc = DataAssociationFeatureContainer.selectInput(target, ioSpec.getDataInputs(), activity.getDataInputAssociations(), inputSet);
                } else if (target instanceof ThrowEvent) {
                    ThrowEvent event = (ThrowEvent)target;
                    inputSet = event.getInputSet();
                    if (inputSet == null) {
                        inputSet = (InputSet)Bpmn2ModelerFactory.create(InputSet.class);
                        event.setInputSet(inputSet);
                    }
                    dataInputAssoc = DataAssociationFeatureContainer.selectInput(target, event.getDataInputs(), event.getDataInputAssociation(), inputSet);
                }
                if (dataInputAssoc != null) {
                    dataInputAssoc.getSourceRef().clear();
                    dataInputAssoc.getSourceRef().add((ItemAwareElement)source);
                }
                dataAssoc = dataInputAssoc;
            }
            if (dataAssoc != null) {
                this.putBusinessObject(context, (BaseElement)dataAssoc);
            } else {
                this.changesDone = false;
            }
            return dataAssoc;
        }
    }

    public static class ReconnectDataAssociationFeature
    extends AbstractReconnectFlowFeature {
        protected Transaction transaction;

        public ReconnectDataAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canReconnect(IReconnectionContext context) {
            Connection connection = context.getConnection();
            BaseElement source = null;
            BaseElement target = null;
            if (ReconnectionContext.RECONNECT_SOURCE.equals(context.getReconnectType())) {
                source = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getTargetPictogramElement(), BaseElement.class);
                target = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection.getEnd().getParent(), BaseElement.class);
            } else {
                target = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getTargetPictogramElement(), BaseElement.class);
                source = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection.getStart().getParent(), BaseElement.class);
            }
            return DataAssociationFeatureContainer.canConnect(source, target);
        }

        protected Class<? extends EObject> getTargetClass() {
            return BaseElement.class;
        }

        protected Class<? extends EObject> getSourceClass() {
            return BaseElement.class;
        }

        protected void startTransaction() {
            if (this.transaction == null) {
                try {
                    InternalTransactionalEditingDomain transactionalDomain = (InternalTransactionalEditingDomain)this.getDiagramBehavior().getEditingDomain();
                    this.transaction = transactionalDomain.startTransaction(false, null);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        protected void commitTransaction() {
            try {
                this.transaction.commit();
            }
            catch (RollbackException e) {
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.DataAssociationFeatureContainer_Commit_Error_Title, (String)Messages.DataAssociationFeatureContainer_Commit_Error_Message, (IStatus)new Status(4, "org.eclipse.bpmn2.modeler.core", e.getMessage(), (Throwable)e));
            }
        }

        protected void rollbackTransaction() {
            if (this.transaction != null) {
                this.transaction.rollback();
            }
        }

        public void preReconnect(IReconnectionContext context) {
            this.startTransaction();
            PictogramElement targetPictogramElement = context.getTargetPictogramElement();
            if (targetPictogramElement instanceof FreeFormConnection) {
                Shape connectionPointShape = AnchorUtil.createConnectionPoint((IFeatureProvider)this.getFeatureProvider(), (Connection)((FreeFormConnection)targetPictogramElement), (ILocation)context.getTargetLocation());
                if (context instanceof ReconnectionContext) {
                    ReconnectionContext rc = (ReconnectionContext)context;
                    rc.setNewAnchor((Anchor)AnchorUtil.getConnectionPointAnchor((Shape)connectionPointShape));
                    rc.setTargetPictogramElement((PictogramElement)connectionPointShape);
                }
            }
            super.preReconnect(context);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void postReconnect(IReconnectionContext context) {
            CatchEvent event;
            List dataOutputAssociations;
            List dataInputAssociations;
            Connection connection = context.getConnection();
            InputOutputSpecification ioSpec = null;
            OutputSet outputSet = null;
            InputSet inputSet = null;
            this.changesDone = true;
            if (context.getOldAnchor().eContainer() == context.getNewAnchor().eContainer()) {
                DIUtils.updateDIEdge((Connection)connection);
                this.commitTransaction();
                return;
            }
            BPMNEdge edge = (BPMNEdge)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getConnection(), BPMNEdge.class);
            BaseElement oldElement = null;
            BaseElement newElement = null;
            BaseElement otherElement = null;
            DataAssociation oldAssociation = (DataAssociation)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, DataAssociation.class);
            DataAssociation newAssociation = null;
            boolean isInput = true;
            if (ReconnectionContext.RECONNECT_SOURCE.equals(context.getReconnectType())) {
                isInput = false;
                otherElement = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection.getEnd().getParent(), BaseElement.class);
            } else {
                otherElement = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection.getStart().getParent(), BaseElement.class);
            }
            oldElement = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getOldAnchor().getParent(), BaseElement.class);
            newElement = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getTargetPictogramElement(), BaseElement.class);
            if (oldElement instanceof Activity) {
                if (isInput) {
                    ((Activity)oldElement).getDataInputAssociations().remove(otherElement);
                    dataInputAssociations = ((Activity)oldElement).getDataInputAssociations();
                    for (DataInputAssociation dia : dataInputAssociations) {
                        if (!dia.getSourceRef().contains(otherElement)) continue;
                        dataInputAssociations.remove(dia);
                        break;
                    }
                } else {
                    dataOutputAssociations = ((Activity)oldElement).getDataOutputAssociations();
                    for (DataOutputAssociation doa : dataOutputAssociations) {
                        if (doa.getTargetRef() != otherElement) continue;
                        dataOutputAssociations.remove(doa);
                        break;
                    }
                }
            } else if (oldElement instanceof CatchEvent) {
                if (isInput) {
                    throw new IllegalArgumentException(Messages.DataAssociationFeatureContainer_Invalid_Source);
                }
                dataOutputAssociations = ((CatchEvent)oldElement).getDataOutputAssociation();
                for (DataOutputAssociation doa : dataOutputAssociations) {
                    if (doa.getTargetRef() != otherElement) continue;
                    dataOutputAssociations.remove(doa);
                    break;
                }
            } else if (oldElement instanceof ThrowEvent) {
                if (!isInput) throw new IllegalArgumentException(Messages.DataAssociationFeatureContainer_Invalid_Target);
                dataInputAssociations = ((ThrowEvent)oldElement).getDataInputAssociation();
                for (DataInputAssociation dia : dataInputAssociations) {
                    if (!dia.getSourceRef().contains(otherElement)) continue;
                    dataInputAssociations.remove(dia);
                    break;
                }
            } else if (oldElement instanceof ItemAwareElement) {
                newAssociation = oldAssociation;
                if (isInput) {
                    oldAssociation.setTargetRef(null);
                    newAssociation.setTargetRef((ItemAwareElement)newElement);
                } else {
                    oldAssociation.getSourceRef().remove(oldElement);
                    newAssociation.getSourceRef().add((ItemAwareElement)newElement);
                }
            }
            if (newElement instanceof Activity) {
                Activity activity = (Activity)newElement;
                ioSpec = activity.getIoSpecification();
                if (ioSpec == null) {
                    ioSpec = (InputOutputSpecification)Bpmn2ModelerFactory.createFeature((EObject)activity, (String)"ioSpecification");
                }
                if (isInput) {
                    List dataInputs = null;
                    List dataInputAssociations2 = null;
                    if (ioSpec.getInputSets().size() == 0) {
                        inputSet = (InputSet)Bpmn2ModelerFactory.create(InputSet.class);
                        ioSpec.getInputSets().add(inputSet);
                    } else {
                        inputSet = (InputSet)ioSpec.getInputSets().get(0);
                    }
                    dataInputs = ioSpec.getDataInputs();
                    dataInputAssociations2 = activity.getDataInputAssociations();
                    newAssociation = DataAssociationFeatureContainer.selectInput(newElement, dataInputs, dataInputAssociations2, inputSet);
                    if (newAssociation != null) {
                        newAssociation.getSourceRef().clear();
                        newAssociation.getSourceRef().add((ItemAwareElement)otherElement);
                    }
                } else {
                    List dataOutputs = null;
                    List dataOutputAssociations2 = null;
                    if (ioSpec.getOutputSets().size() == 0) {
                        outputSet = (OutputSet)Bpmn2ModelerFactory.create(OutputSet.class);
                        ioSpec.getOutputSets().add(outputSet);
                    } else {
                        outputSet = (OutputSet)ioSpec.getOutputSets().get(0);
                    }
                    dataOutputs = ioSpec.getDataOutputs();
                    dataOutputAssociations2 = activity.getDataOutputAssociations();
                    newAssociation = DataAssociationFeatureContainer.selectOutput(newElement, dataOutputs, dataOutputAssociations2, outputSet);
                    if (newAssociation != null) {
                        newAssociation.setTargetRef((ItemAwareElement)otherElement);
                    }
                }
            } else if (newElement instanceof CatchEvent) {
                if (isInput) {
                    throw new IllegalArgumentException(Messages.DataAssociationFeatureContainer_Invalid_Source);
                }
                event = (CatchEvent)newElement;
                outputSet = event.getOutputSet();
                if (outputSet == null) {
                    outputSet = (OutputSet)Bpmn2ModelerFactory.create(OutputSet.class);
                    event.setOutputSet(outputSet);
                }
                if ((newAssociation = DataAssociationFeatureContainer.selectOutput((BaseElement)event, event.getDataOutputs(), event.getDataOutputAssociation(), outputSet)) != null) {
                    newAssociation.setTargetRef((ItemAwareElement)otherElement);
                }
            } else if (newElement instanceof ThrowEvent) {
                if (!isInput) throw new IllegalArgumentException(Messages.DataAssociationFeatureContainer_Invalid_Target);
                event = (ThrowEvent)newElement;
                inputSet = event.getInputSet();
                if (inputSet == null) {
                    inputSet = (InputSet)Bpmn2ModelerFactory.create(InputSet.class);
                    event.setInputSet(inputSet);
                }
                if ((newAssociation = DataAssociationFeatureContainer.selectInput(newElement, event.getDataInputs(), event.getDataInputAssociation(), inputSet)) != null) {
                    newAssociation.getSourceRef().clear();
                    newAssociation.getSourceRef().add((ItemAwareElement)otherElement);
                }
            } else {
                boolean cfr_ignored_0 = newElement instanceof ItemAwareElement;
            }
            if (newAssociation != null) {
                if (!(newElement instanceof ItemAwareElement)) {
                    EList businessObjects = connection.getLink().getBusinessObjects();
                    int index = businessObjects.indexOf(oldAssociation);
                    businessObjects.remove(index);
                    businessObjects.add(index, newAssociation);
                    edge.setBpmnElement((BaseElement)newAssociation);
                    DataAssociationFeatureContainer.deleteReplacedDataAssociation(this.getFeatureProvider(), connection);
                }
                super.postReconnect(context);
                this.commitTransaction();
                return;
            } else {
                this.changesDone = false;
                this.rollbackTransaction();
            }
        }
    }

    public static class UpdateDataAssociationFeature
    extends AbstractBpmn2UpdateFeature {
        public UpdateDataAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canUpdate(IUpdateContext context) {
            if (context.getPictogramElement() instanceof Connection) {
                return BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), DataAssociation.class) != null;
            }
            return false;
        }

        public IReason updateNeeded(IUpdateContext context) {
            if (this.canUpdate(context)) {
                Connection connection = (Connection)context.getPictogramElement();
                DataAssociation businessObject = (DataAssociation)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), DataAssociation.class);
                String newDirection = DataAssociationFeatureContainer.getDirection(businessObject);
                String oldDirection = Graphiti.getPeService().getPropertyValue((PropertyContainer)connection, DataAssociationFeatureContainer.ASSOCIATION_DIRECTION);
                if (oldDirection == null || oldDirection.isEmpty()) {
                    oldDirection = "";
                }
                if (!oldDirection.equals(newDirection)) {
                    return Reason.createTrueReason();
                }
            }
            return Reason.createFalseReason();
        }

        public boolean update(IUpdateContext context) {
            if (this.canUpdate(context)) {
                Connection connection = (Connection)context.getPictogramElement();
                DataAssociation businessObject = (DataAssociation)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), DataAssociation.class);
                DataAssociationFeatureContainer.setAssociationDirection(connection, businessObject);
            }
            return true;
        }
    }
}

