/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.lane;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.model.ModelHandlerLocator;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.lane.Messages;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateLaneFeature
extends AbstractBpmn2CreateFeature<Lane> {
    public CreateLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canCreate(ICreateContext context) {
        if (!super.canCreate(context)) {
            return false;
        }
        boolean intoDiagram = context.getTargetContainer() instanceof Diagram;
        boolean intoLane = FeatureSupport.isTargetLane((ITargetContext)context);
        boolean intoParticipant = FeatureSupport.isTargetParticipant((ITargetContext)context);
        boolean intoFlowElementContainer = FeatureSupport.isTargetFlowElementsContainer((ITargetContext)context);
        boolean intoGroup = FeatureSupport.isTargetGroup((ITargetContext)context);
        return (intoDiagram || intoLane || intoParticipant || intoFlowElementContainer) && !intoGroup;
    }

    public Object[] create(ICreateContext context) {
        Lane lane = this.createBusinessObject(context);
        lane.setName(String.valueOf(Messages.CreateLaneFeature_Default_Name) + ModelUtil.getIDNumber((String)lane.getId()));
        PictogramElement pe = this.addGraphicalRepresentation((IAreaContext)context, lane);
        return new Object[]{lane, pe};
    }

    public String getCreateImageId() {
        return ImageProvider.IMG_16_LANE;
    }

    public String getCreateLargeImageId() {
        return this.getCreateImageId();
    }

    public EClass getBusinessObjectClass() {
        return Bpmn2Package.eINSTANCE.getLane();
    }

    public Lane createBusinessObject(ICreateContext context) {
        ModelHandler mh = ModelHandlerLocator.getModelHandler((Resource)this.getDiagram().eResource());
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        Lane lane = null;
        if (FeatureSupport.isTargetLane((ITargetContext)context)) {
            Lane targetLane = (Lane)bo;
            lane = ModelHandler.createLane((Lane)targetLane);
        } else {
            lane = mh.createLane(bo);
        }
        this.putBusinessObject(context, (BaseElement)lane);
        return lane;
    }
}

