/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.preferences;

import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.osgi.service.prefs.BackingStoreException;

public class Bpmn2PropertyPage
extends PropertyPage {
    private Bpmn2Preferences preferences;
    private Combo cboRuntimes;
    private Button btnCheckProjectNature;

    public Bpmn2PropertyPage() {
        this.setTitle("BPMN2");
        this.setDescription(Messages.Bpmn2PropertyPage_HomePage_Description);
    }

    protected Control createContents(Composite parent) {
        this.loadPrefs();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        label.setText(Bpmn2Preferences.PREF_TARGET_RUNTIME_LABEL);
        this.cboRuntimes = new Combo(container, 8);
        this.cboRuntimes.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.btnCheckProjectNature = new Button(container, 32);
        this.btnCheckProjectNature.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        this.btnCheckProjectNature.setText(Bpmn2Preferences.PREF_CHECK_PROJECT_NATURE_LABEL);
        this.initData();
        return container;
    }

    private void restoreDefaults() {
        this.preferences.setToDefault("target.runtime");
        this.preferences.getRuntime();
        this.initData();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.restoreDefaults();
    }

    public void loadPrefs() {
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        this.preferences = Bpmn2Preferences.getInstance((IProject)project);
        this.preferences.useProjectPreferences();
    }

    private void initData() {
        this.btnCheckProjectNature.setSelection(this.preferences.getCheckProjectNature());
        TargetRuntime rt = this.preferences.getRuntime();
        int i = 0;
        for (TargetRuntime r : TargetRuntime.createTargetRuntimes()) {
            this.cboRuntimes.add(r.getName());
            this.cboRuntimes.setData(r.getName(), (Object)r);
            if (r == rt) {
                this.cboRuntimes.select(i);
            }
            ++i;
        }
    }

    public boolean performOk() {
        this.setErrorMessage(null);
        try {
            this.updateData();
        }
        catch (BackingStoreException e) {
            Activator.showErrorWithLogging((Exception)((Object)e));
        }
        return true;
    }

    public void dispose() {
        this.preferences.dispose();
        super.dispose();
    }

    private void updateData() throws BackingStoreException {
        int i = this.cboRuntimes.getSelectionIndex();
        TargetRuntime rt = (TargetRuntime)TargetRuntime.createTargetRuntimes().get(i);
        this.preferences.setRuntime(rt);
        this.preferences.setCheckProjectNature(this.btnCheckProjectNature.getSelection());
        this.preferences.flush();
    }
}

