/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.preferences;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.runtime.ModelEnablementDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ModelExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.ui.diagram.Bpmn2FeatureMap;
import org.eclipse.bpmn2.modeler.ui.preferences.Messages;
import org.eclipse.bpmn2.modeler.ui.preferences.ModelEnablementTreeEntry;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.prefs.BackingStoreException;

public class ToolProfilesPreferencesHelper {
    private ModelEnablements modelEnablements;
    private static HashSet<EClass> elementSet = null;
    private TargetRuntime targetRuntime;
    private String profileId;
    private static boolean enableIdAttribute = false;

    private ToolProfilesPreferencesHelper() {
    }

    public ToolProfilesPreferencesHelper(TargetRuntime rt, String profileId) {
        this.targetRuntime = rt;
        this.profileId = profileId;
        this.createElementSet();
    }

    private void createElementSet() {
        if (elementSet == null) {
            elementSet = new HashSet();
            for (Class c : Bpmn2FeatureMap.ALL_SHAPES) {
                elementSet.add((EClass)Bpmn2Package.eINSTANCE.getEClassifier(c.getSimpleName()));
            }
        }
    }

    public static void setEnableIdAttribute(boolean enabled) {
        enableIdAttribute = enabled;
    }

    public static boolean getEnableIdAttribute() {
        return enableIdAttribute;
    }

    public void setModelEnablements(ModelEnablements me) {
        this.modelEnablements = me;
        if (this.modelEnablements != null) {
            this.modelEnablements.setEnableIdAttribute(enableIdAttribute);
        }
    }

    public ModelEnablements getModelEnablements() {
        return this.modelEnablements;
    }

    public void copyModelEnablements(ModelEnablements copyMe) {
        if (this.modelEnablements == null) {
            this.modelEnablements = new ModelEnablements(this.targetRuntime, this.profileId);
        }
        this.modelEnablements.setEnabledAll(false);
        for (String name : copyMe.getAllEnabled()) {
            this.modelEnablements.setEnabled(name, true);
        }
    }

    public void clear() {
        if (this.modelEnablements != null) {
            this.modelEnablements.setEnabledAll(false);
        }
    }

    public List<ModelEnablementTreeEntry> getAllElements() {
        ArrayList<ModelEnablementTreeEntry> ret = new ArrayList<ModelEnablementTreeEntry>();
        for (EClass eClass : elementSet) {
            ModelEnablementTreeEntry entry = new ModelEnablementTreeEntry();
            entry.setElement((ENamedElement)eClass);
            boolean enable = this.isEnabled(eClass);
            entry.setEnabled(enable);
            ret.add(entry);
            HashSet<Object> possibleFeatures = new HashSet<Object>();
            ArrayList<ModelEnablementTreeEntry> children = new ArrayList<ModelEnablementTreeEntry>();
            for (EAttribute eAttribute : eClass.getEAllAttributes()) {
                if ("anyAttribute".equals(eAttribute.getName())) continue;
                possibleFeatures.add(eAttribute);
            }
            for (EReference eReference : eClass.getEAllContainments()) {
                possibleFeatures.add(eReference);
            }
            for (EReference eReference : eClass.getEAllReferences()) {
                possibleFeatures.add(eReference);
            }
            if (!enable) continue;
            for (EStructuralFeature eStructuralFeature : possibleFeatures) {
                ModelEnablementTreeEntry child = new ModelEnablementTreeEntry((ENamedElement)eStructuralFeature, entry);
                enable = this.isEnabled(eClass, (ENamedElement)eStructuralFeature);
                child.setEnabled(enable);
                children.add(child);
            }
            this.sortElements(children);
            entry.setChildren(children);
        }
        this.sortElements(ret);
        return ret;
    }

    private ModelEnablementTreeEntry findOrCreateEntry(List<ModelEnablementTreeEntry> entries, ENamedElement elem, ModelEnablementTreeEntry parent) {
        ModelEnablementTreeEntry entry = this.findEntry(entries, elem, parent);
        if (entry != null) {
            entry.addFriend(parent);
            return entry;
        }
        return new ModelEnablementTreeEntry(elem, parent);
    }

    private ModelEnablementTreeEntry findEntry(List<ModelEnablementTreeEntry> entries, ENamedElement elem, ModelEnablementTreeEntry parent) {
        for (ModelEnablementTreeEntry entry : entries) {
            ModelEnablementTreeEntry t;
            ModelEnablementTreeEntry thisParent = entry.getParent();
            if (thisParent != null && parent != null) {
                if (thisParent.getElement() != parent.getElement()) continue;
                for (ModelEnablementTreeEntry child : thisParent.getChildren()) {
                    ENamedElement thisElem = child.getElement();
                    if (thisElem != elem) continue;
                    return child;
                }
                continue;
            }
            if (thisParent == parent) {
                if (entry.getElement() != elem) continue;
                return entry;
            }
            if (thisParent != null || (t = this.findEntry(entry.getChildren(), elem, parent)) == null) continue;
            return t;
        }
        return null;
    }

    public List<ModelEnablementTreeEntry> getAllExtensionElements(ModelEnablementDescriptor me, List<ModelEnablementTreeEntry> bpmnEntries) {
        ArrayList<ModelEnablementTreeEntry> bpmnModelExtensions = new ArrayList<ModelEnablementTreeEntry>();
        ModelEnablementTreeEntry bpmnModelExtensionsRoot = new ModelEnablementTreeEntry();
        bpmnModelExtensionsRoot.setEnabled(true);
        bpmnModelExtensionsRoot.setName(Messages.ToolEnablementPreferences_BPMN_Extensions);
        TargetRuntime rt = me.getRuntime();
        for (ModelExtensionDescriptor med : rt.getAllModelExtensionDescriptors()) {
            String className;
            EClassifier eclass;
            if (med.getProperties().size() > 0 && (eclass = me.getClassifier(className = med.getType())) instanceof EClass) {
                ModelEnablementTreeEntry entry = new ModelEnablementTreeEntry((ENamedElement)eclass, bpmnModelExtensionsRoot);
                entry.setEnabled(this.isEnabled((EClass)eclass));
                bpmnModelExtensions.add(entry);
            }
            for (ModelEnablementTreeEntry entry : bpmnModelExtensions) {
                for (ModelExtensionDescriptor med2 : rt.getAllModelExtensionDescriptors()) {
                    if (!entry.getName().equals(med2.getType())) continue;
                    ArrayList<ModelEnablementTreeEntry> children = new ArrayList<ModelEnablementTreeEntry>();
                    for (ModelExtensionDescriptor.Property p : med2.getProperties()) {
                        EClass eclass2 = (EClass)entry.getElement();
                        EStructuralFeature feature = me.getFeature(med2.getType(), p.name);
                        if (feature == null) {
                            feature = med2.getFeature((EObject)eclass2, p);
                        }
                        if (!(feature instanceof EAttribute)) continue;
                        ModelEnablementTreeEntry child = this.findOrCreateEntry(bpmnEntries, (ENamedElement)feature, entry);
                        child.setEnabled(this.isEnabled(eclass2, (ENamedElement)feature));
                        children.add(child);
                    }
                    this.sortElements(children);
                    entry.setChildren(children);
                }
            }
        }
        this.sortElements(bpmnModelExtensions);
        bpmnModelExtensionsRoot.setChildren(bpmnModelExtensions);
        ModelEnablementTreeEntry runtimeModelExtensionsRoot = new ModelEnablementTreeEntry();
        runtimeModelExtensionsRoot.setEnabled(true);
        runtimeModelExtensionsRoot.setName(Messages.ToolEnablementPreferences_Target_Extensions);
        ArrayList<ModelEnablementTreeEntry> runtimeModelExtensions = new ArrayList<ModelEnablementTreeEntry>();
        for (EClassifier ec : rt.getModelDescriptor().getEPackage().getEClassifiers()) {
            EClass eclass;
            if (!(ec instanceof EClass) || (eclass = (EClass)ec).getName().equals("DocumentRoot")) continue;
            ModelEnablementTreeEntry entry = new ModelEnablementTreeEntry((ENamedElement)eclass, runtimeModelExtensionsRoot);
            entry.setEnabled(this.isEnabled(eclass));
            runtimeModelExtensions.add(entry);
            HashSet<Object> possibleFeatures = new HashSet<Object>();
            ArrayList<ModelEnablementTreeEntry> children = new ArrayList<ModelEnablementTreeEntry>();
            for (EAttribute eAttribute : eclass.getEAllAttributes()) {
                possibleFeatures.add(eAttribute);
            }
            for (EReference eReference : eclass.getEAllContainments()) {
                possibleFeatures.add(eReference);
            }
            for (EReference eReference : eclass.getEAllReferences()) {
                possibleFeatures.add(eReference);
            }
            for (EStructuralFeature eStructuralFeature : possibleFeatures) {
                ModelEnablementTreeEntry modelEnablementTreeEntry = this.findOrCreateEntry(bpmnEntries, (ENamedElement)eStructuralFeature, entry);
                modelEnablementTreeEntry.setEnabled(this.isEnabled(eclass, (ENamedElement)eStructuralFeature));
                children.add(modelEnablementTreeEntry);
            }
            this.sortElements(children);
            entry.setChildren(children);
        }
        this.sortElements(runtimeModelExtensions);
        runtimeModelExtensionsRoot.setChildren(runtimeModelExtensions);
        ArrayList<ModelEnablementTreeEntry> allExtensions = new ArrayList<ModelEnablementTreeEntry>();
        allExtensions.add(bpmnModelExtensionsRoot);
        allExtensions.add(runtimeModelExtensionsRoot);
        return allExtensions;
    }

    private void sortElements(ArrayList<ModelEnablementTreeEntry> ret) {
        Collections.sort(ret, new Comparator<ModelEnablementTreeEntry>(){

            @Override
            public int compare(ModelEnablementTreeEntry o1, ModelEnablementTreeEntry o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
    }

    public boolean isEnabled(EClass element) {
        if (this.modelEnablements == null) {
            return false;
        }
        return this.modelEnablements.isEnabled(element);
    }

    public boolean isEnabled(String name) {
        if (this.modelEnablements == null) {
            return false;
        }
        return this.modelEnablements.isEnabled(name);
    }

    public boolean isEnabled(EClass c, ENamedElement element) {
        if (this.modelEnablements == null) {
            return false;
        }
        return this.modelEnablements.isEnabled(c.getName(), element.getName());
    }

    public boolean isEnabled(ModelEnablementTreeEntry entry) {
        if (this.modelEnablements == null) {
            return false;
        }
        return this.modelEnablements.isEnabled(entry.getPreferenceName());
    }

    public void setEnabled(ModelEnablementTreeEntry entry, boolean enabled) {
        if (this.modelEnablements != null) {
            this.modelEnablements.setEnabled(entry.getPreferenceName(), enabled);
        }
    }

    public void importProfile(String path) throws FileNotFoundException, IOException, BackingStoreException {
        Properties p = new Properties();
        p.load(new FileInputStream(path));
        ModelEnablements me = new ModelEnablements(this.targetRuntime, this.profileId);
        for (Object key : p.keySet()) {
            Object value = p.get(key);
            if (!(key instanceof String) || !(value instanceof String)) continue;
            boolean enabled = Boolean.parseBoolean((String)value);
            me.setEnabled((String)key, enabled);
        }
    }

    public void exportProfile(String path) throws BackingStoreException, FileNotFoundException, IOException {
        FileWriter fw = new FileWriter(path);
        boolean writeXml = path.endsWith(".xml");
        List keys = this.modelEnablements.getAllEnabled();
        Collections.sort(keys);
        ModelEnablementDescriptor med = this.targetRuntime.getModelEnablements(this.profileId);
        String profileName = med.getProfileName();
        String description = med.getDescription();
        if (writeXml) {
            fw.write("\t\t<modelEnablement");
            fw.write(" runtimeId=\"" + this.targetRuntime.getId() + "\"");
            fw.write(" id=\"" + this.profileId + "\"");
            fw.write(" profile=\"" + profileName + "\"");
            fw.write(" description=\"" + description + "\"");
            fw.write(">\r\n");
            fw.write("\t\t\t<disable object=\"all\"/>\r\n");
        }
        for (String k : keys) {
            boolean enable = this.isEnabled(k);
            if (writeXml) {
                if (!enable || !k.contains(".")) continue;
                String[] a = k.split("\\.");
                fw.write("\t\t\t<enable object=\"" + a[0] + "\" feature=\"" + a[1] + "\"/>\r\n");
                continue;
            }
            fw.write(String.valueOf(k) + "=" + enable + "\r\n");
        }
        if (writeXml) {
            fw.write("\t</modelEnablement>\r\n");
        }
        fw.flush();
        fw.close();
    }
}

