/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.diagrams;

import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.ParticipantMultiplicity;
import org.eclipse.bpmn2.modeler.core.adapters.InsertionAdapter;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.IntObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.ui.property.data.InterfacePropertySection;
import org.eclipse.bpmn2.modeler.ui.property.diagrams.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ParticipantDetailComposite
extends DefaultDetailComposite {
    protected InterfacePropertySection.ProvidedInterfaceListComposite providedInterfacesTable;

    public ParticipantDetailComposite(Composite parent, int style) {
        super(parent, style);
    }

    public ParticipantDetailComposite(AbstractBpmn2PropertySection section) {
        super(section);
    }

    public AbstractPropertiesProvider getPropertiesProvider(EObject object) {
        if (this.propertiesProvider == null) {
            this.propertiesProvider = new AbstractPropertiesProvider(object){
                String[] properties;
                {
                    this.properties = new String[]{"processRef", "participantMultiplicity", "interfaceRefs", "endPointRefs"};
                }

                public String[] getProperties() {
                    return this.properties;
                }
            };
        }
        return this.propertiesProvider;
    }

    public void cleanBindings() {
        super.cleanBindings();
        this.providedInterfacesTable = null;
    }

    protected void bindReference(Composite parent, EObject object, EReference reference) {
        if (this.isModelObjectEnabled(object.eClass(), (EStructuralFeature)reference)) {
            if (parent == null) {
                parent = this.getAttributesParent();
            }
            Participant participant = (Participant)object;
            if ("processRef".equals(reference.getName())) {
                PictogramElement[] pes = this.getDiagramEditor().getSelectedPictogramElements();
                if (pes.length == 1) {
                    if (FeatureSupport.isChoreographyParticipantBand((PictogramElement)pes[0])) {
                        super.bindReference(parent, object, reference);
                    } else {
                        TextObjectEditor editor = new TextObjectEditor((AbstractDetailComposite)this, object, (EStructuralFeature)reference);
                        String label = this.getBusinessObjectDelegate().getLabel(object, (EStructuralFeature)reference);
                        editor.createControl(parent, label);
                        editor.setEditable(false);
                    }
                }
            } else if ("participantMultiplicity".equals(reference.getName())) {
                Composite composite = this.getToolkit().createComposite(parent);
                composite.setLayout((Layout)new GridLayout(7, true));
                composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
                this.createLabel(composite, Messages.ParticipantDetailComposite_Multiplicity_Label);
                ParticipantMultiplicity pm = participant.getParticipantMultiplicity() != null ? participant.getParticipantMultiplicity() : Bpmn2Factory.eINSTANCE.createParticipantMultiplicity();
                InsertionAdapter.add((EObject)object, (EStructuralFeature)Bpmn2Package.eINSTANCE.getParticipant_ParticipantMultiplicity(), (EObject)pm);
                MyIntObjectEditor minEditor = new MyIntObjectEditor((AbstractDetailComposite)this, (EObject)pm, (EStructuralFeature)Bpmn2Package.eINSTANCE.getParticipantMultiplicity_Minimum());
                minEditor.createControl(composite, Messages.ParticipantDetailComposite_Mimimum_Label);
                MyIntObjectEditor maxEditor = new MyIntObjectEditor((AbstractDetailComposite)this, (EObject)pm, (EStructuralFeature)Bpmn2Package.eINSTANCE.getParticipantMultiplicity_Maximum());
                maxEditor.createControl(composite, Messages.ParticipantDetailComposite_Maximum_Label);
                minEditor.updateText();
            } else if ("interfaceRefs".equals(reference.getName())) {
                this.providedInterfacesTable = new InterfacePropertySection.ProvidedInterfaceListComposite((Composite)this);
                this.providedInterfacesTable.bindList(object, this.getFeature(object, "interfaceRefs"));
            } else {
                super.bindReference(parent, object, reference);
            }
        }
    }

    private class MyIntObjectEditor
    extends IntObjectEditor {
        public MyIntObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
            super(parent, object, feature);
        }

        public void updateText() {
            super.updateText();
            ParticipantMultiplicity pm = (ParticipantMultiplicity)this.object;
            if (pm.getMinimum() >= pm.getMaximum()) {
                ErrorUtils.showErrorMessage((String)Messages.ParticipantDetailComposite_MinMax_Error);
            }
        }
    }
}

