/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.editors;

import javax.xml.namespace.QName;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextAndButtonObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.NamespaceUtil;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.SchemaSelectionDialog;
import org.eclipse.bpmn2.modeler.ui.property.editors.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class SchemaObjectEditor
extends TextAndButtonObjectEditor {
    public SchemaObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    protected Control createControl(Composite composite, String label, int style) {
        super.createControl(composite, label, style);
        this.text.setEditable(true);
        this.defaultButton.setText(Messages.SchemaObjectEditor_Browse_Button);
        return this.text;
    }

    protected void buttonClicked(int buttonId) {
        Object[] result = SchemaObjectEditor.showSchemaSelectionDialog((Composite)this.parent, this.object);
        if (result.length == 2) {
            this.setValue((String)result[0]);
            if (this.object instanceof ItemDefinition) {
                ((ItemDefinition)this.object).setImport((Import)result[1]);
            }
        }
    }

    public static Object[] showSchemaSelectionDialog(Composite parent, EObject object) {
        SchemaSelectionDialog dialog = new SchemaSelectionDialog(parent.getShell(), object);
        if (dialog.open() == 0) {
            String prefix;
            String ns;
            XSDSchema schema;
            String prefix2;
            QName qname;
            Resource resource = object.eResource();
            Object element = dialog.getResult()[0];
            Import importRef = (Import)dialog.getResult()[1];
            String selectionPath = dialog.getSelectionPath();
            String value = "";
            String selectionType = "";
            if (element instanceof PortType) {
                PortType portType = (PortType)element;
                qname = portType.getQName();
                prefix2 = NamespaceUtil.getPrefixForNamespace((Resource)resource, (String)qname.getNamespaceURI());
                if (prefix2 == null) {
                    prefix2 = NamespaceUtil.addNamespace((Resource)resource, (String)qname.getNamespaceURI());
                }
                if (prefix2 != null) {
                    value = String.valueOf(prefix2) + ":";
                }
                value = String.valueOf(value) + qname.getLocalPart();
                selectionType = Messages.SchemaObjectEditor_WSDL_Port;
            }
            if (element instanceof Operation) {
                selectionType = Messages.SchemaObjectEditor_WSDL_Operation;
            }
            if (element instanceof Input) {
                Input input = (Input)element;
                element = input.getMessage();
                selectionType = Messages.SchemaObjectEditor_WSDL_Input;
            }
            if (element instanceof Output) {
                Output output = (Output)element;
                element = output.getMessage();
                selectionType = Messages.SchemaObjectEditor_WSDL_Output;
            }
            if (element instanceof Fault) {
                Fault fault = (Fault)element;
                element = fault.getMessage();
                selectionType = Messages.SchemaObjectEditor_WSDL_Fault;
            }
            if (element instanceof Part) {
                Part part = (Part)element;
                element = part.getElementDeclaration();
                selectionType = Messages.SchemaObjectEditor_WSDL_Message_Part;
            }
            if (element instanceof Message) {
                Message message = (Message)element;
                qname = message.getQName();
                prefix2 = NamespaceUtil.getPrefixForNamespace((Resource)resource, (String)qname.getNamespaceURI());
                if (prefix2 == null) {
                    prefix2 = NamespaceUtil.addNamespace((Resource)resource, (String)qname.getNamespaceURI());
                }
                if (prefix2 != null) {
                    value = String.valueOf(prefix2) + ":";
                }
                value = String.valueOf(value) + qname.getLocalPart();
                selectionType = Messages.SchemaObjectEditor_WSDL_Message;
            }
            if (element instanceof XSDAttributeDeclaration) {
                selectionType = Messages.SchemaObjectEditor_XML_Attribute;
            }
            if (element instanceof XSDElementDeclaration) {
                XSDTypeDefinition type;
                XSDElementDeclaration decl = (XSDElementDeclaration)element;
                schema = SchemaObjectEditor.getContainingSchema((EObject)decl);
                ns = schema.getTargetNamespace();
                if (ns == null && (type = decl.getTypeDefinition()) != null) {
                    ns = type.getSchema().getTargetNamespace();
                }
                if ((prefix = NamespaceUtil.getPrefixForNamespace((Resource)resource, (String)ns)) != null) {
                    value = String.valueOf(prefix) + ":";
                }
                value = String.valueOf(value) + selectionPath;
            }
            if (element instanceof XSDTypeDefinition) {
                XSDTypeDefinition type = (XSDTypeDefinition)element;
                schema = SchemaObjectEditor.getContainingSchema((EObject)type);
                ns = schema.getTargetNamespace();
                prefix = NamespaceUtil.getPrefixForNamespace((Resource)resource, (String)ns);
                if (prefix != null) {
                    value = String.valueOf(prefix) + ":";
                }
                value = String.valueOf(value) + selectionPath;
            }
            if (element instanceof XSDSchema) {
                XSDSchema schema2 = (XSDSchema)element;
                String prefix3 = NamespaceUtil.getPrefixForNamespace((Resource)resource, (String)schema2.getTargetNamespace());
                if (prefix3 != null) {
                    value = String.valueOf(prefix3) + ":";
                }
                value = String.valueOf(value) + "schema";
            }
            if (element instanceof Process) {
                Process process = (Process)element;
                process.getSupportedInterfaceRefs();
            }
            if (element instanceof IType) {
                value = ((IType)element).getFullyQualifiedName('.');
            }
            if (value.isEmpty()) {
                MessageDialog.openWarning((Shell)parent.getShell(), (String)Messages.SchemaObjectEditor_Invalid_Selection_Title, (String)NLS.bind((String)Messages.SchemaObjectEditor_Invalid_Selection_Message, (Object)selectionType));
            } else {
                return new Object[]{value, importRef};
            }
        }
        return new Object[0];
    }

    private static XSDSchema getContainingSchema(EObject object) {
        EObject container = object.eContainer();
        if (container instanceof XSDSchema) {
            return (XSDSchema)container;
        }
        if (container != null) {
            return SchemaObjectEditor.getContainingSchema(container);
        }
        return null;
    }
}

