/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerResourceSetImpl;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.Bpmn2DiagramEditorInput;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.wizards.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class FileService {
    public static TransactionalEditingDomain createEmfFileForDiagram(URI diagramResourceUri, final Diagram diagram, BPMN2Editor diagramEditor) {
        Bpmn2ModelerResourceSetImpl resourceSet = null;
        TransactionalEditingDomain editingDomain = null;
        if (diagramEditor == null) {
            resourceSet = new Bpmn2ModelerResourceSetImpl();
            editingDomain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet);
            if (editingDomain == null) {
                editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)resourceSet);
            }
        } else {
            editingDomain = diagramEditor.getEditingDomain();
            resourceSet = diagramEditor.getResourceSet();
        }
        final Resource resource = resourceSet.createResource(diagramResourceUri);
        CommandStack commandStack = editingDomain.getCommandStack();
        commandStack.execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                resource.setTrackingModification(true);
                resource.getContents().add((Object)diagram);
            }
        });
        FileService.save(editingDomain, Collections.<Resource, Map<?, ?>>emptyMap());
        return editingDomain;
    }

    private static void save(TransactionalEditingDomain editingDomain, Map<Resource, Map<?, ?>> options) {
        FileService.saveInWorkspaceRunnable(editingDomain, options);
    }

    private static void saveInWorkspaceRunnable(final TransactionalEditingDomain editingDomain, final Map<Resource, Map<?, ?>> options) {
        final HashMap<URI, Throwable> failedSaves = new HashMap<URI, Throwable>();
        IWorkspaceRunnable wsRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        InternalTransaction parentTx;
                        if (editingDomain != null && (parentTx = ((TransactionalEditingDomainImpl)editingDomain).getActiveTransaction()) != null) {
                            do {
                                if (parentTx.isReadOnly()) continue;
                                throw new IllegalStateException("FileService.save() called from within a command (likely produces a deadlock)");
                            } while ((parentTx = ((TransactionalEditingDomainImpl)editingDomain).getActiveTransaction().getParent()) != null);
                        }
                        EList resources = editingDomain.getResourceSet().getResources();
                        Object[] resourcesArray = new Resource[resources.size()];
                        resourcesArray = (Resource[])resources.toArray(resourcesArray);
                        HashSet<Object> savedResources = new HashSet<Object>();
                        int i = 0;
                        while (i < resourcesArray.length) {
                            Object resource = resourcesArray[i];
                            if (resource.isModified()) {
                                try {
                                    resource.save((Map)options.get(resource));
                                    savedResources.add(resource);
                                }
                                catch (Throwable t) {
                                    failedSaves.put(resource.getURI(), t);
                                }
                            }
                            ++i;
                        }
                    }
                };
                try {
                    editingDomain.runExclusive(runnable);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                editingDomain.getCommandStack().flush();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wsRunnable, null);
            if (!failedSaves.isEmpty()) {
                throw new WrappedException(FileService.createMessage(failedSaves), (Exception)new RuntimeException());
            }
        }
        catch (CoreException e) {
            Throwable cause = e.getStatus().getException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    private static String createMessage(Map<URI, Throwable> failedSaves) {
        StringBuilder buf = new StringBuilder(Messages.FileService_Save_Error);
        for (Map.Entry<URI, Throwable> entry : failedSaves.entrySet()) {
            buf.append("\nURI: ").append(entry.getKey().toString()).append(",\n").append(FileService.getExceptionAsString(entry.getValue()));
        }
        return buf.toString();
    }

    private static String getExceptionAsString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        String result = stringWriter.toString();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {}
        printWriter.close();
        return result;
    }

    public static InputStream getInputContents(IEditorInput input) {
        try {
            if (input instanceof Bpmn2DiagramEditorInput) {
                IFile file;
                URI uri = FileService.getInputUri(input);
                if (uri.isFile()) {
                    File file2 = new File(uri.toFileString());
                    if (file2.exists()) {
                        return new FileInputStream(file2);
                    }
                } else if (uri.isPlatformResource() && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)))).exists()) {
                    return file.getContents();
                }
            } else {
                URI uri;
                File file;
                if (input instanceof FileEditorInput) {
                    return ((FileEditorInput)input).getFile().getContents();
                }
                if (input instanceof IStorageEditorInput) {
                    return ((IStorageEditorInput)input).getStorage().getContents();
                }
                if (input instanceof FileStoreEditorInput && (file = new File((uri = FileService.getInputUri(input)).toFileString())).exists()) {
                    return new FileInputStream(file);
                }
            }
        }
        catch (Exception e) {
            Activator.logError(e);
        }
        return null;
    }

    public static URI getInputUri(IEditorInput input) {
        if (input instanceof Bpmn2DiagramEditorInput) {
            URI uri = ((Bpmn2DiagramEditorInput)input).getModelUri();
            return uri.trimFragment();
        }
        if (input instanceof FileEditorInput) {
            IPath path = ((FileEditorInput)input).getFile().getFullPath();
            return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
        }
        if (input instanceof IURIEditorInput) {
            String uri = ((IURIEditorInput)input).getURI().toString();
            return URI.createURI((String)uri, (boolean)true);
        }
        if (input instanceof FileStoreEditorInput) {
            java.net.URI juri = ((FileStoreEditorInput)input).getURI();
            return URI.createFileURI((String)juri.getPath());
        }
        if (input instanceof IStorageEditorInput) {
            IStorageEditorInput sei = (IStorageEditorInput)input;
            try {
                IPath path = sei.getStorage().getFullPath();
                if (path != null) {
                    return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
                }
                String name = sei.getStorage().getName();
                InputStream istream = sei.getStorage().getContents();
                File file = FileService.createTempFile(name, istream);
                return URI.createFileURI((String)file.getPath());
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static String createTempName(String name) {
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(File.separator)) {
            tempDir = String.valueOf(tempDir) + File.separator;
        }
        String tempName = String.valueOf(tempDir) + name + "." + EcoreUtil.generateUUID();
        return tempName;
    }

    public static File createTempFile(String name) {
        return FileService.createTempFile(name, null);
    }

    public static File createTempFile(String name, InputStream istream) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(name, ".bpmn");
            if (istream != null) {
                FileOutputStream ostream = new FileOutputStream(tempFile);
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = istream.read(bytes)) != -1) {
                    ((OutputStream)ostream).write(bytes, 0, read);
                }
                istream.close();
                ostream.flush();
                ((OutputStream)ostream).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempFile;
    }

    public static boolean isTempFile(URI uri) {
        String tempDir = System.getProperty("java.io.tmpdir");
        String uriDir = uri.trimFragment().trimSegments(1).devicePath();
        return tempDir != null && tempDir.compareToIgnoreCase(uriDir) == 0;
    }

    public static void deleteTempFile(URI uri) {
        File file = new File(uri.toFileString());
        if (file.exists()) {
            file.delete();
        }
    }
}

