/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command;

import java.util.LinkedList;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.AbstractMIControl;
import org.eclipse.cdt.dsf.mi.service.command.CLIEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.IEventProcessor;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIExecContinue;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIExecFinish;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIExecNext;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIExecNextInstruction;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIExecReturn;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIExecStep;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIExecStepInstruction;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIExecUntil;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MICatchpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIFunctionFinishedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIInferiorExitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIInferiorSignalExitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MILocationReachedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIRunningEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISharedLibEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISignalEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISteppingRangeEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIWatchpointScopeEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIWatchpointTriggerEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIExecAsyncOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStreamRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;

public class MIRunControlEventProcessor
implements IEventProcessor {
    private static final String STOPPED_REASON = "stopped";
    private final AbstractMIControl fCommandControl;
    private final ICommandControlService.ICommandControlDMContext fControlDmc;
    private final DsfServicesTracker fServicesTracker;

    public MIRunControlEventProcessor(AbstractMIControl connection, ICommandControlService.ICommandControlDMContext controlDmc) {
        this.fCommandControl = connection;
        this.fControlDmc = controlDmc;
        this.fServicesTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fCommandControl.getSession().getId());
        connection.addEventListener(this);
        connection.addCommandListener(this);
    }

    @Override
    public void dispose() {
        this.fCommandControl.removeEventListener(this);
        this.fCommandControl.removeCommandListener(this);
        this.fServicesTracker.dispose();
    }

    /*
     * Could not resolve type clashes
     */
    public void eventReceived(Object output) {
        MIOOBRecord[] mIOOBRecordArray = ((MIOutput)output).getMIOOBRecords();
        int n = mIOOBRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIExecAsyncOutput exec;
            String state;
            MIOOBRecord oobr = mIOOBRecordArray[n2];
            LinkedList events = new LinkedList();
            if (oobr instanceof MIExecAsyncOutput && STOPPED_REASON.equals(state = (exec = (MIExecAsyncOutput)oobr).getAsyncClass())) {
                MIEvent<?> e;
                this.fCommandControl.resetCurrentThreadLevel();
                this.fCommandControl.resetCurrentStackLevel();
                MIResult[] results = exec.getMIResults();
                int i = 0;
                while (i < results.length) {
                    String reason;
                    MIEvent<?> e2;
                    String var = results[i].getVariable();
                    MIValue val = results[i].getMIValue();
                    if (var.equals("reason") && val instanceof MIConst && (e2 = this.createEvent(reason = ((MIConst)val).getString(), exec)) != null) {
                        events.add(e2);
                    }
                    ++i;
                }
                if (events.isEmpty()) {
                    MIStreamRecord[] streamRecords;
                    MIStreamRecord[] mIStreamRecordArray = streamRecords = ((MIOutput)output).getStreamRecords();
                    int reason = streamRecords.length;
                    int val = 0;
                    while (val < reason) {
                        MIStreamRecord streamRecord = mIStreamRecordArray[val];
                        String log = streamRecord.getString();
                        if (log.startsWith("Catchpoint ")) {
                            events.add(MICatchpointHitEvent.parse(this.getExecutionContext(exec), exec.getToken(), results, streamRecord));
                        }
                        ++val;
                    }
                }
                if (events.isEmpty() && (e = this.createEvent(STOPPED_REASON, exec)) != null) {
                    events.add(e);
                }
                for (MIEvent event : events) {
                    this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
                }
            }
            ++n2;
        }
        MIResultRecord rr = ((MIOutput)output).getMIResultRecord();
        if (rr != null) {
            int id = rr.getToken();
            String state = rr.getResultClass();
            if ("error".equals(state)) {
                MIResult[] results = rr.getMIResults();
                int i = 0;
                while (i < results.length) {
                    String message;
                    String var = results[i].getVariable();
                    MIValue val = results[i].getMIValue();
                    if (var.equals("msg") && val instanceof MIConst && (message = ((MIConst)val).getString()).toLowerCase().startsWith("quit")) {
                        IMIContainerDMContext processContainerDmc;
                        IRunControl runControl = (IRunControl)this.fServicesTracker.getService(IRunControl.class);
                        IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
                        if (runControl != null && procService != null && !runControl.isSuspended((IRunControl.IExecutionDMContext)(processContainerDmc = procService.createContainerContextFromGroupId(this.fControlDmc, "")))) {
                            MISignalEvent event = MISignalEvent.parse((IRunControl.IExecutionDMContext)processContainerDmc, id, rr.getMIResults());
                            this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected IRunControl.IExecutionDMContext getExecutionContext(MIExecAsyncOutput exec) {
        String threadId = null;
        MIResult[] results = exec.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue val = results[i].getMIValue();
            if (var.equals("thread-id") && val instanceof MIConst) {
                threadId = ((MIConst)val).getString();
            }
            ++i;
        }
        IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
        if (procService == null) {
            return null;
        }
        IMIContainerDMContext processContainerDmc = procService.createContainerContextFromGroupId(this.fControlDmc, "");
        Object execDmc = processContainerDmc;
        if (threadId != null) {
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)processContainerDmc, IProcesses.IProcessDMContext.class);
            IProcesses.IThreadDMContext threadDmc = procService.createThreadContext(procDmc, threadId);
            execDmc = procService.createExecutionContext(processContainerDmc, threadDmc, threadId);
        }
        return execDmc;
    }

    @ConfinedToDsfExecutor(value="")
    protected MIEvent<?> createEvent(String reason, MIExecAsyncOutput exec) {
        IRunControl.IExecutionDMContext execDmc = this.getExecutionContext(exec);
        MIEvent event = null;
        if ("breakpoint-hit".equals(reason)) {
            event = MIBreakpointHitEvent.parse(execDmc, exec.getToken(), exec.getMIResults());
        } else if ("watchpoint-trigger".equals(reason) || "read-watchpoint-trigger".equals(reason) || "access-watchpoint-trigger".equals(reason)) {
            event = MIWatchpointTriggerEvent.parse(execDmc, exec.getToken(), exec.getMIResults());
        } else if ("watchpoint-scope".equals(reason)) {
            event = MIWatchpointScopeEvent.parse(execDmc, exec.getToken(), exec.getMIResults());
        } else if ("end-stepping-range".equals(reason)) {
            event = MISteppingRangeEvent.parse(execDmc, exec.getToken(), exec.getMIResults());
        } else if ("signal-received".equals(reason)) {
            event = MISignalEvent.parse(execDmc, exec.getToken(), exec.getMIResults());
        } else if ("location-reached".equals(reason)) {
            event = MILocationReachedEvent.parse(execDmc, exec.getToken(), exec.getMIResults());
        } else if ("function-finished".equals(reason)) {
            event = MIFunctionFinishedEvent.parse(execDmc, exec.getToken(), exec.getMIResults());
        } else if ("solib-event".equals(reason)) {
            event = MISharedLibEvent.parse(execDmc, exec.getToken(), exec.getMIResults(), null);
        } else if ("exited-normally".equals(reason) || "exited".equals(reason)) {
            event = MIInferiorExitEvent.parse(this.fCommandControl.getContext(), exec.getToken(), exec.getMIResults());
            this.sendContainerExitedEvent();
        } else if ("exited-signalled".equals(reason)) {
            event = MIInferiorSignalExitEvent.parse(this.fCommandControl.getContext(), exec.getToken(), exec.getMIResults());
            this.sendContainerExitedEvent();
        } else if (STOPPED_REASON.equals(reason)) {
            event = MIStoppedEvent.parse(execDmc, exec.getToken(), exec.getMIResults());
        }
        return event;
    }

    private void sendContainerExitedEvent() {
        IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
        if (procService != null) {
            IMIContainerDMContext processContainerDmc = procService.createContainerContextFromGroupId(this.fControlDmc, "");
            this.fCommandControl.getSession().dispatchEvent((Object)new MIProcesses.ContainerExitedDMEvent(processContainerDmc), this.fCommandControl.getProperties());
        }
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandSent(ICommandToken token) {
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        ICommand cmd = token.getCommand();
        MIInfo cmdResult = (MIInfo)result;
        MIOutput output = cmdResult.getMIOutput();
        MIResultRecord rr = output.getMIResultRecord();
        if (rr != null) {
            int id = rr.getToken();
            String state = rr.getResultClass();
            if ("running".equals(state)) {
                int type = 0;
                type = cmd instanceof MIExecNext ? 1 : (cmd instanceof MIExecNextInstruction ? 2 : (cmd instanceof MIExecStep ? 3 : (cmd instanceof MIExecStepInstruction ? 4 : (cmd instanceof MIExecUntil ? 6 : (cmd instanceof MIExecFinish ? 5 : (cmd instanceof MIExecReturn ? 7 : (cmd instanceof MIExecContinue ? 0 : 0)))))));
                IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
                if (procService != null) {
                    IMIContainerDMContext processContainerDmc = procService.createContainerContextFromGroupId(this.fControlDmc, "");
                    this.fCommandControl.getSession().dispatchEvent((Object)new MIRunningEvent((IRunControl.IExecutionDMContext)processContainerDmc, id, type), this.fCommandControl.getProperties());
                }
            } else if (!"exit".equals(state)) {
                if ("connected".equals(state)) {
                    IMIProcesses procService;
                    IGDBBackend backendService = (IGDBBackend)this.fServicesTracker.getService(IGDBBackend.class);
                    if (backendService != null && !backendService.getIsAttachSession() && (procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class)) != null) {
                        IMIContainerDMContext processContainerDmc = procService.createContainerContextFromGroupId(this.fControlDmc, "");
                        this.fCommandControl.getSession().dispatchEvent((Object)new MIProcesses.ContainerStartedDMEvent(processContainerDmc), this.fCommandControl.getProperties());
                    }
                } else if (!"error".equals(state) && "done".equals(state) && cmd instanceof CLICommand) {
                    boolean isAttachingOperation = CLIEventProcessor.isAttachingOperation(((CLICommand)cmd).getOperation());
                    boolean isSteppingOperation = CLIEventProcessor.isSteppingOperation(((CLICommand)cmd).getOperation());
                    if (isSteppingOperation || isAttachingOperation) {
                        IRunControl runControl = (IRunControl)this.fServicesTracker.getService(IRunControl.class);
                        IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
                        if (runControl != null && procService != null) {
                            IMIContainerDMContext processContainerDmc = procService.createContainerContextFromGroupId(this.fControlDmc, "");
                            if (isAttachingOperation || !runControl.isSuspended((IRunControl.IExecutionDMContext)processContainerDmc)) {
                                MIStoppedEvent event = MIStoppedEvent.parse((IRunControl.IExecutionDMContext)processContainerDmc, id, rr.getMIResults());
                                this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
                            }
                        }
                    }
                }
            }
        }
    }
}

