/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogLoadUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogNickname;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogRelationalRemoteServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogUserMapping;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.RemoteCatalogProvider;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.FederatedProcedure;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWFactory;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWGenericServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWNickname;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWOption;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWWrapper;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.RemoteServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWGenericServerImpl;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogFederatedServer
extends LUWGenericServerImpl
implements ICatalogObject,
IDatabaseObject {
    private static RemoteCatalogProvider remoteCatalogProvider = null;
    private static boolean remoteCatalogProviderLoaded = false;
    private String wrapperName = "";
    private boolean nicknamesLoaded = false;
    private boolean wrapperLoaded = false;
    private boolean userMappingsLoaded = false;
    private boolean optionsLoaded = false;
    private boolean remoteServerLoaded = false;
    private boolean impactsLoaded = false;
    private Collection impacts = new ArrayList();

    public static RemoteCatalogProvider getRemoteCatalogProvider() {
        if (!remoteCatalogProviderLoaded) {
            remoteCatalogProviderLoaded = true;
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.db2.luw", "remoteCatalog");
            IExtension[] extensions = extensionPoint.getExtensions();
            if (extensions.length == 1) {
                IConfigurationElement[] configElements = extensions[0].getConfigurationElements();
                try {
                    remoteCatalogProvider = (RemoteCatalogProvider)configElements[0].createExecutableExtension("class");
                }
                catch (Exception exception) {}
            }
        }
        return remoteCatalogProvider;
    }

    public synchronized void refresh() {
        ICatalogObject remoteDB;
        this.nicknamesLoaded = false;
        this.wrapperLoaded = false;
        this.userMappingsLoaded = false;
        this.optionsLoaded = false;
        this.getOptions().clear();
        if (this.remoteServer != null && (remoteDB = (ICatalogObject)((LUWCatalogRelationalRemoteServer)this.remoteServer).getDatabase()) != null) {
            remoteDB.refresh();
        }
        this.remoteServerLoaded = false;
        this.remoteServer = null;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getLUWDatabase();
    }

    public EList getNicknames() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getNicknames();
        }
        if (!this.nicknamesLoaded) {
            this.loadNicknames();
        }
        return super.getNicknames();
    }

    public EList getOptions() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getOptions();
        }
        if (!this.optionsLoaded) {
            this.loadOptions();
        }
        return super.getOptions();
    }

    public RemoteServer getRemoteServer() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getRemoteServer();
        }
        if (!this.remoteServerLoaded) {
            this.loadRemoteServer();
        }
        return super.getRemoteServer();
    }

    public LUWWrapper getWrapper() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getWrapper();
        }
        if (!this.wrapperLoaded) {
            this.loadWrapper();
        }
        return super.getWrapper();
    }

    public EList getUserMappings() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getUserMappings();
        }
        if (!this.userMappingsLoaded) {
            this.loadUserMappings();
        }
        return super.getUserMappings();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        return new ArrayList();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 18) {
            this.getNicknames();
        } else if (id == 14) {
            this.getOptions();
        } else if (id == 15) {
            this.getRemoteServer();
        } else if (id == 10) {
            this.getUserMappings();
        } else if (id == 11) {
            this.getWrapper();
        } else if (id == 12) {
            this.getNicknames();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadNicknames() {
        if (this.nicknamesLoaded) {
            return;
        }
        this.nicknamesLoaded = true;
        Connection connection = this.getConnection();
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getCatalogDatabase());
        ConnectionFilter filter = connectionInfo.getFilter(String.valueOf(this.name) + "::" + "DatatoolsNicknameFilterPredicate");
        String filterStr = "";
        if (filter != null) {
            filterStr = String.valueOf(filterStr) + CatalogLoadUtil.getFilterString((String)filter.getPredicate(), (String)"TABNAME");
        }
        filterStr = filterStr.length() > 0 ? " AND (" + filterStr + ")" : "";
        String query = "SELECT TABSCHEMA, TABNAME FROM SYSCAT.TABOPTIONS WHERE OPTION='SERVER' AND CAST(SUBSTR(SETTING, 1, 128) AS VARCHAR(128))='" + this.getName() + "'" + filterStr;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            try {
                while (r.next()) {
                    String tabSchema = r.getString(1).trim();
                    String tabName = r.getString(2).trim();
                    LUWCatalogFederatedServer.getNickName(tabSchema, tabName, this).getServer();
                }
            }
            catch (Exception exception) {}
            r.close();
            s.close();
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    private synchronized void loadRemoteServer() {
        if (this.remoteServerLoaded) {
            return;
        }
        LUWCatalogRelationalRemoteServer remoteServer = new LUWCatalogRelationalRemoteServer();
        remoteServer.setName(this.getName());
        remoteServer.setLUWServer(this);
        this.remoteServerLoaded = true;
    }

    private synchronized void loadOptions() {
        if (this.optionsLoaded) {
            return;
        }
        EList options = super.getOptions();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT OPTION, SETTING, REMARKS FROM SYSCAT.SERVEROPTIONS WHERE SERVERNAME='" + LUWUtil.getIdentifier(this.getName()) + "'";
            Statement s = this.getConnection().createStatement();
            ResultSet r = s.executeQuery(query);
            try {
                while (r.next()) {
                    String name = r.getString(1);
                    String value = r.getString(2);
                    String remarks = r.getString(3);
                    LUWOption option = LUWFactory.eINSTANCE.createLUWOption();
                    option.setName(name);
                    option.setValue(value);
                    option.setDescription(remarks);
                    options.add((Object)option);
                }
            }
            catch (Exception exception) {}
            r.close();
            s.close();
        }
        catch (Exception exception) {}
        this.optionsLoaded = true;
        this.eSetDeliver(deliver);
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogFederatedServer.getImpacteNicknames(connection, this));
        impacts.addAll(LUWCatalogFederatedServer.getImpacteFederatedProcedure(connection, this));
        return impacts;
    }

    protected static Collection getImpacteNicknames(Connection connection, LUWGenericServer remoteServer) {
        ArrayList impacts = new ArrayList();
        impacts.addAll(remoteServer.getNicknames());
        return impacts;
    }

    protected static Collection getImpacteFederatedProcedure(Connection connection, LUWGenericServer remoteServer) {
        ArrayList<FederatedProcedure> impacts = new ArrayList<FederatedProcedure>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT ROUTINENAME, ROUTINESCHEMA  FROM SYSCAT.ROUTINESFEDERATED  WHERE ROUTINETYPE='P' AND SERVERNAME='" + LUWUtil.getIdentifier(remoteServer.getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String routinName = r.getString("ROUTINENAME").trim();
                String schemaName = r.getString("ROUTINESCHEMA").trim();
                FederatedProcedure proc = LUWCatalogFederatedServer.getFederatedProcedure(schemaName, routinName, remoteServer);
                if (r == null) continue;
                impacts.add(proc);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    private static LUWNickname getNickName(String schema, String table, LUWGenericServer server) {
        Schema s = LUWCatalogFederatedServer.getSchema(schema, server);
        for (Table t : s.getTables()) {
            if (!t.getName().equals(table)) continue;
            return (LUWCatalogNickname)t;
        }
        LUWCatalogNickname nickName = new LUWCatalogNickname();
        nickName.setName(table);
        nickName.setSchema(s);
        return nickName;
    }

    private static Schema getSchema(String schemaName, LUWGenericServer server) {
        LUWDatabase d = server.getLUWDatabase();
        for (Schema s : d.getSchemas()) {
            if (!s.getName().equals(schemaName)) continue;
            return s;
        }
        LUWCatalogSchema schema = new LUWCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase((Database)d);
        return schema;
    }

    private static FederatedProcedure getFederatedProcedure(String schema, String federatedproc, LUWGenericServer server) {
        Schema s = LUWCatalogFederatedServer.getSchema(schema, server);
        for (Routine r : s.getRoutines()) {
            if (!(r instanceof FederatedProcedure) || !r.getName().equals(federatedproc) || !((FederatedProcedure)r).getRemoteServer().equals(server.getName())) continue;
            return (FederatedProcedure)r;
        }
        return null;
    }

    private synchronized void loadWrapper() {
        if (this.wrapperLoaded) {
            return;
        }
        this.wrapperLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            for (LUWWrapper m_wrapper : this.getLUWDatabase().getWrappers()) {
                if (!m_wrapper.getName().equalsIgnoreCase(this.wrapperName)) continue;
                this.setWrapper(m_wrapper);
                break;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadUserMappings() {
        if (this.userMappingsLoaded) {
            return;
        }
        EList userMappings = super.getUserMappings();
        userMappings.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT DISTINCT AUTHID FROM SYSCAT.USEROPTIONS WHERE SERVERNAME='" + LUWUtil.getIdentifier(this.getName()) + "'";
            Statement s = this.getConnection().createStatement();
            ResultSet r = s.executeQuery(query);
            try {
                while (r.next()) {
                    String localAuthId = r.getString("AUTHID");
                    LUWCatalogUserMapping userMapping = new LUWCatalogUserMapping();
                    userMapping.setLocalAuthId(localAuthId);
                    userMapping.setName(localAuthId);
                    userMappings.add((Object)userMapping);
                }
            }
            catch (Exception exception) {}
            r.close();
            s.close();
        }
        catch (Exception exception) {}
        this.userMappingsLoaded = true;
        this.eSetDeliver(deliver);
    }

    public String getWrapperName() {
        return this.wrapperName;
    }

    public void setWrapperName(String wrapperName) {
        this.wrapperName = wrapperName;
    }
}

