/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageTypeRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOPackageUnitImpl
implements InternalCDOPackageUnit {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOPackageUnitImpl.class);
    private InternalCDOPackageRegistry packageRegistry;
    private CDOPackageUnit.State state = CDOPackageUnit.State.PROXY;
    private CDOPackageUnit.Type type;
    private CDOPackageUnit.Type originalType;
    private long timeStamp;
    private InternalCDOPackageInfo[] packageInfos;

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    @Override
    public void setPackageRegistry(InternalCDOPackageRegistry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    @Override
    public String getID() {
        try {
            return this.getTopLevelPackageInfo().getPackageURI();
        }
        catch (RuntimeException ex) {
            return Messages.getString("CDOPackageUnitImpl.0");
        }
    }

    @Override
    public CDOPackageUnit.State getState() {
        return this.state;
    }

    @Override
    public void setState(CDOPackageUnit.State state) {
        this.state = state;
        if (state == CDOPackageUnit.State.LOADED) {
            this.type = null;
        }
    }

    @Override
    public CDOPackageUnit.Type getType() {
        if (this.getOriginalType() == CDOPackageUnit.Type.DYNAMIC) {
            this.type = CDOPackageUnit.Type.DYNAMIC;
        } else if (this.type == null || this.type == CDOPackageUnit.Type.UNKNOWN) {
            if (this.state == CDOPackageUnit.State.PROXY) {
                this.type = CDOPackageTypeRegistry.INSTANCE.lookup(this.getID());
            } else {
                InternalCDOPackageInfo packageInfo = this.getTopLevelPackageInfo();
                EPackage ePackage = packageInfo.getEPackage();
                this.type = CDOPackageTypeRegistry.INSTANCE.lookup(ePackage);
            }
            if (this.type == null) {
                this.type = CDOPackageUnit.Type.UNKNOWN;
            }
        }
        return this.type;
    }

    @Override
    public CDOPackageUnit.Type getOriginalType() {
        return this.originalType;
    }

    @Override
    public void setOriginalType(CDOPackageUnit.Type originalType) {
        this.originalType = originalType;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public InternalCDOPackageInfo getTopLevelPackageInfo() {
        if (this.packageInfos == null || this.packageInfos.length == 0) {
            throw new IllegalStateException(Messages.getString("CDOPackageUnitImpl.1"));
        }
        return this.packageInfos[0];
    }

    @Override
    public InternalCDOPackageInfo getPackageInfo(String packageURI) {
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = this.packageInfos;
        int n = this.packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            if (packageInfo.getPackageURI().equals(packageURI)) {
                return packageInfo;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public InternalCDOPackageInfo[] getPackageInfos() {
        return this.packageInfos;
    }

    @Override
    public void setPackageInfos(InternalCDOPackageInfo[] packageInfos) {
        this.packageInfos = packageInfos;
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageInfos;
        int n = packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            packageInfo.setPackageUnit(this);
            ++n2;
        }
    }

    @Override
    public EPackage[] getEPackages(boolean loadOnDemand) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = this.packageInfos;
        int n = this.packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            EPackage ePackage = packageInfo.getEPackage(loadOnDemand);
            if (ePackage != null) {
                result.add(ePackage);
            }
            ++n2;
        }
        return result.toArray(new EPackage[result.size()]);
    }

    @Override
    public boolean isSystem() {
        return this.getTopLevelPackageInfo().isSystemPackage();
    }

    @Override
    public boolean isResource() {
        return this.getTopLevelPackageInfo().isResourcePackage();
    }

    @Override
    public void init(EPackage ePackage) {
        EPackage topLevelPackage = EMFUtil.getTopLevelPackage(ePackage);
        ArrayList<InternalCDOPackageInfo> result = new ArrayList<InternalCDOPackageInfo>();
        this.initPackageInfos(topLevelPackage, result);
        this.packageInfos = result.toArray(new InternalCDOPackageInfo[result.size()]);
        this.setState(CDOPackageUnit.State.NEW);
        this.setOriginalType(this.getType());
    }

    @Override
    public void dispose() {
        this.packageInfos = null;
        this.setState(CDOPackageUnit.State.DISPOSED);
    }

    @Override
    public synchronized void load(boolean resolve) {
        InternalCDOPackageRegistry.PackageLoader packageLoader = this.packageRegistry.getPackageLoader();
        this.load(packageLoader, resolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void load(InternalCDOPackageRegistry.PackageLoader packageLoader, boolean resolve) {
        if (this.state == CDOPackageUnit.State.PROXY) {
            EPackage[] ePackages = null;
            ePackages = this.loadPackagesFromGlobalRegistry();
            if (ePackages == null) {
                ePackages = packageLoader.loadPackages(this);
            }
            EPackage[] ePackageArray = ePackages;
            int n = ePackages.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage ePackage = ePackageArray[n2];
                String packageURI = ePackage.getNsURI();
                InternalCDOPackageInfo packageInfo = this.getPackageInfo(packageURI);
                this.packageRegistry.registerPackageInfo(ePackage, packageInfo);
                if (resolve) {
                    EPackage ePackage2 = ePackage;
                    synchronized (ePackage2) {
                        EcoreUtil.resolveAll((EObject)ePackage);
                    }
                }
                ++n2;
            }
            this.setState(CDOPackageUnit.State.LOADED);
        }
    }

    @Override
    public void write(CDODataOutput out, boolean withPackages) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0}", new Object[]{this});
        }
        out.writeBoolean(withPackages);
        if (withPackages) {
            CDOModelUtil.writePackage(out, this.packageInfos[0].getEPackage(), true, this.packageRegistry);
        }
        out.writeCDOPackageUnitType(this.originalType);
        out.writeLong(this.timeStamp);
        out.writeInt(this.packageInfos.length);
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = this.packageInfos;
        int n = this.packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            out.writeCDOPackageInfo(packageInfo);
            ++n2;
        }
    }

    @Override
    public void read(CDODataInput in, ResourceSet resourceSet) throws IOException {
        if (this.packageRegistry == null) {
            EPackage.Registry resourceSetPackageRegistry;
            this.packageRegistry = (InternalCDOPackageRegistry)in.getPackageRegistry();
            if (this.packageRegistry == null && (resourceSetPackageRegistry = resourceSet.getPackageRegistry()) instanceof InternalCDOPackageRegistry) {
                this.packageRegistry = (InternalCDOPackageRegistry)resourceSetPackageRegistry;
            }
        }
        EPackage ePackage = null;
        boolean withPackages = in.readBoolean();
        if (withPackages) {
            CheckUtil.checkArg((Object)resourceSet, (String)"resourceSet");
            ePackage = CDOModelUtil.readPackage(in, resourceSet, true);
            EPackage globalPackage = this.loadPackageFromGlobalRegistry(ePackage.getNsURI());
            if (globalPackage != null) {
                ePackage = globalPackage;
            }
            this.setState(CDOPackageUnit.State.LOADED);
        }
        this.originalType = in.readCDOPackageUnitType();
        this.timeStamp = in.readLong();
        this.packageInfos = new InternalCDOPackageInfo[in.readInt()];
        int i = 0;
        while (i < this.packageInfos.length) {
            this.packageInfos[i] = (InternalCDOPackageInfo)in.readCDOPackageInfo();
            this.packageInfos[i].setPackageUnit(this);
            ++i;
        }
        if (ePackage != null) {
            this.attachPackageInfos(ePackage);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Read {0}", new Object[]{this});
        }
    }

    @Override
    public int compareTo(CDOPackageUnit o) {
        return this.getID().compareTo(o.getID());
    }

    public String toString() {
        String fmt = "CDOPackageUnit[id={0}, state={1}, type={2}, originalType={3}, timeStamp={4}]";
        return MessageFormat.format(fmt, new Object[]{this.getID(), this.getState(), this.getType(), this.getOriginalType(), CDOCommonUtil.formatTimeStamp(this.getTimeStamp())});
    }

    private void initPackageInfos(EPackage ePackage, List<InternalCDOPackageInfo> result) {
        InternalCDOPackageInfo packageInfo = (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
        packageInfo.setPackageUnit(this);
        packageInfo.setPackageURI(ePackage.getNsURI());
        packageInfo.setParentURI(ePackage.getESuperPackage() == null ? null : ePackage.getESuperPackage().getNsURI());
        this.packageRegistry.basicPut(ePackage.getNsURI(), ePackage);
        this.packageRegistry.registerPackageInfo(ePackage, packageInfo);
        result.add(packageInfo);
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.initPackageInfos(subPackage, result);
        }
    }

    private void attachPackageInfos(EPackage ePackage) {
        InternalCDOPackageInfo packageInfo = this.getPackageInfo(ePackage.getNsURI());
        if (packageInfo != null) {
            this.packageRegistry.registerPackageInfo(ePackage, packageInfo);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.attachPackageInfos(subPackage);
        }
    }

    private EPackage[] loadPackagesFromGlobalRegistry() {
        EPackage[] ePackages = new EPackage[this.packageInfos.length];
        int i = 0;
        while (i < ePackages.length) {
            ePackages[i] = this.loadPackageFromGlobalRegistry(this.packageInfos[i].getPackageURI());
            if (ePackages[i] == null) {
                return null;
            }
            ++i;
        }
        return ePackages;
    }

    private EPackage loadPackageFromGlobalRegistry(String packageURI) {
        return EPackage.Registry.INSTANCE.getEPackage(packageURI);
    }
}

