/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.branch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchManagerImpl;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchPointImpl;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchPointRangeImpl;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOBranchUtil {
    private CDOBranchUtil() {
    }

    public static InternalCDOBranchManager createBranchManager() {
        return new CDOBranchManagerImpl();
    }

    public static CDOBranchPointRange createRange(CDOBranchPoint startPoint, CDOBranchPoint endPoint) {
        return new CDOBranchPointRangeImpl(startPoint, endPoint);
    }

    public static CDOBranchPoint copyBranchPoint(CDOBranchPoint source) {
        if (source instanceof CDOBranchPointImpl) {
            return source;
        }
        return source.getBranch().getPoint(source.getTimeStamp());
    }

    public static CDOBranchVersion copyBranchVersion(CDOBranchVersion source) {
        return source.getBranch().getVersion(source.getVersion());
    }

    public static CDOBranchPoint normalizeBranchPoint(CDOBranch branch, long timeStamp) {
        long baseTime;
        while (timeStamp < (baseTime = branch.getBase().getTimeStamp())) {
            if ((branch = branch.getBase().getBranch()) != null) continue;
            throw new IllegalArgumentException("Time " + CDOCommonUtil.formatTimeStamp(timeStamp) + " is before the repository creation time " + CDOCommonUtil.formatTimeStamp(baseTime));
        }
        return branch.getPoint(timeStamp);
    }

    public static boolean isContainedBy(CDOBranchPoint contained, CDOBranchPoint container) {
        CDOBranch containerBranch = container.getBranch();
        if (containerBranch == contained.getBranch()) {
            return CDOCommonUtil.compareTimeStamps(contained.getTimeStamp(), container.getTimeStamp()) <= 0;
        }
        if (containerBranch == null) {
            return false;
        }
        return CDOBranchUtil.isContainedBy(contained, containerBranch.getBase());
    }

    public static CDOBranchPoint getAncestor(CDOBranchPoint point1, CDOBranchPoint point2) {
        if (point1.getBranch() == null) {
            return point1;
        }
        if (point2.getBranch() == null) {
            return point2;
        }
        CDOBranchPoint[] path1 = CDOBranchUtil.getPath(point1);
        CDOBranchPoint[] path2 = CDOBranchUtil.getPath(point2);
        CDOBranchPoint[] cDOBranchPointArray = path1;
        int n = path1.length;
        int n2 = 0;
        while (n2 < n) {
            CDOBranchPoint pathPoint1 = cDOBranchPointArray[n2];
            CDOBranchPoint[] cDOBranchPointArray2 = path2;
            int n3 = path2.length;
            int n4 = 0;
            while (n4 < n3) {
                CDOBranchPoint pathPoint2 = cDOBranchPointArray2[n4];
                if (pathPoint1.getBranch() == pathPoint2.getBranch()) {
                    if (CDOCommonUtil.compareTimeStamps(pathPoint1.getTimeStamp(), pathPoint2.getTimeStamp()) < 0) {
                        return pathPoint1;
                    }
                    return pathPoint2;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static CDOBranchPoint[] getPath(CDOBranchPoint point) {
        ArrayList<CDOBranchPoint> result = new ArrayList<CDOBranchPoint>();
        CDOBranchUtil.getPath(point, result);
        return result.toArray(new CDOBranchPoint[result.size()]);
    }

    private static void getPath(CDOBranchPoint point, List<CDOBranchPoint> result) {
        CDOBranch branch = point.getBranch();
        if (branch != null) {
            result.add(point);
            CDOBranchUtil.getPath(branch.getBase(), result);
        }
    }
}

