/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.views;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.internal.ui.actions.OpenSessionAction;
import org.eclipse.emf.cdo.internal.ui.actions.OpenTransactionAction;
import org.eclipse.emf.cdo.internal.ui.transfer.RepositoryTransferDragListener;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transfer.ui.TransferDropAdapter;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOSessionsView
extends ContainerView {
    public static final String ID = "org.eclipse.emf.cdo.ui.CDOSessionsView";
    private static Map<String, ResourceOpener> resourceOpeners = Collections.synchronizedMap(new HashMap());
    private OpenSessionAction openSessionAction;

    protected Control createUI(Composite parent) {
        this.openSessionAction = new OpenSessionAction(this.getViewSite().getPage());
        Control control = super.createUI(parent);
        TreeViewer viewer = this.getViewer();
        RepositoryTransferDragListener.support((StructuredViewer)viewer);
        TransferDropAdapter.support((StructuredViewer)viewer);
        return control;
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new CDOItemProvider(this.getSite().getPage(), new IElementFilter(){

            public boolean filter(Object element) {
                return element instanceof CDOSession;
            }
        });
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.openSessionAction);
        super.fillLocalToolBar(manager);
    }

    protected void doubleClicked(Object object) {
        CDOSession session;
        IWorkbenchPage page = this.getSite().getPage();
        if (object instanceof CDOSession && (session = (CDOSession)object).getViews().length == 0) {
            OpenTransactionAction.openTransaction(session);
            return;
        }
        if (object instanceof CDOResourceLeaf) {
            CDOResourceLeaf resource = (CDOResourceLeaf)object;
            String name = resource.getName();
            String extension = new Path(name).getFileExtension();
            ResourceOpener opener = resourceOpeners.get(extension);
            if (opener != null) {
                opener.openResource(page, resource);
            } else {
                CDOEditorUtil.openEditor(page, resource);
            }
            return;
        }
        super.doubleClicked(object);
    }

    public static ResourceOpener registerResourceOpener(String resourceExtension, ResourceOpener opener) {
        return resourceOpeners.put(resourceExtension, opener);
    }

    public static ResourceOpener unregisterResourceOpener(String resourceExtension) {
        return resourceOpeners.remove(resourceExtension);
    }

    public static interface ResourceOpener {
        public void openResource(IWorkbenchPage var1, CDOResourceLeaf var2);
    }
}

