/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.interpreter;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xcore.XEnumLiteral;
import org.eclipse.emf.ecore.xcore.XNamedElement;
import org.eclipse.emf.ecore.xcore.XOperation;
import org.eclipse.emf.ecore.xcore.XStructuralFeature;
import org.eclipse.emf.ecore.xcore.mappings.ToXcoreMapping;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.interpreter.impl.EvaluationException;
import org.eclipse.xtext.xbase.interpreter.impl.XbaseInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcoreInterpreter
extends XbaseInterpreter {
    @Inject
    private XcoreMapper mapper;

    protected Object invokeOperation(JvmOperation operation, Object receiver, List<Object> argumentValues) {
        ToXcoreMapping mapping;
        if (receiver instanceof EObject && (mapping = this.mapper.getToXcoreMapping((EObject)operation)) != null) {
            XNamedElement element = mapping.getXcoreElement();
            if (element instanceof XOperation) {
                EOperation op = this.mapper.getMapping((XOperation)element).getEOperation();
                try {
                    return ((EObject)receiver).eInvoke(op, (EList)new BasicEList(argumentValues));
                }
                catch (InvocationTargetException e) {
                    throw new EvaluationException((Throwable)e);
                }
            }
            if (element instanceof XStructuralFeature) {
                EStructuralFeature feature = this.mapper.getMapping((XStructuralFeature)element).getEStructuralFeature();
                String accessorName = operation.getSimpleName();
                if (accessorName.startsWith("get")) {
                    try {
                        return ((EObject)receiver).eGet(feature);
                    }
                    catch (Throwable e) {
                        throw new EvaluationException(e);
                    }
                }
                if (accessorName.startsWith("set")) {
                    try {
                        ((EObject)receiver).eSet(feature, argumentValues.get(0));
                        return null;
                    }
                    catch (Throwable e) {
                        throw new EvaluationException(e);
                    }
                }
            }
        }
        return super.invokeOperation(operation, receiver, argumentValues);
    }

    protected Object featureCallField(JvmField jvmField, Object receiver) {
        EEnumLiteral literal;
        ToXcoreMapping mapping = this.mapper.getToXcoreMapping((EObject)jvmField);
        XNamedElement xcoreElement = mapping.getXcoreElement();
        if (xcoreElement instanceof XEnumLiteral && (literal = this.mapper.getMapping((XEnumLiteral)xcoreElement).getEEnumLiteral()) != null) {
            return literal;
        }
        return super.featureCallField(jvmField, receiver);
    }
}

