/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.scoping;

import com.google.inject.Inject;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenTypeParameter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xcore.XNamedElement;
import org.eclipse.emf.ecore.xcore.mappings.ToXcoreMapping;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

public class XcoreQualifiedNameProvider
extends DefaultDeclarativeQualifiedNameProvider {
    @Inject
    private IQualifiedNameConverter nameConverter;
    @Inject
    private XcoreMapper xcoreMapper;

    public QualifiedName getFullyQualifiedName(EObject eObject) {
        if (eObject instanceof GenClassifier) {
            GenClassifier genClassifier = (GenClassifier)eObject;
            GenPackage genPackage = genClassifier.getGenPackage();
            if (genPackage != null) {
                String packageName = genPackage.getQualifiedPackageName();
                return this.nameConverter.toQualifiedName(String.valueOf(packageName) + "." + genClassifier.getName());
            }
            return null;
        }
        if (eObject instanceof GenTypeParameter) {
            String name = ((GenTypeParameter)eObject).getName();
            return name == null ? null : this.nameConverter.toQualifiedName(name);
        }
        if (eObject instanceof JvmConstructor) {
            JvmConstructor constructor = (JvmConstructor)eObject;
            String typeName = constructor.getQualifiedName();
            return typeName == null ? null : this.nameConverter.toQualifiedName(typeName);
        }
        if (eObject instanceof JvmType && !(eObject instanceof JvmTypeParameter)) {
            JvmType type = (JvmType)eObject;
            String typeName = type.getQualifiedName();
            return typeName == null ? null : this.nameConverter.toQualifiedName(typeName);
        }
        if (eObject instanceof EPackage) {
            ToXcoreMapping toXcoreMapping = this.xcoreMapper.getToXcoreMapping(eObject);
            XNamedElement xNamedElement = toXcoreMapping.getXcoreElement();
            if (xNamedElement != null) {
                String packageName = xNamedElement.getName();
                return packageName == null ? null : QualifiedName.create((String)packageName);
            }
            return null;
        }
        return super.getFullyQualifiedName(eObject);
    }
}

