/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.scoping;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.GenTypeParameter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.xcore.XClass;
import org.eclipse.emf.ecore.xcore.XDataType;
import org.eclipse.emf.ecore.xcore.XGenericType;
import org.eclipse.emf.ecore.xcore.XOperation;
import org.eclipse.emf.ecore.xcore.XReference;
import org.eclipse.emf.ecore.xcore.XcorePackage;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;
import org.eclipse.xtext.xbase.annotations.typesystem.XbaseWithAnnotationsBatchScopeProvider;

public class XcoreScopeProvider
extends XbaseWithAnnotationsBatchScopeProvider {
    @Inject
    protected XcoreMapper mapper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public IScope getScope(EObject context, EReference reference) {
        if (reference == XcorePackage.Literals.XREFERENCE__OPPOSITE) {
            return new OppositeScope(this.qualifiedNameConverter, IScope.NULLSCOPE, false, context);
        }
        if (reference == XcorePackage.Literals.XREFERENCE__KEYS) {
            return new KeyScope(this.mapper, this.qualifiedNameConverter, IScope.NULLSCOPE, false, context);
        }
        IScope scope = super.getScope(context, reference);
        return reference == XcorePackage.Literals.XGENERIC_TYPE__TYPE ? new TypeParameterScope(this.mapper, this.qualifiedNameConverter, scope, false, context) : scope;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyScope
    extends AbstractScope {
        private final XcoreMapper mapper;
        private final IQualifiedNameConverter qualifiedNameConverter;
        private final EObject context;

        public KeyScope(XcoreMapper mapper, IQualifiedNameConverter qualifiedNameConverter, IScope parent, boolean ignoreCase, EObject context) {
            super(parent, ignoreCase);
            this.mapper = mapper;
            this.qualifiedNameConverter = qualifiedNameConverter;
            this.context = context;
        }

        protected Iterable<IEObjectDescription> getAllLocalElements() {
            GenClass genClass;
            XReference ref;
            GenFeature genFeature;
            ArrayList<IEObjectDescription> result = new ArrayList<IEObjectDescription>();
            if (this.context instanceof XReference && (genFeature = this.mapper.getMapping(ref = (XReference)this.context).getGenFeature()) != null && (genClass = genFeature.getTypeGenClass()) != null) {
                for (GenFeature key : genClass.getAllGenFeatures()) {
                    String name;
                    if (key.isReferenceType() || (name = key.getName()) == null) continue;
                    result.add((IEObjectDescription)new EObjectDescription(this.qualifiedNameConverter.toQualifiedName(name), (EObject)key, null));
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OppositeScope
    extends AbstractScope {
        private final IQualifiedNameConverter qualifiedNameConverter;
        private final EObject context;

        public OppositeScope(IQualifiedNameConverter qualifiedNameConverter, IScope parent, boolean ignoreCase, EObject context) {
            super(parent, ignoreCase);
            this.qualifiedNameConverter = qualifiedNameConverter;
            this.context = context;
        }

        protected Iterable<IEObjectDescription> getAllLocalElements() {
            XReference xReference;
            XGenericType type;
            ArrayList<IEObjectDescription> result = new ArrayList<IEObjectDescription>();
            if (this.context instanceof XReference && (type = (xReference = (XReference)this.context).getType()) != null) {
                GenBase genType = type.getType();
                if (genType instanceof GenTypeParameter) {
                    GenTypeParameter genTypeParameter = (GenTypeParameter)genType;
                    ETypeParameter eTypeParameter = genTypeParameter.getEcoreTypeParameter();
                    for (EGenericType eGenericType : eTypeParameter.getEBounds()) {
                        EClassifier eRawType = eGenericType.getERawType();
                        if (!(eRawType instanceof EClass)) continue;
                        genType = genType.getGenModel().findGenClassifier(eRawType);
                        break;
                    }
                }
                if (genType instanceof GenClass) {
                    GenClass genClass = (GenClass)genType;
                    for (GenFeature opposite : genClass.getGenFeatures()) {
                        String name;
                        if (!opposite.isReferenceType() || (name = opposite.getName()) == null) continue;
                        result.add((IEObjectDescription)new EObjectDescription(this.qualifiedNameConverter.toQualifiedName(name), (EObject)opposite, null));
                    }
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeParameterScope
    extends AbstractScope {
        private final XcoreMapper mapper;
        private final IQualifiedNameConverter qualifiedNameConverter;
        private final EObject context;

        public TypeParameterScope(XcoreMapper mapper, IQualifiedNameConverter qualifiedNameConverter, IScope parent, boolean ignoreCase, EObject context) {
            super(parent, ignoreCase);
            this.mapper = mapper;
            this.qualifiedNameConverter = qualifiedNameConverter;
            this.context = context;
        }

        void handleGenTypeParameters(List<IEObjectDescription> result, EList<GenTypeParameter> genTypeParameters) {
            for (GenTypeParameter genTypeParameter : genTypeParameters) {
                result.add((IEObjectDescription)new EObjectDescription(this.qualifiedNameConverter.toQualifiedName(genTypeParameter.getName()), (EObject)genTypeParameter, null));
            }
        }

        protected Iterable<IEObjectDescription> getAllLocalElements() {
            ArrayList<IEObjectDescription> result = new ArrayList<IEObjectDescription>();
            EObject eObject = this.context;
            while (eObject != null) {
                if (eObject instanceof XOperation) {
                    GenOperation genOperation = this.mapper.getMapping((XOperation)eObject).getGenOperation();
                    if (genOperation != null) {
                        this.handleGenTypeParameters(result, (EList<GenTypeParameter>)genOperation.getGenTypeParameters());
                    }
                } else {
                    GenClass genClassifier;
                    if (eObject instanceof XClass) {
                        genClassifier = this.mapper.getMapping((XClass)eObject).getGenClass();
                        if (genClassifier == null) break;
                        this.handleGenTypeParameters(result, (EList<GenTypeParameter>)genClassifier.getGenTypeParameters());
                        break;
                    }
                    if (eObject instanceof XDataType) {
                        genClassifier = this.mapper.getMapping((XDataType)eObject).getGenDataType();
                        if (genClassifier == null) break;
                        this.handleGenTypeParameters(result, (EList<GenTypeParameter>)genClassifier.getGenTypeParameters());
                        break;
                    }
                }
                eObject = eObject.eContainer();
            }
            return result;
        }
    }
}

