/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.editor.handler;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.editor.controls.Activator;
import org.eclipse.emf.ecp.view.editor.controls.Helper;
import org.eclipse.emf.ecp.view.editor.handler.ControlGenerator;
import org.eclipse.emf.ecp.view.editor.handler.SelectAttributesDialog;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.model.VContainer;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.internal.MasterDetailAction;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateControlsHandler
extends MasterDetailAction {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selection = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).getFirstElement();
        if (selection == null || !(selection instanceof EObject)) {
            return null;
        }
        VView obj = this.getView((EObject)selection);
        if (obj == null) {
            return null;
        }
        VView view = obj;
        final EClass rootClass = Helper.getRootEClass((EObject)selection);
        SelectAttributesDialog sad = new SelectAttributesDialog(view, rootClass, HandlerUtil.getActiveShell((ExecutionEvent)event));
        int result = sad.open();
        if (result == 0) {
            final Set<EStructuralFeature> featuresToAdd = this.getFeaturesToCreate(sad);
            final VElement compositeCollection = (VElement)selection;
            AdapterFactoryEditingDomain.getEditingDomainFor((EObject)compositeCollection).getCommandStack().execute((Command)new ChangeCommand((Notifier)compositeCollection){

                protected void doExecute() {
                    ControlGenerator.addControls(rootClass, compositeCollection, featuresToAdd);
                }
            });
        }
        return null;
    }

    private Set<EStructuralFeature> getFeaturesToCreate(SelectAttributesDialog sad) {
        Set<EStructuralFeature> features = sad.getSelectedFeatures();
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        LinkedHashSet<EStructuralFeature> featuresToAdd = new LinkedHashSet<EStructuralFeature>();
        IItemPropertyDescriptor propertyDescriptor = null;
        for (EStructuralFeature feature : features) {
            propertyDescriptor = adapterFactoryItemDelegator.getPropertyDescriptor((Object)EcoreUtil.create((EClass)sad.getRootClass()), (Object)feature);
            if (propertyDescriptor != null) {
                featuresToAdd.add(feature);
                continue;
            }
            this.logInvalidFeature(feature.getName(), sad.getRootClass().getName());
        }
        composedAdapterFactory.dispose();
        return featuresToAdd;
    }

    private void logInvalidFeature(String featureName, String eClassName) {
        String infoMessage = "Feature " + featureName + " of the class " + eClassName + "could not be rendered because it has no property descriptor.";
        ILog log = Activator.getDefault().getLog();
        log.log((IStatus)new Status(1, "org.eclipse.emf.ecp.view.editor.controls", infoMessage));
    }

    public void execute(EObject object) {
        if (!VView.class.isInstance(object) && !VContainer.class.isInstance(object)) {
            return;
        }
        VView obj = this.getView(object);
        if (obj == null) {
            return;
        }
        VView view = obj;
        final EClass rootEClass = view.getRootEClass();
        final VElement container = this.getContainer(object);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SelectAttributesDialog sad = new SelectAttributesDialog(view, rootEClass, shell);
        int result = sad.open();
        if (result == 0) {
            final Set<EStructuralFeature> featuresToAdd = this.getFeaturesToCreate(sad);
            AdapterFactoryEditingDomain.getEditingDomainFor((EObject)view).getCommandStack().execute((Command)new ChangeCommand((Notifier)view){

                protected void doExecute() {
                    ControlGenerator.addControls(rootEClass, container, featuresToAdd);
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private VView getView(EObject object) {
        if (object != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            if ((object = object.eContainer()) != null) continue;
            return null;
lbl5:
            // 2 sources

            ** while (!(object instanceof VView))
        }
lbl6:
        // 1 sources

        return (VView)object;
    }

    /*
     * Unable to fully structure code
     */
    private VElement getContainer(EObject object) {
        if (object != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            if ((object = object.eContainer()) != null) continue;
            return null;
lbl5:
            // 2 sources

            ** while (!(object instanceof VView) && !(object instanceof VContainer))
        }
lbl6:
        // 1 sources

        return (VElement)object;
    }

    public boolean shouldShow(EObject object) {
        if (object == null) {
            return false;
        }
        return object instanceof VView || object instanceof VContainer;
    }
}

