/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ControlMessages;
import org.eclipse.emf.ecp.edit.internal.swt.controls.NumericalHelper;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.edit.spi.ViewLocaleService;
import org.eclipse.emf.ecp.view.internal.core.swt.renderer.TextControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NumberControlSWTRenderer
extends TextControlSWTRenderer {
    public NumberControlSWTRenderer() {
    }

    NumberControlSWTRenderer(SWTRendererFactory factory) {
        super(factory);
    }

    @Override
    protected int getDefaultAlignment() {
        return 131072;
    }

    @Override
    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_numerical";
    }

    @Override
    protected String getTextMessage(EStructuralFeature.Setting setting) {
        if (NumericalHelper.isInteger(this.getInstanceClass(setting.getEStructuralFeature()))) {
            return ControlMessages.NumericalControl_FormatNumerical;
        }
        if (NumericalHelper.isDouble(this.getInstanceClass(setting.getEStructuralFeature()))) {
            return ControlMessages.NumericalControl_FormatNumericalDecimal;
        }
        return "";
    }

    @Override
    protected Binding[] createBindings(Control control, EStructuralFeature.Setting setting) {
        NumericalTargetToModelUpdateStrategy targetToModelStrategy = new NumericalTargetToModelUpdateStrategy(setting.getEStructuralFeature(), this.getViewModelContext(), this.getModelValue(setting), this.getDataBindingContext(), (Text)control);
        NumericalModelToTargetUpdateStrategy modelToTargetStrategy = new NumericalModelToTargetUpdateStrategy(this.getInstanceClass(setting.getEStructuralFeature()), this.getViewModelContext(), false);
        Binding binding = this.bindValue(control, this.getModelValue(setting), this.getDataBindingContext(), (UpdateValueStrategy)targetToModelStrategy, (UpdateValueStrategy)modelToTargetStrategy);
        Binding tooltipBinding = this.createTooltipBinding(control, this.getModelValue(setting), this.getDataBindingContext(), (UpdateValueStrategy)targetToModelStrategy, (UpdateValueStrategy)new NumericalModelToTargetUpdateStrategy(this.getInstanceClass(setting.getEStructuralFeature()), this.getViewModelContext(), true));
        return new Binding[]{binding, tooltipBinding};
    }

    private Class<?> getInstanceClass(EStructuralFeature feature) {
        return feature.getEType().getInstanceClass();
    }

    private Locale getLocale(ViewModelContext viewModelContext) {
        ViewLocaleService service = (ViewLocaleService)viewModelContext.getService(ViewLocaleService.class);
        if (service == null) {
            return Locale.getDefault();
        }
        return service.getLocale();
    }

    @Override
    protected String getUnsetText() {
        return ControlMessages.NumericalControl_NoNumberClickToSetNumber;
    }

    private class NumericalModelToTargetUpdateStrategy
    extends TextControlSWTRenderer.ModelToTargetUpdateStrategy {
        private final Class<?> instanceClass;
        private final ViewModelContext viewModelContext;

        public NumericalModelToTargetUpdateStrategy(Class<?> instanceClass, ViewModelContext viewModelContext, boolean tooltip) {
            super(NumberControlSWTRenderer.this, tooltip);
            this.instanceClass = instanceClass;
            this.viewModelContext = viewModelContext;
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return "";
            }
            DecimalFormat format = NumericalHelper.setupFormat((Locale)NumberControlSWTRenderer.this.getLocale(this.viewModelContext), this.instanceClass);
            return format.format(value);
        }
    }

    private class NumericalTargetToModelUpdateStrategy
    extends TextControlSWTRenderer.TargetToModelUpdateStrategy {
        private final ViewModelContext viewModelContext;
        private final Text text;
        private final IObservableValue modelValue;
        private final EStructuralFeature eStructuralFeature;
        private final DataBindingContext dataBindingContext;

        public NumericalTargetToModelUpdateStrategy(EStructuralFeature eStructuralFeature, ViewModelContext viewModelContext, IObservableValue modelValue, DataBindingContext dataBindingContext, Text text) {
            super(NumberControlSWTRenderer.this, eStructuralFeature.isUnsettable());
            this.eStructuralFeature = eStructuralFeature;
            this.viewModelContext = viewModelContext;
            this.modelValue = modelValue;
            this.dataBindingContext = dataBindingContext;
            this.text = text;
        }

        private DecimalFormat getFormat() {
            return NumericalHelper.setupFormat((Locale)NumberControlSWTRenderer.this.getLocale(this.viewModelContext), (Class)NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
        }

        @Override
        protected Object convertValue(Object value) {
            String formatedNumber;
            DecimalFormat format;
            block18: {
                format = this.getFormat();
                try {
                    Number number = null;
                    if (value == null) {
                        number = NumericalHelper.getDefaultValue((Class)NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
                    } else {
                        ParsePosition pp = new ParsePosition(0);
                        number = format.parse((String)value, pp);
                        if (pp.getErrorIndex() != -1 || pp.getIndex() != ((String)value).length()) {
                            return this.revertToOldValue(value);
                        }
                        if (NumericalHelper.isInteger((Class)NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature))) {
                            boolean maxValue = false;
                            Class instanceClass = NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature);
                            String formatedValue = "";
                            try {
                                if (Integer.class.isAssignableFrom(instanceClass) || Integer.class.getField("TYPE").get(null).equals(instanceClass)) {
                                    if (Integer.MAX_VALUE == number.intValue()) {
                                        maxValue = true;
                                        formatedValue = format.format(Integer.MAX_VALUE);
                                    }
                                } else if ((Long.class.isAssignableFrom(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass)) && Long.MAX_VALUE == number.longValue()) {
                                    maxValue = true;
                                    formatedValue = format.format(Long.MAX_VALUE);
                                }
                            }
                            catch (IllegalArgumentException ex) {
                                Activator.logException((Exception)ex);
                            }
                            catch (SecurityException ex) {
                                Activator.logException((Exception)ex);
                            }
                            catch (IllegalAccessException ex) {
                                Activator.logException((Exception)ex);
                            }
                            catch (NoSuchFieldException ex) {
                                Activator.logException((Exception)ex);
                            }
                            if (maxValue) {
                                this.text.setText(formatedValue);
                                return NumericalHelper.numberToInstanceClass((Number)number, (Class)NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
                            }
                        }
                    }
                    formatedNumber = "";
                    if (number != null) {
                        formatedNumber = format.format(number);
                    }
                    this.text.setText(formatedNumber);
                    if (formatedNumber.length() != 0) break block18;
                    return null;
                }
                catch (ParseException parseException) {
                    return this.revertToOldValue(value);
                }
            }
            return NumericalHelper.numberToInstanceClass((Number)format.parse(formatedNumber), (Class)NumberControlSWTRenderer.this.getInstanceClass(this.eStructuralFeature));
        }

        private Object revertToOldValue(Object value) {
            if (this.eStructuralFeature.getDefaultValue() == null && (value == null || value.equals(""))) {
                return null;
            }
            Object result = this.modelValue.getValue();
            MessageDialog messageDialog = new MessageDialog(this.text.getShell(), ControlMessages.NumericalControl_InvalidNumber, null, ControlMessages.NumericalControl_InvalidNumberWillBeUnset, 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
            new ECPDialogExecutor((Dialog)messageDialog){

                public void handleResult(int codeResult) {
                }
            }.execute();
            this.dataBindingContext.updateTargets();
            if (this.eStructuralFeature.isUnsettable() && result == null) {
                return SetCommand.UNSET_VALUE;
            }
            return result;
        }
    }
}

