/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.rule.RuleRegistry;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.eclipse.emf.ecp.view.spi.rule.model.EnableRule;
import org.eclipse.emf.ecp.view.spi.rule.model.LeafCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.Rule;
import org.eclipse.emf.ecp.view.spi.rule.model.ShowRule;

public class RuleService
implements ViewModelService {
    private static final String DOMAIN_MODEL_NULL_EXCEPTION = "Domain model must not be null.";
    private static final String VIEW_MODEL_NULL_EXCEPTION = "View model must not be null.";
    private ViewModelContext context;
    private ModelChangeAddRemoveListener domainChangeListener;
    private ModelChangeAddRemoveListener viewChangeListener;
    private final RuleRegistry<EnableRule> enableRuleRegistry = new RuleRegistry();
    private final RuleRegistry<ShowRule> showRuleRegistry = new RuleRegistry();

    public void instantiate(final ViewModelContext context) {
        this.context = context;
        VElement view = context.getViewModel();
        this.domainChangeListener = new ModelChangeAddRemoveListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (RuleService.isAttributeNotification(notification)) {
                    EAttribute attribute = (EAttribute)notification.getStructuralFeature();
                    RuleService.this.evalShow((EStructuralFeature)attribute);
                    RuleService.this.evalEnable((EStructuralFeature)attribute);
                } else if (RuleService.this.isMultiRefNotification(notification)) {
                    EReference reference = (EReference)notification.getStructuralFeature();
                    EClass eReferenceType = reference.getEReferenceType();
                    for (EAttribute attribute : eReferenceType.getEAllAttributes()) {
                        RuleService.this.evalShow((EStructuralFeature)attribute);
                        RuleService.this.evalEnable((EStructuralFeature)attribute);
                    }
                }
            }

            public void notifyAdd(Notifier notifier) {
            }

            public void notifyRemove(Notifier notifier) {
            }
        };
        context.registerDomainChangeListener((ModelChangeListener)this.domainChangeListener);
        this.viewChangeListener = new ModelChangeAddRemoveListener(){

            public void notifyChange(ModelChangeNotification notification) {
            }

            public void notifyAdd(Notifier notifier) {
                if (VElement.class.isInstance(notifier)) {
                    RuleService.this.register(RuleService.this.enableRuleRegistry, EnableRule.class, context.getDomainModel(), (EObject)VElement.class.cast(notifier));
                    RuleService.this.register(RuleService.this.showRuleRegistry, ShowRule.class, context.getDomainModel(), (EObject)VElement.class.cast(notifier));
                    Rule rule = RuleService.getRule((VElement)VElement.class.cast(notifier));
                    if (rule == null) {
                        return;
                    }
                    if (LeafCondition.class.isInstance(rule.getCondition())) {
                        this.evalNewRules((LeafCondition)LeafCondition.class.cast(rule.getCondition()));
                    } else {
                        TreeIterator eAllContents = rule.getCondition().eAllContents();
                        while (eAllContents.hasNext()) {
                            EObject eObject = (EObject)eAllContents.next();
                            if (!LeafCondition.class.isInstance(eObject)) continue;
                            this.evalNewRules((LeafCondition)LeafCondition.class.cast(eObject));
                        }
                    }
                }
            }

            private void evalNewRules(LeafCondition leafCondition) {
                leafCondition.getDomainModelReference().init(context.getDomainModel());
                Iterator eStructuralFeatureIterator = leafCondition.getDomainModelReference().getEStructuralFeatureIterator();
                while (eStructuralFeatureIterator.hasNext()) {
                    EStructuralFeature feature = (EStructuralFeature)eStructuralFeatureIterator.next();
                    RuleService.this.evalEnable(feature);
                    RuleService.this.evalShow(feature);
                }
            }

            public void notifyRemove(Notifier notifier) {
                if (VElement.class.isInstance(notifier)) {
                    VElement renderable = (VElement)VElement.class.cast(notifier);
                    RuleService.this.showRuleRegistry.removeRenderable(renderable);
                    RuleService.this.enableRuleRegistry.removeRenderable(renderable);
                } else if (Condition.class.isInstance(notifier)) {
                    Condition condition = (Condition)Condition.class.cast(notifier);
                    RuleService.resetToVisible(RuleService.this.showRuleRegistry.removeCondition(condition));
                    RuleService.resetToEnabled(RuleService.this.enableRuleRegistry.removeCondition(condition));
                } else if (ShowRule.class.isInstance(notifier)) {
                    ShowRule showRule = (ShowRule)ShowRule.class.cast(notifier);
                    RuleService.resetToVisible(RuleService.this.showRuleRegistry.removeRule(showRule));
                } else if (EnableRule.class.isInstance(notifier)) {
                    EnableRule enableRule = (EnableRule)EnableRule.class.cast(notifier);
                    RuleService.resetToEnabled(RuleService.this.enableRuleRegistry.removeRule(enableRule));
                }
            }
        };
        context.registerViewChangeListener((ModelChangeListener)this.viewChangeListener);
        if (view == null) {
            throw new IllegalStateException(VIEW_MODEL_NULL_EXCEPTION);
        }
        EObject domainModel = context.getDomainModel();
        if (domainModel == null) {
            throw new IllegalStateException(DOMAIN_MODEL_NULL_EXCEPTION);
        }
        this.init(this.enableRuleRegistry, EnableRule.class, (EObject)view, domainModel);
        this.init(this.showRuleRegistry, ShowRule.class, (EObject)view, domainModel);
        this.evalEnable();
        this.evalShow();
    }

    private static void resetToVisible(VElement renderable) {
        if (renderable != null) {
            renderable.setVisible(true);
        }
    }

    private static void resetToEnabled(VElement renderable) {
        if (renderable != null) {
            renderable.setEnabled(true);
        }
    }

    private static Rule getRule(VElement renderable) {
        for (VAttachment attachment : renderable.getAttachments()) {
            if (!Rule.class.isInstance(attachment)) continue;
            Rule rule = (Rule)attachment;
            return rule;
        }
        return null;
    }

    private static <T extends Rule> void updateStateMap(Map<VElement, Boolean> stateMap, VElement renderable, boolean isOpposite, boolean evalResult, Class<T> ruleType) {
        if (!stateMap.containsKey(renderable)) {
            Condition condition;
            boolean didUpdate = false;
            Rule rule = RuleService.getRule(renderable);
            if (rule != null && RuleService.ruleApplies(rule, ruleType) && (condition = rule.getCondition()) != null && RuleService.canOverrideParent(evalResult, isOpposite)) {
                boolean evaluate = condition.evaluate();
                stateMap.put(renderable, RuleService.isOpposite(rule) ? !evaluate : evaluate);
                didUpdate = true;
            }
            if (!didUpdate) {
                stateMap.put(renderable, isOpposite ? !evalResult : evalResult);
            }
        } else {
            Boolean currentState = (boolean)stateMap.get(renderable);
            if (currentState.booleanValue()) {
                stateMap.put(renderable, isOpposite ? !evalResult : evalResult);
            }
        }
        for (EObject childContent : renderable.eContents()) {
            if (!(childContent instanceof VElement)) continue;
            RuleService.updateStateMap(stateMap, (VElement)childContent, isOpposite, evalResult, ruleType);
        }
    }

    private static boolean canOverrideParent(boolean evalResult, boolean isOpposite) {
        return evalResult && !isOpposite || !evalResult && isOpposite;
    }

    private static <T extends Rule> boolean ruleApplies(Rule rule, Class<T> ruleType) {
        return Arrays.asList(rule.getClass().getInterfaces()).contains(ruleType);
    }

    private static boolean isOpposite(Rule rule) {
        return RuleService.isHideRule(rule) || RuleService.isDisableRule(rule);
    }

    private static <T extends Rule> boolean hasRule(Class<T> ruleType, EObject eObject) {
        if (!VElement.class.isInstance(eObject)) {
            return false;
        }
        VElement renderable = (VElement)eObject;
        Rule rule = RuleService.getRule(renderable);
        return ruleType.isInstance(rule);
    }

    private static <T extends Rule> Map<VElement, Boolean> evalAffectedRenderables(RuleRegistry<T> registry, Class<T> ruleType, EStructuralFeature attribute, boolean isDryRun, Map<EStructuralFeature.Setting, Object> possibleValues) {
        LinkedHashMap<VElement, Boolean> map = new LinkedHashMap<VElement, Boolean>();
        for (Map.Entry<T, VElement> ruleAndRenderable : registry.getAffectedRenderables(attribute).entrySet()) {
            boolean isOposite;
            Rule rule = (Rule)ruleAndRenderable.getKey();
            VElement renderable = ruleAndRenderable.getValue();
            boolean hasChanged = true;
            if (!ruleType.isInstance(rule)) continue;
            if (isDryRun) {
                hasChanged = RuleService.checkDryRun(possibleValues);
            }
            boolean result = false;
            boolean updateMap = true;
            if (rule.getCondition() == null) {
                result = false;
            } else if (isDryRun && hasChanged) {
                result = rule.getCondition().evaluateChangedValues(possibleValues);
            } else if (!isDryRun) {
                result = rule.getCondition().evaluate();
            } else {
                updateMap = false;
            }
            boolean bl = isOposite = RuleService.isDisableRule(rule) || RuleService.isHideRule(rule);
            if (!(updateMap &= RuleService.propagateChanges(result, isOposite, rule, renderable))) continue;
            RuleService.updateStateMap(map, renderable, isOposite, result, ruleType);
        }
        return map;
    }

    private static boolean propagateChanges(boolean result, boolean isOposite, Rule rule, VElement renderable) {
        if (result && !isOposite || isOposite && !result) {
            if (ShowRule.class.isInstance(rule)) {
                if (isOposite && result != renderable.isVisible()) {
                    return false;
                }
                if (!isOposite && result == renderable.isVisible()) {
                    return false;
                }
            } else if (EnableRule.class.isInstance(rule)) {
                if (isOposite && result != renderable.isEnabled()) {
                    return false;
                }
                if (!isOposite && result == renderable.isEnabled()) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkDryRun(Map<EStructuralFeature.Setting, Object> possibleValues) {
        boolean hasChanged = true;
        for (EStructuralFeature.Setting setting : possibleValues.keySet()) {
            EObject parent = setting.getEObject();
            EStructuralFeature feature = setting.getEStructuralFeature();
            EClass attributeClass = feature.getEContainingClass();
            if (!attributeClass.isInstance((Object)parent)) continue;
            Object actualValue = parent.eGet(feature);
            Object newValue = possibleValues.get(setting);
            if (!feature.isMany()) {
                if (newValue == null) {
                    hasChanged &= actualValue == null;
                    continue;
                }
                hasChanged &= !newValue.equals(actualValue);
                continue;
            }
            List objects = (List)actualValue;
            hasChanged &= !objects.contains(newValue);
        }
        return hasChanged;
    }

    private static <T extends Rule> Map<VElement, Boolean> evalAffectedRenderables(RuleRegistry<T> registry, Class<T> ruleType, EStructuralFeature attribute, Map<EStructuralFeature.Setting, Object> possibleValues) {
        return RuleService.evalAffectedRenderables(registry, ruleType, attribute, true, possibleValues);
    }

    private static <T extends Rule> Map<VElement, Boolean> evalAffectedRenderables(RuleRegistry<T> registry, Class<T> ruleType, EStructuralFeature attribute) {
        Map<EStructuralFeature.Setting, Object> changedValues = Collections.emptyMap();
        return RuleService.evalAffectedRenderables(registry, ruleType, attribute, false, changedValues);
    }

    private static boolean isDisableRule(Rule rule) {
        if (RuleService.isEnableRule(rule)) {
            EnableRule enableRule = (EnableRule)rule;
            return enableRule.isDisable();
        }
        return false;
    }

    private static boolean isHideRule(Rule rule) {
        if (RuleService.isShowRule(rule)) {
            ShowRule showRule = (ShowRule)rule;
            return showRule.isHide();
        }
        return false;
    }

    private static boolean isShowRule(Rule rule) {
        return rule instanceof ShowRule;
    }

    private <T extends Rule> void evalShow(EStructuralFeature attribute) {
        Map<VElement, Boolean> visibleMap = RuleService.evalAffectedRenderables(this.showRuleRegistry, ShowRule.class, attribute);
        for (Map.Entry<VElement, Boolean> e : visibleMap.entrySet()) {
            Boolean isVisible = e.getValue();
            VElement renderable = e.getKey();
            renderable.setVisible(isVisible.booleanValue());
        }
    }

    private <T extends Rule> void evalEnable(EStructuralFeature attribute) {
        Map<VElement, Boolean> enabledMap = RuleService.evalAffectedRenderables(this.enableRuleRegistry, EnableRule.class, attribute);
        for (Map.Entry<VElement, Boolean> e : enabledMap.entrySet()) {
            e.getKey().setEnabled(e.getValue().booleanValue());
        }
    }

    private <T extends Rule> void evalShow() {
        for (EStructuralFeature feature : this.showRuleRegistry.getAttributes()) {
            this.evalShow(feature);
        }
    }

    private <T extends Rule> void evalEnable() {
        for (EStructuralFeature feature : this.enableRuleRegistry.getAttributes()) {
            this.evalEnable(feature);
        }
    }

    private <T extends Rule> void init(RuleRegistry<T> registry, Class<T> ruleType, EObject viewModel, EObject domainObject) {
        TreeIterator iterator = viewModel.eAllContents();
        this.register(registry, ruleType, domainObject, viewModel);
        while (iterator.hasNext()) {
            EObject content = (EObject)iterator.next();
            this.register(registry, ruleType, domainObject, content);
        }
    }

    private <T extends Rule> void register(RuleRegistry<T> registry, Class<T> ruleType, EObject domainObject, EObject viewModel) {
        if (RuleService.hasRule(ruleType, viewModel)) {
            VElement renderable = (VElement)viewModel;
            Rule rule = RuleService.getRule(renderable);
            registry.register(renderable, rule, rule.getCondition(), domainObject);
        }
    }

    public Map<VElement, Boolean> getDisabledRenderables(Map<EStructuralFeature.Setting, Object> possibleValues, EAttribute changedAttribute) {
        return RuleService.evalAffectedRenderables(this.enableRuleRegistry, EnableRule.class, (EStructuralFeature)changedAttribute, possibleValues);
    }

    public Map<VElement, Boolean> getHiddenRenderables(Map<EStructuralFeature.Setting, Object> possibleValues, EAttribute changedAttribute) {
        return RuleService.evalAffectedRenderables(this.showRuleRegistry, ShowRule.class, (EStructuralFeature)changedAttribute, possibleValues);
    }

    public void dispose() {
        this.context.unregisterDomainChangeListener((ModelChangeListener)this.domainChangeListener);
        this.context.unregisterViewChangeListener((ModelChangeListener)this.viewChangeListener);
    }

    private static boolean isEnableRule(Rule rule) {
        return EnableRule.class.isInstance(rule);
    }

    private static boolean isAttributeNotification(ModelChangeNotification notification) {
        return notification.getStructuralFeature() instanceof EAttribute;
    }

    private boolean isMultiRefNotification(ModelChangeNotification notification) {
        if (EReference.class.isInstance(notification.getStructuralFeature())) {
            EReference reference = (EReference)notification.getStructuralFeature();
            return reference.getUpperBound() < 0 || reference.getUpperBound() > 1;
        }
        return false;
    }

    public int getPriority() {
        return 1;
    }
}

