/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.OperationAuthorProvider;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOperationAuthorProvider
implements OperationAuthorProvider {
    private static final String UNKOWN = "UNKOWN";
    private final Map<AbstractOperation, String> operationAuthorMap = new LinkedHashMap<AbstractOperation, String>();

    public DefaultOperationAuthorProvider(List<ChangePackage> leftChanges, List<ChangePackage> rightChanges) {
        for (ChangePackage changePackage : leftChanges) {
            this.scanIntoAuthorMap(changePackage);
        }
        for (ChangePackage changePackage : rightChanges) {
            this.scanIntoAuthorMap(changePackage);
        }
    }

    private void scanIntoAuthorMap(ChangePackage changePackage) {
        if (changePackage.getLogMessage() != null && changePackage.getLogMessage().getAuthor() != null) {
            String author = changePackage.getLogMessage().getAuthor();
            for (AbstractOperation operation : changePackage.getOperations()) {
                this.operationAuthorMap.put(operation, author);
            }
        }
    }

    @Override
    public String getAuthor(AbstractOperation operation) {
        String author = this.operationAuthorMap.get(operation);
        if (author == null) {
            author = UNKOWN;
        }
        return author;
    }
}

