/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software) - initial API and implementation
 *     Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *******************************************************************************/
package org.eclipse.emf.facet.infra.browser.custom.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.browser.custom.AttributeView;
import org.eclipse.emf.facet.infra.browser.custom.CustomViewFeature;
import org.eclipse.emf.facet.infra.browser.custom.CustomizableFeatures;
import org.eclipse.emf.facet.infra.browser.custom.FeatureValue;
import org.eclipse.emf.facet.infra.browser.custom.FeatureValueCase;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.ReferenceView;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.swt.graphics.RGB;

/**
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374109
 */
@Deprecated
public final class UicustomUtil {

	private static final int MAX_COLOR_INTENSITY = 255;

	private UicustomUtil() {
		// cannot be instantiated
	}

	private static final Pattern RGB_PATTERN = Pattern.compile("\\((\\d+),(\\d+),(\\d+)\\)"); //$NON-NLS-1$
	private static final int RGB_PATTERN_GROUP_RED = 1;
	private static final int RGB_PATTERN_GROUP_GREEN = 2;
	private static final int RGB_PATTERN_GROUP_BLUE = 3;

	/**
	 * Decode the given color string (R,G,B)
	 * 
	 * @return the corresponding color, or <code>null</code> if the given string
	 *         does not define a valid color
	 */
	public static RGB decodeColor(final String strColor) {
		Matcher matcher = UicustomUtil.RGB_PATTERN.matcher(strColor);
		if (matcher.matches()) {
			try {
				int r = Integer.parseInt(matcher.group(UicustomUtil.RGB_PATTERN_GROUP_RED));
				int g = Integer.parseInt(matcher.group(UicustomUtil.RGB_PATTERN_GROUP_GREEN));
				int b = Integer.parseInt(matcher.group(UicustomUtil.RGB_PATTERN_GROUP_BLUE));
				if (r >= 0 && r <= UicustomUtil.MAX_COLOR_INTENSITY && g >= 0
						&& g <= UicustomUtil.MAX_COLOR_INTENSITY && b >= 0
						&& b <= UicustomUtil.MAX_COLOR_INTENSITY) {
					return new RGB(r, g, b);
				}
			} catch (NumberFormatException e) {
				return null;
			}
		}
		return null;
	}

	public static OverlayIconInfo decodeOverlayIcon(final String encodedOverlayIcon) {
		String[] parts = encodedOverlayIcon.split(":"); //$NON-NLS-1$
		if (parts.length != 2) {
			throw new IllegalArgumentException("overlay icon should be encoded as 'path:position'"); //$NON-NLS-1$
		}
		return new OverlayIconInfo(parts[0], OverlayIconPosition.valueOf(parts[1]));
	}

	public static String encodeOverlayIcon(final String path, final OverlayIconPosition iconPosition) {
		return path + ":" + iconPosition; //$NON-NLS-1$
	}

	public static CustomizableFeatures getCustomizedFeature(final FeatureValue featureValue) {
		CustomViewFeature feature = featureValue.getFeature();
		if (feature == null) {
			return featureValue.getCase().getFeature().getCustomizedFeature();
		}
		return feature.getCustomizedFeature();
	}

	/**
	 * @return the {@link FeatureValue} of the given {@link CustomViewFeature}
	 *         or {@link FeatureValueCase}, or <code>null</code> if the given
	 *         element is not of one of these types
	 */
	public static FeatureValue getFeatureValue(final Object element) {
		if (element instanceof CustomViewFeature) {
			CustomViewFeature customViewFeature = (CustomViewFeature) element;
			return customViewFeature.getDefaultValue();
		} else if (element instanceof FeatureValueCase) {
			FeatureValueCase valueCase = (FeatureValueCase) element;
			return valueCase.getValue();
		}
		return null;
	}

	/**
	 * Returns the corresponding {@link MetamodelView} or <code>null</code> if
	 * not found
	 * 
	 * @param metamodels
	 *            a list of {@link MetamodelView}
	 * @param EPackage
	 *            the looked for EPackage
	 * @return the corresponding {@link MetamodelView} or <code>null</code> if
	 *         not found
	 */
	public static MetamodelView getMetamodelViewByEPackage(final List<MetamodelView> metamodels,
			final EPackage ePackage) {
		if (ePackage != null) {
			for (MetamodelView current : metamodels) {
				if (current != null && current.getMetamodelURI().equals(ePackage.getNsURI())) {
					return current;
				}
			}
		}
		return null;
	}


	/**
	 * 
	 * @param typeViews
	 *            a list of {@link TypeView}
	 * @param eClass
	 *            the eClass of a wanted {@link TypeView}
	 * @return the wanted {@link TypeView} of <code>null</code> if not found
	 */
	public static TypeView getTypeViewByQualifiedName(final List<TypeView> typeViews,
			final EClass eClass) {
		if (eClass != null) {
			for (TypeView current : typeViews) {
				if (current != null
						&& current.getMetaclassName().equals(
								ModelUtils.getMetaclassQualifiedName(eClass))) {
					return current;
				}
			}
		}
		return null;
	}

	/**
	 * 
	 * @param attributeViews
	 *            a list of {@link AttributeView}
	 * @param feature
	 *            the feature of the wanted {@link AttributeView}
	 * @return the wanted {@link AttributeView} or <code>null</code> if not
	 *         found
	 */
	public static AttributeView getAttributeViewByEStructuralFeature(
			final List<AttributeView> attributeViews, final EStructuralFeature feature) {
		if (feature != null) {
			for (AttributeView current : attributeViews) {
				if (current != null && current.getAttributeName().equals(feature.getName())) {
					return current;
				}
			}
		}
		return null;
	}

	/**
	 * 
	 * @param referenceViews
	 *            a list of {@link ReferenceView}
	 * @param feature
	 *            the feature of the wanted {@link ReferenceView}
	 * @return the wanted {@link ReferenceView} or <code>null</code> if not
	 *         found
	 */
	public static ReferenceView getReferenceViewByEStructuralFeature(
			final List<ReferenceView> referenceViews, final EStructuralFeature feature) {
		if (feature != null) {
			for (ReferenceView current : referenceViews) {
				if (current != null && current.getReferenceName().equals(feature.getName())) {
					return current;
				}
			}
		}
		return null;
	}

	/**
	 * 
	 * @param customViewFeatures
	 *            a list of {@link CustomizableFeatures}
	 * @param customizedFeatureName
	 *            the name of the wanted {@link CustomViewFeature}
	 * @return the wanted {@link CustomViewFeature} or <code>null</code> if not
	 *         found
	 */
	public static CustomViewFeature getCustomViewFeatureByName(
			final List<CustomViewFeature> customViewFeatures, final String customizedFeatureName) {
		for (CustomViewFeature current : customViewFeatures) {
			if (current != null
					&& current.getCustomizedFeature().getName().equals(customizedFeatureName)) {
				return current;
			}
		}
		return null;
	}

}
