/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.ui.internal.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.emf.facet.infra.common.ui.internal.EmfFacetCommonUIPlugin;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertToEmfFacetProjectAction
implements IObjectActionDelegate {
    private ISelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.fSelection;
            for (Object next : structuredSelection) {
                if (!(next instanceof IProject)) continue;
                final IProject project = (IProject)next;
                BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ConvertToEmfFacetProjectAction.this.convertProject(project);
                    }
                });
            }
        }
    }

    private void convertProject(IProject project) {
        try {
            ProjectUtils.configureAsJavaProject((IProject)project, (IProgressMonitor)new NullProgressMonitor());
            ProjectUtils.configureAsPluginProject((IProject)project);
            ProjectUtils.addNature((IProject)project, (IProgressMonitor)new NullProgressMonitor(), (String)"org.eclipse.emf.facet.common.ProjectNature");
            ProjectUtils.createBuildProperties((IProject)project);
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)EmfFacetCommonUIPlugin.getDefault());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

