/*
 * Copyright (c) 2006, 2009 Borland Software Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     committers of openArchitectureWare - Xpand language syntax
 *     Artem Tikhomirov (Borland) - LALR grammar
 *                                - Migration to OCL expressions
 */
package org.eclipse.gmf.internal.xpand.parser;

public class XpandKWLexerprs implements lpg.runtime.ParseTable, XpandKWLexersym {
    public final static int ERROR_SYMBOL = 0;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 0;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 0;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 0;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 560;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 56;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 864;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 1;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 149;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 4;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 60;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 150;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 0;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 45;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 57;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 714;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 715;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = false;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return XpandKWLexersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static byte prosthesesIndex[] = {0,
            2,3,4,1
        };
    };
    public final static byte prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static byte baseCheck[] = {0,
            4,2,4,4,5,3,2,3,3,7,
            3,2,4,5,3,3,8,10,10,6,
            7,16,4,7,5,6,7,10,4,7,
            1,4,4,5,6,4,7,8,9,10,
            13,16,7,6,7,6,3,5,8,3,
            6,4,3,1,6,4,3,3,6,14,
            6,7,9,9,6,8,6,7,5,6,
            5,4,13,10,12,8,9,5,3,4,
            4,7,10,9,12,10,13,12,15,9,
            4,5,7,6,7,8,8,6,4,4,
            8,11,8,7,7,2,4,4,6,9,
            4,7,7,9,5,8,10,3,3,7,
            9,6,9,6,9,6,9,5,6,3,
            9,2,8,7,10,4,7,2,6,4,
            5,3,6,7,6,4,2,7,10
        };
    };
    public final static byte baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static byte rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            1,2,2,2,2,2,2,2,2,2,
            2,2,2,2,2,2,2,2,2,2,
            2,2,2,2,2,2,2,2,2,2,
            2,3,3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3,3,3,
            3,3,3,3,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,2,2,2,2,2,2,2,2,
            2,2,2,2,2,2,2,2,2,2,
            2,2,2,2,2,2,2,2,2,2,
            1,154,31,54,230,48,172,23,90,73,
            120,108,47,183,67,263,194,130,43,104,
            123,193,135,82,138,86,129,153,91,98,
            185,278,118,149,107,160,162,197,204,170,
            274,223,205,270,282,288,38,290,286,291,
            206,145,283,280,293,296,294,297,299,207,
            300,301,302,304,305,316,312,319,306,321,
            320,322,326,327,329,216,332,333,334,337,
            217,221,222,340,341,169,228,52,342,343,
            347,351,348,39,355,359,361,235,344,367,
            372,238,373,358,63,375,376,380,381,378,
            389,387,384,139,392,395,394,399,396,405,
            397,400,407,410,408,412,411,140,413,417,
            414,419,422,424,432,421,433,437,429,423,
            435,441,444,445,446,449,448,25,450,451,
            452,461,464,453,465,471,171,473,454,467,
            476,478,475,484,477,485,491,496,498,500,
            486,502,345,503,507,509,510,513,514,515,
            518,519,521,69,236,489,524,527,529,532,
            534,536,525,243,538,537,540,247,245,541,
            544,539,250,545,547,550,559,553,177,549,
            560,566,568,569,256,572,573,574,575,577,
            579,578,583,584,586,588,590,592,593,596,
            599,600,603,601,604,609,608,610,614,611,
            617,615,616,252,618,621,624,625,634,622,
            630,636,638,639,640,651,643,645,655,657,
            653,660,664,659,666,667,670,671,672,675,
            677,679,678,682,689,691,692,695,694,697,
            701,702,703,704,711,713,709,715,716,718,
            720,722,724,726,727,731,728,735,737,681,
            738,739,260,744,747,740,748,749,752,753,
            754,755,760,757,761,764,765,767,756,771,
            773,777,769,781,782,783,784,785,786,788,
            791,792,794,795,798,796,799,800,802,804,
            797,807,812,816,819,826,827,828,829,830,
            838,839,831,843,840,846,844,849,850,851,
            855,856,861,857,863,867,866,870,871,877,
            879,881,875,884,886,887,882,890,893,894,
            895,896,897,905,898,901,904,910,909,913,
            914,915,916,921,922,926,927,918,931,928,
            933,934,935,936,937,939,945,942,944,947,
            952,948,960,958,949,962,967,968,970,972,
            973,978,979,976,981,984,986,989,993,994,
            995,997,998,996,1000,1008,1009,1012,999,1010,
            1014,1015,1017,1021,1022,1026,1029,1024,1032,1033,
            1035,1037,1038,1041,1042,1046,1049,1050,1047,1052,
            1053,1054,1055,1056,1062,1060,1059,1067,1066,1068,
            1073,1077,1080,1079,1083,1082,1093,1084,1089,254,
            1094,1090,1097,1101,1104,175,1105,1098,1106,1109,
            1111,1112,1114,1117,1116,1120,1123,1124,1125,1126,
            1127,1128,1132,1130,1135,1136,1137,1141,1142,1150,
            1154,1155,1159,1153,1162,1164,1165,1168,1170,1143,
            1172,1173,1174,1175,1179,1180,1181,1183,1189,1191,
            1193,1196,1197,1200,1202,1203,264,1206,1208,1209,
            1210,1215,1212,1218,1221,1222,1226,1220,1227,1230,
            1231,1232,1235,1234,1240,1241,1242,1245,1247,1248,
            1249,1250,1256,715,715
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,0,1,0,25,26,27,28,29,
            30,31,32,33,34,35,36,0,0,39,
            40,17,0,6,20,3,0,0,10,25,
            3,0,28,2,30,4,9,33,21,8,
            18,15,0,17,2,3,0,25,0,7,
            28,9,0,1,6,7,4,26,27,7,
            8,0,16,21,42,0,0,6,22,0,
            0,6,7,3,13,14,30,0,1,9,
            10,4,13,0,7,8,0,0,23,6,
            44,26,31,10,8,9,10,0,1,0,
            1,31,0,16,7,19,7,8,0,0,
            8,3,3,11,0,1,2,0,0,0,
            3,3,5,5,0,11,2,19,0,21,
            6,29,0,1,6,7,8,19,19,0,
            8,0,1,2,5,13,7,8,0,0,
            0,0,35,4,0,7,0,6,2,8,
            11,13,0,9,0,9,17,17,4,15,
            20,23,0,0,1,34,0,21,16,7,
            8,5,6,0,0,0,0,4,4,4,
            26,29,8,43,11,0,0,2,2,14,
            0,0,0,1,18,4,10,0,1,0,
            9,4,12,13,0,0,2,0,1,33,
            5,4,0,8,0,3,0,1,6,0,
            4,0,8,0,39,0,1,13,0,0,
            11,8,0,0,15,31,15,8,17,0,
            17,8,13,0,45,13,21,0,5,0,
            17,0,0,14,7,0,5,0,1,0,
            0,2,0,0,9,0,0,15,0,0,
            0,0,12,0,0,0,5,7,16,30,
            15,0,16,14,11,0,5,2,0,0,
            0,0,29,25,5,0,0,22,0,8,
            12,0,0,0,6,2,0,33,18,0,
            0,0,0,0,0,14,0,0,12,24,
            0,5,2,14,0,14,9,0,0,33,
            0,4,2,9,24,21,0,24,2,37,
            12,0,0,2,0,0,34,0,6,0,
            0,6,8,0,5,8,0,7,0,1,
            7,0,6,0,0,0,0,4,0,0,
            9,7,7,5,0,1,0,0,9,0,
            0,0,0,0,18,4,0,10,0,9,
            0,0,0,0,6,4,14,14,0,13,
            7,0,0,1,0,29,0,28,7,3,
            0,7,14,0,0,0,24,0,0,0,
            0,0,0,0,11,11,5,37,18,11,
            0,11,15,0,0,5,0,4,16,20,
            0,1,0,1,0,0,0,0,25,15,
            5,36,5,0,0,0,20,4,0,13,
            0,1,8,5,20,0,1,0,1,0,
            1,0,0,1,19,4,0,1,0,0,
            1,3,0,0,0,1,3,0,0,1,
            0,9,2,0,0,2,0,1,0,1,
            13,0,1,0,1,0,0,0,0,0,
            0,6,5,0,0,9,0,7,0,0,
            26,12,0,9,5,0,13,19,0,0,
            14,9,14,5,5,0,1,0,0,2,
            2,0,0,0,0,2,0,0,0,7,
            2,10,0,0,1,0,4,0,1,0,
            5,0,0,17,20,0,19,2,0,0,
            0,1,0,0,5,13,4,0,0,0,
            0,13,23,0,0,0,0,0,27,11,
            0,0,19,0,0,11,16,20,11,0,
            17,22,16,0,1,0,16,0,0,0,
            19,3,0,28,0,22,22,8,6,20,
            0,16,0,3,0,1,0,1,0,0,
            16,24,3,0,1,0,0,9,16,0,
            0,0,6,3,0,10,0,0,0,2,
            0,0,2,14,6,9,12,6,0,1,
            0,0,21,0,0,5,0,6,4,6,
            0,0,0,0,1,9,6,6,0,7,
            0,1,0,1,0,0,8,0,3,0,
            6,0,5,0,5,0,0,0,3,6,
            0,1,5,7,0,1,0,0,0,0,
            19,4,4,0,1,9,0,0,0,10,
            4,0,0,0,0,0,0,10,4,0,
            0,2,6,0,0,1,0,7,0,6,
            0,5,0,3,2,22,0,9,23,3,
            0,0,0,0,0,0,38,0,8,38,
            0,0,40,0,0,0,0,0,0,0,
            15,0,4,0,1,18,0,16,25,15,
            4,0,28,32,32,0,1,18,0,18,
            30,28,25,27,29,0,0,0,0,0,
            0,1,3,7,23,10,18,0,0,0,
            2,4,0,0,2,0,1,20,0,0,
            0,12,24,4,0,0,0,2,4,9,
            0,1,0,7,21,0,0,19,2,0,
            0,9,7,3,0,6,0,1,0,1,
            0,0,2,0,1,0,0,1,3,0,
            1,10,0,0,0,0,0,0,3,6,
            0,27,10,0,0,9,2,10,0,0,
            10,2,0,0,0,0,2,0,24,4,
            0,0,2,2,11,0,0,0,2,26,
            0,14,0,0,0,0,0,12,0,31,
            10,0,30,0,0,12,0,0,0,11,
            23,0,18,2,18,11,24,0,17,0,
            12,0,15,17,7,6,0,0,2,0,
            3,0,0,12,2,0,41,0,0,36,
            0,10,4,0,9,0,1,18,0,12,
            2,8,0,0,0,0,0,0,0,0,
            8,21,5,9,5,12,10,0,0,0,
            3,0,1,0,0,2,0,9,23,10,
            0,0,1,0,26,0,1,13,0,13,
            2,0,0,13,0,1,0,0,15,8,
            0,0,1,11,4,0,0,2,0,0,
            1,0,0,0,0,0,1,11,0,0,
            23,0,14,27,5,0,0,0,1,15,
            4,20,0,1,22,22,0,16,0,0,
            15,0,0,0,8,6,5,29,0,0,
            12,9,0,0,2,2,0,0,10,10,
            0,1,6,0,0,0,23,3,0,1,
            0,0,9,0,1,0,0,12,8,0,
            9,5,0,0,0,0,0,0,1,0,
            4,0,35,11,0,0,0,12,3,8,
            0,0,0,9,4,16,22,32,25,0,
            1,32,0,0,0,19,3,3,0,7,
            2,0,1,0,0,1,3,0,27,0,
            3,0,0,0,0,2,0,3,0,0,
            0,1,0,41,12,7,7,18,0,1,
            0,9,0,22,2,0,0,1,8,0,
            5,0,0,2,2,0,7,0,0,0,
            1,0,4,6,0,4,2,0,1,0,
            0,0,17,3,3,0,0,8,3,0,
            0,0,1,0,0,2,10,3,8,0,
            0,0,13,3,0,6,0,0,0,0,
            3,3,0,7,5,0,1,0,17,15,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            715,174,175,177,176,179,182,178,173,186,
            185,164,159,155,156,169,166,168,165,160,
            163,183,715,194,715,189,157,181,162,172,
            188,187,170,161,180,184,167,715,715,158,
            171,392,715,282,395,215,715,715,337,394,
            190,12,393,329,391,332,191,390,283,330,
            213,204,715,203,350,349,715,862,715,346,
            853,348,715,196,424,425,198,331,333,197,
            821,715,207,347,214,715,715,229,208,715,
            715,235,234,245,228,226,206,715,249,244,
            243,247,195,715,246,248,715,715,233,217,
            209,236,227,216,261,260,259,715,254,715,
            201,242,715,202,253,258,200,199,715,715,
            220,237,212,218,715,225,224,715,715,715,
            231,358,232,360,715,223,290,238,715,717,
            289,219,715,239,255,257,256,359,372,715,
            241,715,267,265,262,240,264,263,715,715,
            715,715,230,274,715,325,715,192,451,193,
            273,326,715,664,715,449,272,403,250,665,
            405,834,715,715,211,266,715,450,205,222,
            221,268,269,715,715,715,715,271,277,287,
            251,847,278,404,270,715,715,730,319,288,
            715,715,715,276,299,322,318,715,328,715,
            323,327,321,320,715,715,340,715,343,298,
            427,344,715,426,715,787,715,437,433,715,
            438,715,440,82,314,715,456,439,715,715,
            444,661,715,86,443,341,481,532,480,715,
            660,695,533,715,714,210,716,715,275,715,
            694,715,715,279,252,715,280,715,281,715,
            715,284,715,715,285,715,715,291,715,715,
            715,715,286,715,715,715,302,301,293,292,
            294,715,296,300,303,715,306,305,715,715,
            715,715,295,297,310,715,715,308,715,311,
            307,715,715,715,313,773,7,304,309,715,
            715,715,715,715,715,315,715,715,317,731,
            715,335,724,324,715,334,336,715,715,312,
            715,345,339,338,833,822,715,765,726,316,
            721,715,715,342,715,715,768,715,762,715,
            715,352,351,715,353,355,715,354,715,356,
            357,715,723,715,715,715,715,363,715,715,
            361,362,365,364,715,366,715,715,367,715,
            715,715,715,715,857,371,715,370,715,806,
            715,715,715,715,376,377,373,375,79,374,
            378,715,715,381,715,368,715,369,379,814,
            715,384,382,715,130,715,383,715,715,715,
            715,715,715,715,851,386,398,380,385,388,
            715,397,389,715,715,738,715,399,400,396,
            715,402,715,406,715,715,715,715,861,401,
            408,387,409,715,715,715,407,411,715,412,
            715,414,413,744,410,715,415,715,416,715,
            417,57,715,719,823,418,715,419,715,715,
            728,420,715,715,715,421,718,715,715,423,
            715,815,771,715,715,428,715,429,715,430,
            422,715,796,715,431,715,715,715,715,715,
            715,432,434,715,715,435,715,441,715,715,
            767,436,715,445,446,715,442,826,715,715,
            795,448,452,447,453,715,751,715,715,454,
            455,715,715,715,715,748,715,715,715,458,
            747,457,715,715,463,715,462,715,465,715,
            464,715,715,460,459,715,461,468,715,715,
            715,472,715,715,470,467,471,715,715,715,
            715,469,784,140,715,715,715,715,466,474,
            715,715,473,715,715,479,843,475,482,715,
            477,476,478,715,740,715,483,715,715,715,
            486,490,715,856,715,484,485,491,493,487,
            715,488,715,492,715,495,715,496,715,715,
            494,489,498,715,499,715,715,500,497,715,
            715,715,502,504,715,501,715,715,715,786,
            715,715,529,503,507,506,505,508,715,509,
            715,715,720,715,715,510,715,511,512,513,
            715,715,715,715,807,514,515,516,715,517,
            715,763,715,830,715,715,518,715,520,715,
            519,715,521,715,522,715,715,715,525,524,
            715,729,527,526,715,528,715,715,715,715,
            523,530,531,715,534,793,715,715,715,536,
            535,715,715,715,715,715,715,537,541,715,
            715,542,543,715,715,545,715,544,715,785,
            715,546,715,548,549,540,715,780,547,550,
            715,715,715,715,715,715,538,715,551,749,
            715,715,539,715,715,715,715,715,715,715,
            554,715,560,715,562,858,715,556,839,558,
            564,715,854,552,553,715,565,561,715,837,
            555,557,844,563,559,715,715,715,715,715,
            715,571,569,567,741,566,860,715,715,715,
            774,570,715,715,572,715,574,568,715,715,
            715,573,735,577,715,715,715,776,579,578,
            715,580,715,581,575,715,715,576,766,715,
            715,809,582,584,715,583,715,585,715,586,
            715,715,813,715,782,715,715,759,761,715,
            589,588,715,715,715,715,715,715,593,591,
            715,587,590,715,715,594,595,596,715,715,
            770,597,715,715,715,715,600,715,592,601,
            715,715,602,603,841,715,715,715,819,750,
            715,604,715,715,715,715,715,820,715,598,
            605,715,599,715,715,607,715,715,715,852,
            606,715,859,613,608,609,783,715,610,715,
            742,715,614,612,615,736,715,715,617,715,
            739,715,715,616,620,715,849,715,109,611,
            715,619,621,715,810,715,623,618,715,828,
            624,622,715,715,715,715,715,715,715,715,
            625,835,827,725,627,745,626,715,715,715,
            628,715,629,715,715,752,715,808,777,630,
            715,715,634,715,758,715,760,631,715,632,
            635,715,715,633,715,638,715,715,636,637,
            715,715,818,863,640,715,715,641,715,715,
            643,715,715,715,715,715,649,644,715,715,
            791,715,642,639,650,715,715,715,732,648,
            652,645,715,654,646,647,715,848,715,715,
            653,715,715,715,655,656,658,651,715,715,
            657,781,715,715,812,753,715,715,659,662,
            715,764,663,715,715,715,831,666,715,829,
            715,715,816,715,805,715,715,836,667,715,
            779,778,715,715,715,715,715,715,672,715,
            671,715,811,842,715,715,715,670,825,673,
            715,715,715,792,675,846,838,668,840,715,
            677,669,715,715,715,674,799,678,715,680,
            679,715,681,715,715,754,682,715,676,715,
            789,715,715,715,715,734,715,733,715,715,
            715,686,715,850,743,684,685,864,715,687,
            715,832,715,683,689,715,715,755,688,715,
            690,715,715,692,693,83,691,715,715,715,
            698,715,697,817,715,700,699,715,790,715,
            715,715,696,803,701,715,715,702,800,715,
            715,715,706,715,715,707,703,788,705,715,
            715,87,704,775,41,708,715,715,715,715,
            804,712,715,711,737,715,757,715,709,710
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }
    public final int asb(int index) { return 0; }
    public final int asr(int index) { return 0; }
    public final int nasb(int index) { return 0; }
    public final int nasr(int index) { return 0; }
    public final int terminalIndex(int index) { return 0; }
    public final int nonterminalIndex(int index) { return 0; }
    public final int scopePrefix(int index) { return 0;}
    public final int scopeSuffix(int index) { return 0;}
    public final int scopeLhs(int index) { return 0;}
    public final int scopeLa(int index) { return 0;}
    public final int scopeStateSet(int index) { return 0;}
    public final int scopeRhs(int index) { return 0;}
    public final int scopeState(int index) { return 0;}
    public final int inSymb(int index) { return 0;}
    public final String name(int index) { return null; }
    public final int originalState(int state) { return 0; }
    public final int asi(int state) { return 0; }
    public final int nasi(int state) { return 0; }
    public final int inSymbol(int state) { return 0; }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
