/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.context.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.admin.ui.context.internal.AddContextDialog;
import org.eclipse.gyrex.admin.ui.context.internal.ContextUiLabelProvider;
import org.eclipse.gyrex.admin.ui.context.internal.EditContextPrefsDialog;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.context.definitions.ContextDefinition;
import org.eclipse.gyrex.context.definitions.IRuntimeContextDefinitionManager;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.configuration.ContextConfiguration;
import org.eclipse.gyrex.context.internal.preferences.GyrexContextPreferencesImpl;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ContextsSection {
    private Composite pageComposite;
    private Button addButton;
    private Button removeButton;
    private Button editPropertiesButton;
    private ListViewer contextsList;
    protected IViewerObservableValue selectedValue;

    void addButtonPressed() {
        AddContextDialog dialog = new AddContextDialog(SwtUtil.getShell((Widget)this.addButton), this.getContextRegistry());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    ContextsSection.this.refresh();
                }
            }
        });
    }

    private Button createButton(Composite buttons, String buttonLabel) {
        Button b = new Button(buttons, 0);
        b.setText(buttonLabel);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return b;
    }

    public void createContextSectionControl(Composite parent) {
        this.pageComposite = parent;
        Infobox infobox = new Infobox(this.pageComposite);
        infobox.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        infobox.addHeading("Contexts section in Gyrex.");
        infobox.addParagraph("Gyrex provides a contextual runtime, which means it holds all its configuration information in the Context Tree, where configuration settings can be inherited and stored at the different context tree nodes. The context tree can reflect tenants or other configuration assets you build in your Gyrex application.<br/><br/>Every context is defined by name and path. ");
        Composite description = new Composite(this.pageComposite, 0);
        GridData gd = AdminUiUtil.createFillData();
        gd.verticalIndent = 10;
        description.setLayoutData((Object)gd);
        description.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin((int)2, (boolean)false));
        this.contextsList = new ListViewer(description, 2820);
        List list = this.contextsList.getList();
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.contextsList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.contextsList.setLabelProvider((IBaseLabelProvider)new ContextUiLabelProvider());
        ArrayList<ContextDefinition> definedContexts = new ArrayList<ContextDefinition>();
        for (ContextDefinition contextDefinition : this.getContextRegistry().getDefinedContexts()) {
            definedContexts.add(contextDefinition);
        }
        Collections.sort(definedContexts, new ContextDefinitionComparator());
        this.contextsList.setInput(definedContexts);
        this.selectedValue = ViewersObservables.observeSingleSelection((Viewer)this.contextsList);
        Composite buttons = new Composite(description, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true));
        buttons.setLayout((Layout)new GridLayout());
        this.addButton = this.createButton(buttons, "Add");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                ContextsSection.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttons, "Remove");
        this.removeButton.setEnabled(true);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                ContextsSection.this.removeButtonPressed();
            }
        });
        this.editPropertiesButton = this.createButton(buttons, "Edit Preferences");
        this.editPropertiesButton.setEnabled(true);
        this.editPropertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                ContextsSection.this.editPropertiesButtonPressed();
            }
        });
    }

    void editPropertiesButtonPressed() {
        ContextDefinition contextDefinition = this.getSelectedContext();
        if (contextDefinition == null) {
            return;
        }
        String path = GyrexContextPreferencesImpl.getPreferencesPathToSettings((IPath)contextDefinition.getPath(), null);
        IEclipsePreferences prefRootNode = ContextConfiguration.getRootNodeForContextPreferences();
        try {
            prefRootNode.nodeExists(path);
            Preferences prefNode = prefRootNode.node(path);
            EditContextPrefsDialog dialog = new EditContextPrefsDialog(SwtUtil.getShell((Widget)this.editPropertiesButton), prefNode);
            dialog.openNonBlocking(new DialogCallback(){
                private static final long serialVersionUID = 1L;

                public void dialogClosed(int returnCode) {
                    if (returnCode == 0) {
                        ContextsSection.this.refresh();
                    }
                }
            });
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private IRuntimeContextDefinitionManager getContextRegistry() {
        return ContextActivator.getInstance().getContextRegistryImpl();
    }

    private ContextDefinition getSelectedContext() {
        return (ContextDefinition)(this.selectedValue != null ? this.selectedValue.getValue() : null);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.contextsList;
    }

    public void refresh() {
        this.contextsList.setInput((Object)this.getContextRegistry().getDefinedContexts());
    }

    void removeButtonPressed() {
        final ContextDefinition contextDefinition = this.getSelectedContext();
        if (contextDefinition == null) {
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.pageComposite), (String)"Remove Context", (String)String.format("Do you really want to delete the context %s?", contextDefinition.getPath() + contextDefinition.getName()), (DialogCallback)new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode != 0) {
                    return;
                }
                try {
                    ContextsSection.this.getContextRegistry().removeDefinition(contextDefinition.getPath());
                }
                catch (Exception e) {
                    NonBlockingMessageDialogs.openError((Shell)SwtUtil.getShell((Widget)ContextsSection.this.pageComposite), (String)"Error", (String)e.getMessage(), (DialogCallback)new DialogCallback(){
                        private static final long serialVersionUID = 1L;

                        public void dialogClosed(int returnCode) {
                            ContextsSection.this.refresh();
                        }
                    });
                }
                ContextsSection.this.refresh();
            }
        });
    }

    private class ContextDefinitionComparator
    implements Comparator<ContextDefinition> {
        private ContextDefinitionComparator() {
        }

        @Override
        public int compare(ContextDefinition arg0, ContextDefinition arg1) {
            return arg0.getPath().toString().compareTo(arg1.getPath().toString());
        }
    }
}

