/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.internal.widgets.AdminPageWithTree;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobQueueContentProvider;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsUiActivator;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.worker.JobInfo;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ManageJobQueuePage
extends AdminPageWithTree {
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_TYPE = 1;
    private static final int COLUMN_CONTEXT = 2;
    private static final int COLUMN_AGE = 3;
    private static final int COLUMN_TRIGGER = 4;
    private Label queueLabel;

    static String toRelativeTime(long duration) {
        if (duration < TimeUnit.MINUTES.toMillis(2L)) {
            return "a minute";
        }
        if (duration < TimeUnit.HOURS.toMillis(2L)) {
            return String.format("%d minutes", TimeUnit.MILLISECONDS.toMinutes(duration));
        }
        return String.format("%d hours", TimeUnit.MILLISECONDS.toMinutes(duration));
    }

    public ManageJobQueuePage() {
        super(5);
        this.setTitle("Job Queue Contents");
    }

    protected void createButtons(Composite parent) {
    }

    protected ITreeContentProvider createContentProvider() {
        return new JobQueueContentProvider();
    }

    protected Control createHeader(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.queueLabel = new Label(composite, 1);
        return composite;
    }

    protected String getColumnLabel(int column) {
        switch (column) {
            case 0: {
                return "Job";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Context";
            }
            case 3: {
                return "Age";
            }
            case 4: {
                return "Trigger";
            }
        }
        return null;
    }

    protected String getElementLabel(Object element, int column) {
        if (element instanceof JobInfo) {
            JobInfo jobInfo = (JobInfo)element;
            switch (column) {
                case 0: {
                    return jobInfo.getJobId();
                }
                case 1: {
                    return this.getTypeName(jobInfo);
                }
                case 2: {
                    return String.valueOf(jobInfo.getContextPath());
                }
                case 3: {
                    return ManageJobQueuePage.toRelativeTime(System.currentTimeMillis() - jobInfo.getQueueTimestamp());
                }
                case 4: {
                    return jobInfo.getQueueTrigger();
                }
            }
            return null;
        }
        if (column == -1 || column == 0) {
            return String.valueOf(element);
        }
        return null;
    }

    private String getQueueId() {
        block11: {
            String[] args = this.getArguments();
            if (args.length <= 1 || !StringUtils.isNotBlank((String)args[1])) break block11;
            switch (args[1]) {
                case "default": {
                    return "gyrex.jobs.queue.default";
                }
                case "priority": {
                    return "gyrex.jobs.queue.priority";
                }
            }
            if (IdHelper.isValidId((String)args[1])) {
                return args[1];
            }
        }
        return "gyrex.jobs.queue.default";
    }

    private IQueueService getQueueService() {
        return (IQueueService)JobsUiActivator.getInstance().getService(IQueueService.class);
    }

    private String getTypeName(JobInfo info) {
        String name = JobsActivator.getInstance().getJobProviderRegistry().getName(info.getJobTypeId());
        if (StringUtils.isNotBlank((String)name)) {
            return name;
        }
        return "unknown (" + info.getJobTypeId() + ")";
    }

    protected Object getViewerInput() {
        String queueId = this.getQueueId();
        IQueue queue = this.getQueueService().getQueue(queueId, null);
        if (queue != null) {
            return queue;
        }
        return Collections.singleton(String.format("Queue '%s' not available!", queueId));
    }

    protected boolean isColumnSortable(int column) {
        return false;
    }

    public void setArguments(String[] args) {
        super.setArguments(args);
    }

    protected void updateButtons() {
        this.updateQueueLabel();
    }

    private void updateQueueLabel() {
        int count;
        String queueId = this.getQueueId();
        StringBuilder text = new StringBuilder();
        switch (queueId) {
            case "gyrex.jobs.queue.default": {
                text.append("Default Job Queue");
                break;
            }
            case "gyrex.jobs.queue.priority": {
                text.append("Priority Job Queue");
                break;
            }
            default: {
                text.append("Custom Queue: ").append(queueId);
            }
        }
        IQueue queue = this.getQueueService().getQueue(queueId, null);
        int n = count = queue != null ? queue.size() : -1;
        if (count > 1 || count == 0) {
            text.append(" (").append(count).append(" jobs)");
        } else if (count == 1) {
            text.append(" (").append(count).append(" job)");
        }
        this.queueLabel.setText(text.toString());
        this.queueLabel.getParent().layout();
    }
}

