/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.widgets;

import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class Statusbox
extends Composite {
    private static final long serialVersionUID = 1L;
    private final Composite contentComp;
    private final Status status;

    public Statusbox(Composite parent, Status status) {
        super(parent, 0);
        this.status = status;
        this.setLayout((Layout)AdminUiUtil.createGridLayout(1, false, true, false));
        this.setLayoutData(AdminUiUtil.createFillData());
        this.contentComp = this.createInfoboxContentComposite();
    }

    public void addHeading(String text) {
        Label label = new Label(this.contentComp, 0);
        label.setText(text.replace("&", "&&"));
        label.setData("org.eclipse.rap.rwt.customVariant", (Object)(String.valueOf(this.getStatusVariant()) + "heading"));
    }

    public void addLink(String text, SelectionListener selectionListener) {
        Link link = new Link(this.contentComp, 64);
        link.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getStatusVariant());
        link.setText(text);
        link.setLayoutData((Object)AdminUiUtil.createFillData());
        link.addSelectionListener(selectionListener);
    }

    public void addParagraph(String text) {
        Label label = new Label(this.contentComp, 64);
        label.setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        label.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getStatusVariant());
        label.setText(text);
        label.setLayoutData((Object)AdminUiUtil.createFillData());
    }

    private Composite createInfoboxContentComposite() {
        Composite contentComp = new Composite((Composite)this, 0);
        contentComp.setBackgroundMode(2);
        contentComp.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getStatusVariant());
        GridLayout layout = AdminUiUtil.createGridLayoutWithoutMargin(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        contentComp.setLayout((Layout)layout);
        contentComp.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        return contentComp;
    }

    public Status getStatus() {
        return this.status;
    }

    private String getStatusVariant() {
        switch (this.getStatus()) {
            case Warning: {
                return "statusbox-warning";
            }
        }
        return "statusbox-error";
    }

    public static enum Status {
        Error,
        Warning;

    }
}

