/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.runtime;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.gyrex.common.debug.BundleDebugOptions;
import org.eclipse.gyrex.common.lifecycle.IShutdownParticipant;
import org.eclipse.gyrex.common.services.BundleServiceHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBundleActivator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(BaseBundleActivator.class);
    private final ListenerList shutdownParticipants = new ListenerList(1);
    private final String symbolicName;
    private final AtomicReference<Bundle> bundle = new AtomicReference();
    private final AtomicReference<Version> bundleVersion = new AtomicReference();
    private final AtomicReference<BundleServiceHelper> serviceHelper = new AtomicReference();
    private final AtomicBoolean active = new AtomicBoolean(false);

    public BaseBundleActivator(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public final void addShutdownParticipant(IShutdownParticipant shutdownParticipant) {
        this.shutdownParticipants.add((Object)shutdownParticipant);
    }

    protected final void checkActive() throws IllegalStateException {
        if (this.bundle == null) {
            throw this.createBundleInactiveException();
        }
    }

    protected final IllegalStateException createBundleInactiveException() {
        return new IllegalStateException(MessageFormat.format("Bundle ''{0}'' is inactive.", this.getSymbolicName()));
    }

    protected void doStart(BundleContext context) throws Exception {
    }

    protected void doStop(BundleContext context) throws Exception {
    }

    public final Bundle getBundle() {
        return this.bundle.get();
    }

    public final Version getBundleVersion() {
        Version bundleVersion = this.bundleVersion.get();
        if (bundleVersion != null) {
            return bundleVersion;
        }
        Bundle bundle = this.bundle.get();
        if (bundle == null) {
            return Version.emptyVersion;
        }
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        if (version == null) {
            return Version.emptyVersion;
        }
        this.bundleVersion.set(Version.parseVersion((String)version));
        return this.bundleVersion.get();
    }

    protected Class<?> getDebugOptions() {
        return null;
    }

    public final <T> T getService(Class<T> serviceClass) throws IllegalStateException {
        return this.getServiceHelper().trackService(serviceClass).getService();
    }

    public final BundleServiceHelper getServiceHelper() throws IllegalStateException {
        BundleServiceHelper bundleServiceHelper = this.serviceHelper.get();
        if (bundleServiceHelper == null) {
            throw this.createBundleInactiveException();
        }
        return bundleServiceHelper;
    }

    public final String getSymbolicName() {
        return this.symbolicName;
    }

    public final boolean isActive() {
        return this.active.get();
    }

    public final void removeShutdownParticipant(IShutdownParticipant shutdownParticipant) {
        this.shutdownParticipants.remove((Object)shutdownParticipant);
    }

    public final void start(BundleContext context) throws Exception {
        if (!context.getBundle().getSymbolicName().equals(this.getSymbolicName())) {
            String errorMessage = MessageFormat.format("Declared bundle symbolic name ''{0}'' does not match defined bundle symbolic name ''{1}''!", this.getSymbolicName(), context.getBundle().getSymbolicName());
            System.err.println(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        this.bundle.set(context.getBundle());
        Class<?> debugOptions = this.getDebugOptions();
        if (debugOptions != null) {
            BundleDebugOptions.initializeDebugOptions(this, debugOptions);
        }
        this.serviceHelper.set(new BundleServiceHelper(context));
        this.doStart(context);
        this.active.set(true);
    }

    public final void stop(BundleContext context) throws Exception {
        this.active.set(false);
        try {
            Object[] participants;
            Object[] objectArray = participants = this.shutdownParticipants.getListeners();
            int n = participants.length;
            int n2 = 0;
            while (n2 < n) {
                Object participant = objectArray[n2];
                try {
                    ((IShutdownParticipant)participant).shutdown();
                }
                catch (Exception e) {
                    LOG.warn("Error while shutting down shutdown participant ({}). {}", new Object[]{participant, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                }
                ++n2;
            }
            this.shutdownParticipants.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.doStop(context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((BundleServiceHelper)this.serviceHelper.getAndSet(null)).dispose();
        this.bundle.set(null);
        this.bundleVersion.set(null);
    }
}

