/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.commands;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.definitions.ContextDefinition;
import org.eclipse.gyrex.context.internal.commands.BaseContextDefinitionCmd;
import org.eclipse.gyrex.context.internal.configuration.ContextConfiguration;
import org.kohsuke.args4j.Option;

public class LsContextFilterCmd
extends BaseContextDefinitionCmd {
    @Option(name="-r", aliases={"--recursive"}, usage="enabled recursive lookup till the root context", required=false)
    boolean recursive;

    public LsContextFilterCmd() {
        super("<path> - lists context filters");
    }

    @Override
    protected void doExecute(ContextDefinition contextDefinition) throws Exception {
        if (!this.recursive) {
            this.listFilters(contextDefinition.getPath());
            return;
        }
        IPath path = contextDefinition.getPath();
        while (path != null && !path.isRoot()) {
            this.listFilters(path);
            this.printf("", new Object[0]);
            path = path.removeLastSegments(1);
        }
        this.listFilters((IPath)Path.ROOT);
    }

    private void listFilters(IPath path) {
        Map<String, String> filters = ContextConfiguration.getFilters(path);
        if (filters.isEmpty()) {
            this.printf("%s:%n  no filters configured", new Object[]{path.toString()});
            return;
        }
        this.printf("%s:", new Object[]{path});
        for (Map.Entry<String, String> e : new TreeMap<String, String>(filters).entrySet()) {
            this.printf("  %-60s   %s", new Object[]{e.getKey(), e.getValue()});
        }
    }
}

