/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.manager;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.common.lifecycle.IShutdownParticipant;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.configuration.ContextConfiguration;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.gyrex.context.manager.IRuntimeContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextManagerImpl
implements IRuntimeContextManager,
IShutdownParticipant {
    private static final Logger LOG = LoggerFactory.getLogger(ContextManagerImpl.class);
    private final ContextRegistryImpl contextRegistry;

    public ContextManagerImpl(ContextRegistryImpl contextRegistry) {
        this.contextRegistry = contextRegistry;
    }

    @Override
    public void set(IRuntimeContext context, Class<?> type, String filter) {
        ContextConfiguration.setFilter(context.getContextPath(), type.getName(), filter);
        try {
            this.contextRegistry.flushContextHierarchy(context.getContextPath());
        }
        catch (Exception e) {
            LOG.warn("Unable to flush context hierarchy {}: {}", new Object[]{context.getContextPath(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
    }

    public void shutdown() throws Exception {
    }
}

