/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.staticresource;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.context.IResourceProvider;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.osgi.framework.Bundle;

public class StaticResourceApplication
extends Application {
    private final Bundle bundle;
    private final String bundleResourcePath;
    private final String devModeDocRootEnvVar;

    public StaticResourceApplication(String applicationId, IRuntimeContext context, Bundle bundle, String bundleResourcePath, String devModeDocRootEnvVar) {
        super(applicationId, context);
        this.bundle = bundle;
        this.bundleResourcePath = bundleResourcePath;
        this.devModeDocRootEnvVar = devModeDocRootEnvVar;
    }

    @Override
    protected void doInit() throws IllegalStateException, Exception {
        this.getApplicationContext().registerResources("/", "", new IResourceProvider(){

            @Override
            public URL getResource(String path) throws MalformedURLException {
                if (Platform.inDevelopmentMode() && StaticResourceApplication.this.devModeDocRootEnvVar != null && System.getenv(StaticResourceApplication.this.devModeDocRootEnvVar) != null) {
                    File file = new File(System.getenv(StaticResourceApplication.this.devModeDocRootEnvVar), path);
                    if (file.exists()) {
                        return file.toURI().toURL();
                    }
                    return null;
                }
                return StaticResourceApplication.this.bundle.getEntry(new Path(StaticResourceApplication.this.bundleResourcePath).append(path).toString());
            }

            @Override
            public Set<String> getResourcePaths(String path) {
                return null;
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ErrorHandler.class) {
            ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
            errorHandler.addErrorPage(404, "/error/404.html");
            errorHandler.addErrorPage("org.eclipse.jetty.server.error_page.global", "/error/error.html");
            return errorHandler;
        }
        return super.getAdapter(adapter);
    }
}

