/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.tests.internal.storage;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.IModifiableRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.IJob;
import org.eclipse.gyrex.jobs.history.IJobHistory;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.eclipse.gyrex.jobs.spi.storage.IJobHistoryStorage;
import org.eclipse.gyrex.jobs.spi.storage.JobHistoryEntryStorable;
import org.eclipse.gyrex.jobs.tests.internal.JobsTestsActivator;
import org.eclipse.gyrex.junit.GyrexServerResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class MockStorageTest {
    @ClassRule
    public static final GyrexServerResource server = new GyrexServerResource();
    private IRuntimeContextRegistry contextRegistry;
    private IModifiableRuntimeContext testContext;

    @Before
    public void setUp() throws Exception {
        this.contextRegistry = (IRuntimeContextRegistry)JobsTestsActivator.getInstance().getService(IRuntimeContextRegistry.class);
        this.testContext = this.contextRegistry.get((IPath)Path.ROOT).createWorkingCopy();
    }

    @After
    public void tearDown() throws Exception {
        this.testContext.dispose();
        this.testContext = null;
        this.contextRegistry = null;
    }

    @Test
    public void test() {
        final TreeSet<JobHistoryEntryStorable> history = new TreeSet<JobHistoryEntryStorable>();
        this.testContext.setLocal(IJobHistoryStorage.class, (Object)new IJobHistoryStorage(){

            public void add(String jobId, JobHistoryEntryStorable historyEntry) throws Exception {
                history.add(historyEntry);
            }

            public int count(String jobId) throws Exception {
                return history.size();
            }

            public Collection<JobHistoryEntryStorable> find(String jobId, int offset, int fetchSize) throws Exception {
                return history;
            }
        });
        String jobId = "test" + System.nanoTime();
        IJobManager jobManager = (IJobManager)this.testContext.get(IJobManager.class);
        IJob job = jobManager.createJob("tests.testable.job", jobId, null);
        Assert.assertNotNull((Object)job);
        IJobHistory jobHistory = jobManager.getHistory(jobId);
        Assert.assertNotNull((Object)jobHistory);
        Assert.assertNotNull((Object)jobHistory.getEntries());
        Assert.assertTrue((boolean)jobHistory.getEntries().isEmpty());
        history.add(new JobHistoryEntryStorable());
        jobHistory = jobManager.getHistory(jobId);
        Assert.assertNotNull((Object)jobHistory);
        Assert.assertNotNull((Object)jobHistory.getEntries());
        Assert.assertFalse((boolean)jobHistory.getEntries().isEmpty());
        Iterator stream = jobHistory.getEntries().iterator();
        Assert.assertTrue((boolean)stream.hasNext());
        Assert.assertNotNull(stream.next());
        Assert.assertFalse((boolean)stream.hasNext());
        try {
            stream.next();
            Assert.fail((String)"missing NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((long)jobHistory.getEntries().size(), (long)jobHistory.getEntries().toArray().length);
    }
}

