/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.commands;

import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.jobs.internal.storage.CloudPreferencesCleanupJob;
import org.kohsuke.args4j.Option;

public class CleanupCmd
extends Command {
    @Option(name="-days", aliases={"--max-days-since-last-run"}, usage="the number of days worth of job history to keep")
    Integer maxDays;

    public CleanupCmd() {
        super("triggers a clean up of old and hung jobs");
    }

    protected void doExecute() throws Exception {
        CloudPreferencesCleanupJob job = new CloudPreferencesCleanupJob();
        if (this.maxDays != null && this.maxDays > 0) {
            job.setMaxDaysSinceLastRun(this.maxDays);
        }
        job.schedule();
        this.printf("Cleanup started and expected to finish asynchronously!", new Object[0]);
    }
}

