/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.util;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.context.IRuntimeContext;

public class ContextHashUtil {
    private static final String SEPARATOR = "_";
    private final String internalIdPrefix;

    public static String getExternalId(String internalId) {
        int i = internalId.indexOf(SEPARATOR);
        if (i < 0) {
            return internalId;
        }
        return internalId.substring(i + 1);
    }

    private static String getInternalIdPrefix(IPath contextPath) {
        try {
            return String.valueOf(DigestUtils.shaHex((byte[])contextPath.toString().getBytes("UTF-8"))) + SEPARATOR;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Please use a JVM that supports UTF-8.");
        }
    }

    public ContextHashUtil(IPath contextPath) {
        this.internalIdPrefix = ContextHashUtil.getInternalIdPrefix(contextPath);
    }

    public ContextHashUtil(IRuntimeContext context) {
        this.internalIdPrefix = ContextHashUtil.getInternalIdPrefix(context.getContextPath());
    }

    public boolean isInternalId(String internalId) {
        return internalId != null && internalId.startsWith(this.internalIdPrefix);
    }

    public String toExternalId(String internalId) {
        return StringUtils.removeStart((String)internalId, (String)this.internalIdPrefix);
    }

    public String toInternalId(String id) {
        return this.internalIdPrefix.concat(id);
    }

    public String toString() {
        return this.internalIdPrefix;
    }
}

