/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.spi.storage;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;

public class JobHistoryEntryStorable
implements Comparable<JobHistoryEntryStorable> {
    private IStatus result;
    private long timestamp;
    private String queuedTrigger;
    private String cancelledTrigger;
    private Map<String, String> parameter;

    @Override
    public int compareTo(JobHistoryEntryStorable o) {
        long t1 = this.getTimestamp();
        long t2 = o.getTimestamp();
        if (t2 > t1) {
            return 1;
        }
        if (t2 < t1) {
            return -1;
        }
        if (o.getResult().getSeverity() == this.getResult().getSeverity()) {
            return this.getResult().getMessage().compareTo(o.getResult().getMessage());
        }
        return this.getResult().getSeverity() > o.getResult().getSeverity() ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobHistoryEntryStorable other = (JobHistoryEntryStorable)obj;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.result == null) {
            return other.result == null;
        }
        if (other.result == null) {
            return this.result == null;
        }
        if (!this.result.getMessage().equals(other.result.getMessage())) {
            return false;
        }
        return this.result.getSeverity() == other.result.getSeverity();
    }

    public String getCancelledTrigger() {
        return this.cancelledTrigger;
    }

    public Map<String, String> getParameter() {
        return this.parameter;
    }

    public String getQueuedTrigger() {
        return this.queuedTrigger;
    }

    public IStatus getResult() {
        return this.result;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.result != null) {
            result = 31 * result + this.result.getMessage().hashCode();
            result = 31 * result + this.result.getSeverity();
        }
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public void setCancelledTrigger(String cancelledTrigger) {
        this.cancelledTrigger = cancelledTrigger;
    }

    public void setParameter(Map<String, String> parameter) {
        this.parameter = parameter;
    }

    public void setQueuedTrigger(String queuedTrigger) {
        this.queuedTrigger = queuedTrigger;
    }

    public void setResult(IStatus result) {
        this.result = result;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

