/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.junit.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GyrexStarter {
    private static final Logger LOG = LoggerFactory.getLogger(GyrexStarter.class);
    private final BundleContext context;
    private final Job shutdownJob = new Job("Gyrex Shutdown Delay"){

        protected IStatus run(IProgressMonitor monitor) {
            GyrexStarter.this.shutdown();
            return Status.OK_STATUS;
        }
    };
    private ApplicationHandle applicationHandle;

    public GyrexStarter(BundleContext context) {
        this.context = context;
    }

    private void bootstrapBundles() throws BundleException {
        HashSet<String> requiredBundles = new HashSet<String>();
        requiredBundles.add("org.eclipse.equinox.app");
        requiredBundles.add("org.eclipse.equinox.registry");
        requiredBundles.add("org.eclipse.equinox.common");
        requiredBundles.add("org.eclipse.equinox.ds");
        requiredBundles.add("org.eclipse.equinox.event");
        HashSet<String> started = new HashSet<String>();
        Bundle[] bundleArray = this.context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            LOG.trace("Found bundle: {}", (Object)bundle);
            if (requiredBundles.contains(bundle.getSymbolicName())) {
                if ((bundle.getState() & 3) == 0) {
                    if (started.contains(bundle.getSymbolicName())) {
                        throw new IllegalStateException(String.format("Please check your test environment. It looks like multiple versions for bundle '%s' are installed in the framework which is not supported.", bundle.getSymbolicName()));
                    }
                    started.add(bundle.getSymbolicName());
                    LOG.info("Starting required bundle: {}", (Object)bundle);
                    bundle.start(1);
                } else {
                    LOG.warn("Found unresolved required bundle: {}", (Object)bundle);
                }
            }
            ++n2;
        }
        int diff = requiredBundles.size() - started.size();
        if (diff > 0) {
            StrBuilder errorMessage = new StrBuilder(diff > 1 ? "The following bundles are missing: " : "The following bundle is missing: ");
            for (String name : requiredBundles) {
                String separator = "";
                if (started.contains(name)) continue;
                errorMessage.append(separator).append(name);
                separator = ", ";
            }
            throw new IllegalStateException(errorMessage.toString());
        }
    }

    public synchronized void dispose() {
        this.shutdownJob.cancel();
        this.shutdown();
    }

    public synchronized boolean ensureStartedAndOnline() throws Exception {
        this.shutdownJob.cancel();
        if (this.applicationHandle != null) {
            LOG.debug("Gyrex already running!");
            return false;
        }
        LOG.debug("Starting Gyrex");
        this.bootstrapBundles();
        if (Boolean.getBoolean("gyrex.preferences.instancebased")) {
            LOG.warn("Overriding system propert 'gyrex.preferences.instancebased' in order to force ZooKeeper based cloud preferences!");
            System.setProperty("gyrex.preferences.instancebased", Boolean.FALSE.toString());
        }
        final CountDownLatch cloudOnlineWatch = new CountDownLatch(1);
        EventHandler cloudOnlineHandler = new EventHandler(){

            public void handleEvent(Event event) {
                cloudOnlineWatch.countDown();
            }
        };
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        properties.put("event.topics", "org/eclipse/gyrex/cloud/node/online");
        this.context.registerService(EventHandler.class, (Object)cloudOnlineHandler, properties);
        HashMap<String, String[]> args = new HashMap<String, String[]>();
        args.put("application.args", new String[]{"-roles", "org.eclipse.gyrex.cloud.roles.coordinator,org.eclipse.gyrex.cloud.roles.leader"});
        Collection refs = this.context.getServiceReferences(ApplicationDescriptor.class, "(service.pid=org.eclipse.gyrex.boot.server)");
        Assert.assertEquals((String)"Unable to find proper Gyrex Server application to start!", (int)1, (int)refs.size());
        ServiceReference sr = (ServiceReference)refs.iterator().next();
        ApplicationDescriptor service = (ApplicationDescriptor)this.context.getService(sr);
        try {
            this.applicationHandle = service.launch(args);
        }
        finally {
            this.context.ungetService(sr);
        }
        long timeout = Long.getLong("gyrex.servertestapp.timeout", 60000L);
        LOG.info("Waiting {}ms for node to become online...", (Object)timeout);
        if (!cloudOnlineWatch.await(timeout, TimeUnit.MILLISECONDS)) {
            LOG.error("Timeout waiting for node to become online.");
            throw new IllegalStateException("Timeout while waiting for node to establish connection with ZooKeeper. Unable to initialize cloud environment.");
        }
        return true;
    }

    public synchronized void requestShutdown() {
        LOG.debug("Gyrex shutdown requested");
        this.shutdownJob.schedule(30000L);
    }

    void shutdown() {
        LOG.debug("Shutting down Gyrex");
        if (this.applicationHandle != null) {
            this.applicationHandle.destroy();
            this.applicationHandle = null;
        }
    }
}

