/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.model;

import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.logback.config.model.Appender;

public class FileAppender
extends Appender {
    private String fileName;
    private RotationPolicy rotationPolicy;
    private String maxFileSize;
    private String maxHistory;
    private boolean compressRotatedLogs;

    public FileAppender() {
        super("file");
    }

    @Override
    public final boolean canSift() {
        return true;
    }

    @Override
    public String getAppenderClassName() {
        return RollingFileAppender.class.getName();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public String getMaxHistory() {
        return this.maxHistory;
    }

    public RotationPolicy getRotationPolicy() {
        return this.rotationPolicy;
    }

    public boolean isCompressRotatedLogs() {
        return this.compressRotatedLogs;
    }

    public void setCompressRotatedLogs(boolean compressRotatedLogs) {
        this.compressRotatedLogs = compressRotatedLogs;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxHistory(String maxHistory) {
        this.maxHistory = maxHistory;
    }

    public void setRotationPolicy(RotationPolicy rotationPolicy) {
        this.rotationPolicy = rotationPolicy;
    }

    @Override
    protected void writeAppenderContent(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("file");
        writer.writeCharacters(String.format("${BASE_PATH}/%s", this.getFileName()));
        writer.writeEndElement();
        this.writeRotation(writer);
    }

    private void writeRotation(XMLStreamWriter writer) throws XMLStreamException {
        RotationPolicy policy = this.getRotationPolicy();
        if (policy == null) {
            return;
        }
        switch (policy) {
            case SIZE: {
                this.writeSizeBasedRotation(writer);
                break;
            }
            default: {
                this.writeTimeBasedRotation(writer, policy);
            }
        }
    }

    private void writeSizeBasedRotation(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("rollingPolicy");
        writer.writeAttribute("class", FixedWindowRollingPolicy.class.getName());
        writer.writeStartElement("fileNamePattern");
        writer.writeCharacters(StringUtils.substringBeforeLast((String)this.getFileName(), (String)"."));
        writer.writeCharacters(".%i");
        String extension = StringUtils.substringAfter((String)this.getFileName(), (String)".");
        if (StringUtils.isNotBlank((String)extension)) {
            writer.writeCharacters(".");
            writer.writeCharacters(extension);
        }
        if (this.isCompressRotatedLogs()) {
            writer.writeCharacters(".gz");
        }
        writer.writeEndElement();
        writer.writeStartElement("minIndex");
        writer.writeCharacters("1");
        writer.writeEndElement();
        writer.writeStartElement("maxIndex");
        writer.writeCharacters("3");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("triggeringPolicy");
        writer.writeAttribute("class", SizeBasedTriggeringPolicy.class.getName());
        String maxFileSize = this.getMaxFileSize();
        if (StringUtils.isBlank((String)maxFileSize)) {
            maxFileSize = "1MB";
        }
        writer.writeStartElement("maxFileSize");
        writer.writeCharacters(maxFileSize);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeTimeBasedRotation(XMLStreamWriter writer, RotationPolicy policy) throws XMLStreamException {
        writer.writeStartElement("rollingPolicy");
        writer.writeAttribute("class", TimeBasedRollingPolicy.class.getName());
        writer.writeStartElement("fileNamePattern");
        writer.writeCharacters(StringUtils.substringBeforeLast((String)this.getFileName(), (String)"."));
        switch (policy) {
            case MONTHLY: {
                writer.writeCharacters(".%d{yyyyMM}");
                break;
            }
            case WEEKLY: {
                writer.writeCharacters(".%d{yyyyww}");
                break;
            }
            default: {
                writer.writeCharacters(".%d{yyyyMMdd}");
            }
        }
        String extension = StringUtils.substringAfter((String)this.getFileName(), (String)".");
        if (StringUtils.isNotBlank((String)extension)) {
            writer.writeCharacters(".");
            writer.writeCharacters(extension);
        }
        if (this.isCompressRotatedLogs()) {
            writer.writeCharacters(".gz");
        }
        writer.writeEndElement();
        writer.writeStartElement("maxHistory");
        String maxHistory = this.getMaxHistory();
        if (StringUtils.isBlank((String)maxHistory)) {
            maxHistory = policy == RotationPolicy.DAILY ? "30" : (policy == RotationPolicy.WEEKLY ? "52" : "12");
        }
        writer.writeCharacters(maxHistory);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public static enum RotationPolicy {
        DAILY,
        WEEKLY,
        MONTHLY,
        SIZE;

    }
}

