/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.model.common;

import java.text.MessageFormat;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.model.common.IModelManager;

public final class ModelUtil {
    public static <M extends IModelManager> M getManager(Class<M> managerType, IRuntimeContext context) throws IllegalArgumentException, IllegalStateException {
        if (managerType == null) {
            throw new IllegalArgumentException("manager type must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        IModelManager manager = (IModelManager)context.get(managerType);
        if (manager == null) {
            throw new IllegalStateException(MessageFormat.format("No model manager implementation available for type ''{0}'' in context ''{1}''", managerType.getName(), context.getContextPath()));
        }
        return (M)manager;
    }

    private ModelUtil() {
    }
}

