/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.metrics;

import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;
import org.eclipse.gyrex.monitoring.metrics.MetricAttribute;

public class ErrorMetric
extends BaseMetric {
    private static final ErrorStats[] NO_STATS = new ErrorStats[0];
    private static final String EMPTY = "";
    private volatile String lastError = "";
    private volatile String lastErrorDetails = "";
    private volatile long lastErrorChangeTime;
    private volatile long totalNumberOfErrors;
    private final LinkedHashMap<String, ErrorStats> errorStats;

    public ErrorMetric(String id, final int errorStatsCapacity) {
        super(id);
        this.errorStats = errorStatsCapacity > 0 ? new LinkedHashMap<String, ErrorStats>(4, 0.75f, true){
            private static final long serialVersionUID = 5450217680895615135L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ErrorStats> eldest) {
                return this.size() > errorStatsCapacity;
            }
        } : null;
    }

    @Override
    void doResetStats() {
        this.totalNumberOfErrors = 0L;
        if (this.errorStats != null) {
            this.errorStats.clear();
        }
    }

    @Override
    Object[] dumpMetrics() {
        return new Object[]{"error|detail|since|total errors", this.getLastError(), this.getLastErrorDetails(), this.getLastErrorChangeTime(), this.getTotalNumberOfErrors()};
    }

    public ErrorStats[] getErrorStats() {
        if (this.errorStats != null) {
            int tries = 0;
            while (true) {
                try {
                    return this.errorStats.values().toArray(NO_STATS);
                }
                catch (ConcurrentModificationException e) {
                    if (++tries < 3) continue;
                }
                break;
            }
        }
        return NO_STATS;
    }

    public String getLastError() {
        return this.lastError;
    }

    public String getLastErrorChangeTime() {
        return ISO_8601_UTC.format(new Date(this.lastErrorChangeTime));
    }

    public String getLastErrorDetails() {
        return this.lastErrorDetails;
    }

    public long getTotalNumberOfErrors() {
        return this.totalNumberOfErrors;
    }

    @Override
    void populateAttributes(List<MetricAttribute> attributes) {
        super.populateAttributes(attributes);
        attributes.add(new MetricAttribute("lastError", "the last error", String.class));
        attributes.add(new MetricAttribute("lastErrorDetails", "the last error details (eg. stack trace)", String.class));
        attributes.add(new MetricAttribute("lastErrorChangeTime", "the last error time", String.class));
        attributes.add(new MetricAttribute("totalNumberOfErrors", "a total number of errors since the last reset", Long.class));
    }

    @Override
    void populateAttributeValues(Map<String, Object> values) {
        super.populateAttributeValues(values);
        values.put("lastError", this.getLastError());
        values.put("lastErrorDetails", this.getLastErrorDetails());
        values.put("lastErrorChangeTime", this.getLastErrorChangeTime());
        values.put("totalNumberOfErrors", this.getTotalNumberOfErrors());
    }

    public void setLastError(String error, String errorDetails) {
        if (error == null) {
            throw new IllegalArgumentException("error may not be null");
        }
        if (errorDetails == null) {
            throw new IllegalArgumentException("error details may not be null");
        }
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            this.lastError = error;
            this.lastErrorDetails = errorDetails;
            this.lastErrorChangeTime = System.currentTimeMillis();
            ++this.totalNumberOfErrors;
            if (this.errorStats != null) {
                String key = error.concat(errorDetails);
                if (!this.errorStats.containsKey(key)) {
                    this.errorStats.put(key, new ErrorStats(error, errorDetails));
                }
                this.errorStats.get(key).errorOccured();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public static final class ErrorStats {
        private final String error;
        private final String errorDetails;
        private volatile long errorOccuredCount;

        ErrorStats(String error, String errorDetails) {
            this.error = error;
            this.errorDetails = errorDetails;
        }

        void errorOccured() {
            ++this.errorOccuredCount;
        }

        public String getError() {
            return this.error;
        }

        public String getErrorDetails() {
            return this.errorDetails;
        }

        public long getErrorOccuredCount() {
            return this.errorOccuredCount;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Error [").append(this.error).append("] with details [").append(this.errorDetails).append("] occured ").append(this.errorOccuredCount).append(" time(s).");
            return builder.toString();
        }
    }
}

