/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.tests.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import javax.inject.Inject;
import junit.framework.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.persistence.storage.content.IRepositoryContentTypeProvider;
import org.eclipse.gyrex.persistence.storage.content.RepositoryContentType;
import org.eclipse.gyrex.persistence.storage.di.RequiredContentType;
import org.eclipse.gyrex.persistence.storage.lookup.DefaultRepositoryLookupStrategy;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.gyrex.persistence.storage.registry.IRepositoryRegistry;
import org.eclipse.gyrex.persistence.tests.internal.DummyRepo;
import org.eclipse.gyrex.persistence.tests.internal.DummyRepoProvider;
import org.eclipse.gyrex.persistence.tests.internal.PersistenceTestsActivator;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class RepositoryInjectionTest {
    public static final RepositoryContentType CONTENT_TYPE = new RepositoryContentType("x-gyrex", "test", DummyRepo.class.getName(), "1.0");
    private final IRepositoryContentTypeProvider provider = new IRepositoryContentTypeProvider(){

        public Collection<RepositoryContentType> getContentTypes() {
            return Collections.singleton(CONTENT_TYPE);
        }
    };
    private ServiceRegistration<IRepositoryContentTypeProvider> contentTypeProviderServiceReg;
    private ServiceRegistration<RepositoryProvider> repoProviderServiceReg;
    private IRepositoryRegistry registry;
    private IRuntimeContext context;

    @After
    public void after() throws Exception {
        DefaultRepositoryLookupStrategy.getDefault().setRepository(this.context, CONTENT_TYPE, null);
        this.context = null;
        this.registry.removeRepository("dummy");
        this.registry = null;
        this.repoProviderServiceReg.unregister();
        this.repoProviderServiceReg = null;
        this.contentTypeProviderServiceReg.unregister();
        this.contentTypeProviderServiceReg = null;
    }

    @Before
    public void before() throws Exception {
        BundleContext bc = PersistenceTestsActivator.getContext();
        Hashtable properties = new Hashtable();
        this.contentTypeProviderServiceReg = bc.registerService(IRepositoryContentTypeProvider.class, (Object)this.provider, properties);
        this.repoProviderServiceReg = bc.registerService(RepositoryProvider.class, (Object)new DummyRepoProvider(), properties);
        this.registry = (IRepositoryRegistry)PersistenceTestsActivator.getInstance().getService(IRepositoryRegistry.class);
        this.registry.removeRepository("dummy");
        this.registry.createRepository("dummy", "dummy");
        this.context = ((IRuntimeContextRegistry)PersistenceTestsActivator.getInstance().getService(IRuntimeContextRegistry.class)).get((IPath)Path.ROOT);
        DefaultRepositoryLookupStrategy.getDefault().setRepository(this.context, CONTENT_TYPE, "dummy");
    }

    @Test
    public void testInjection() {
        IRuntimeContext context = ((IRuntimeContextRegistry)PersistenceTestsActivator.getInstance().getService(IRuntimeContextRegistry.class)).get((IPath)Path.ROOT);
        try {
            InjectiblePojo pojo = (InjectiblePojo)context.getInjector().make(InjectiblePojo.class);
            Assert.assertNotNull((String)"Repository must be set!", (Object)((Object)pojo.repo));
        }
        catch (InjectionException e) {
            e.printStackTrace();
            Assert.fail((String)("Injection failed: " + (Object)((Object)e)));
        }
    }

    public static class InjectiblePojo {
        @Inject
        @RequiredContentType(value="x-gyrex/test")
        DummyRepo repo;
    }
}

