/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.console;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.persistence.internal.PersistenceActivator;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryProviderRegistry;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class LsProviders
extends Command {
    @Option(name="-v", aliases={"--verbose"}, usage="prints detailed configuration information")
    protected boolean verbose = false;
    @Argument(index=0, metaVar="ID-SUB-STRING", usage="provider sub-string filter")
    protected String filter;

    public LsProviders() {
        super("- lists available repositories");
    }

    protected void doExecute() throws Exception {
        RepositoryProviderRegistry providerRegistry = PersistenceActivator.getInstance().getRepositoryProviderRegistry();
        List<RepositoryProviderRegistry.RepositoryProviderRegistration> registrations = providerRegistry.getAllProviderRegistrations();
        if (registrations.isEmpty()) {
            this.printf("No providers registered!", new Object[0]);
            return;
        }
        Collections.sort(registrations, new Comparator<RepositoryProviderRegistry.RepositoryProviderRegistration>(){

            @Override
            public int compare(RepositoryProviderRegistry.RepositoryProviderRegistration o1, RepositoryProviderRegistry.RepositoryProviderRegistration o2) {
                return o1.getProviderId().compareTo(o2.getProviderId());
            }
        });
        for (RepositoryProviderRegistry.RepositoryProviderRegistration providerRegistration : registrations) {
            this.printf("%s [%s]", new Object[]{providerRegistration.getProviderId(), StringUtils.trimToEmpty((String)providerRegistration.getProviderInfo())});
        }
    }
}

